/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.sdservices;

import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.objectflow.runtime.MoWareFormattersFactory;
import org.modellwerkstatt.objectflow.runtime.OFXBigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXDateTime;
import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.OFXList;
import org.modellwerkstatt.objectflow.runtime.OFXLocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXVPBase;
import org.modellwerkstatt.objectflow.runtime.OFXValueObject;
import org.modellwerkstatt.objectflow.sdservices.ILgcyGraphPrinter;
import org.modellwerkstatt.objectflow.sdservices.LgcyGraphIntrospector;

public class LgcyFopGraphPrinter
implements ILgcyGraphPrinter {
    private static final String INDENT = "   ";
    public static DateTimeFormatter xfoDateOnlyFormatter = MoWareFormattersFactory.forDateTimePattern("EEE dd.MM.yyyy", "de");
    public static DateTimeFormatter xfoDesignerFormatterTime = MoWareFormattersFactory.forDateTimePattern("yyyy'-'MM'-'dd'T'HH':'mm':'ss", "de");
    public static DateTimeFormatter xfoDesignerFormatterDate = MoWareFormattersFactory.forDateTimePattern("yyyy'-'MM'-'dd", "de");
    private LgcyGraphIntrospector introspector;
    private StringBuilder sb = new StringBuilder();
    private Object rootObject;

    public LgcyFopGraphPrinter(Object rootObj) {
        this.introspector = new LgcyGraphIntrospector();
        this.rootObject = rootObj;
    }

    public String escapeXml(String someText) {
        if (someText != null) {
            return someText.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;").replace("'", "&apos;").replace("\"", "&quot;");
        }
        return someText;
    }

    @Override
    public void handleIntro(String indent, String objectName, String simpleFields) {
    }

    @Override
    public void handleInteger(String indent, String fieldname, OFXInteger value, boolean isKey) {
        this.sb.append(indent + "<" + fieldname.toUpperCase() + ">" + value.getValue() + "</" + fieldname.toUpperCase() + ">\n");
    }

    @Override
    public void handleStatus(String indent, String fieldname, OFXStatus ofxStatus, boolean isKey) {
        String dbValue = "(null)";
        if (ofxStatus.getValue() != null) {
            dbValue = ofxStatus.getValue().getDbValue();
        }
        this.sb.append(indent + "<" + fieldname.toUpperCase() + "  " + fieldname + " = \"" + dbValue + "\">" + dbValue + "</" + fieldname.toUpperCase() + ">\n");
    }

    @Override
    public void handleString(String indent, String fieldname, OFXString value, boolean isKey) {
        this.sb.append(indent + "<" + fieldname.toUpperCase() + ">" + this.escapeXml(value.getValue()) + "</" + fieldname.toUpperCase() + ">\n");
    }

    @Override
    public void handleBigDecimal(String indent, String fieldname, OFXBigDecimal value, boolean isKey) {
        this.sb.append(indent + "<" + fieldname.toUpperCase() + "  " + fieldname + " = \"" + value.getValue() + "\">" + value.getValue() + "</" + fieldname.toUpperCase() + ">\n");
    }

    @Override
    public void handleLocalDate(String indent, String fieldname, OFXLocalDate value) {
        if (value.getValue() == null) {
            this.sb.append(indent + "<" + fieldname.toUpperCase() + "  " + fieldname + " = \"\"> </" + fieldname.toUpperCase() + ">\n");
        } else {
            this.sb.append(indent + "<" + fieldname.toUpperCase() + "  " + fieldname + " = \"" + xfoDesignerFormatterDate.print((ReadablePartial)value.getValue()) + "\">" + xfoDateOnlyFormatter.print((ReadablePartial)value.getValue()) + "</" + fieldname.toUpperCase() + ">\n");
        }
    }

    @Override
    public void handleDateTime(String indent, String fieldname, OFXDateTime value) {
        if (value.getValue() == null) {
            this.sb.append(indent + "<" + fieldname.toUpperCase() + "  " + fieldname + " = \"\"> </" + fieldname.toUpperCase() + ">\n");
        } else {
            this.sb.append(indent + "<" + fieldname.toUpperCase() + "  " + fieldname + " = \"" + xfoDesignerFormatterTime.print((ReadableInstant)value.getValue()) + "\">" + xfoDateOnlyFormatter.print((ReadableInstant)value.getValue()) + "</" + fieldname.toUpperCase() + ">\n");
        }
    }

    @Override
    public void handleKefReference(String indent, String fieldname, OFXKeyReference value) {
        if (!value.getOpposite() && value.isInitialized()) {
            this.sb.append(indent + "<" + fieldname.toUpperCase() + ">\n");
            this.introspector.introspectionPrint(indent + INDENT, value.getValue(), this);
            this.sb.append(indent + "</" + fieldname.toUpperCase() + ">\n");
        }
    }

    @Override
    public void handleValueObject(String indent, String fieldname, OFXValueObject value, boolean isKey) {
        this.sb.append(indent + "<" + fieldname.toUpperCase() + ">\n");
        this.introspector.introspectionPrint(indent + INDENT, value.getValue(), this);
        this.sb.append(indent + "</" + fieldname.toUpperCase() + ">\n");
    }

    @Override
    public void handleList(String indent, String fieldname, OFXList value) {
        int i = 0;
        this.sb.append("<" + fieldname.toUpperCase() + "SET>\n");
        for (Object obj : value.getValue()) {
            this.sb.append("<" + fieldname.toUpperCase() + " num=\"" + i++ + "\">\n");
            this.introspector.introspectionPrint(indent + INDENT, obj, this);
            this.sb.append("</" + fieldname.toUpperCase() + ">");
        }
        this.sb.append("</" + fieldname.toUpperCase() + "SET>\n");
    }

    @Override
    public void handleVirtualProperty(String indent, String fieldname, OFXVPBase metaInfo, Object value, boolean isKey) {
        if (value instanceof String) {
            value = this.escapeXml((String)value);
        }
        this.sb.append(indent + "<" + fieldname.toUpperCase() + ">" + value + "</" + fieldname.toUpperCase() + ">\n");
    }

    @Override
    public void handleOutro() {
    }

    public String printGraph() {
        this.introspector.introspectionPrint("", this.rootObject, this);
        return this.sb.toString();
    }
}

