/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.sdservices;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.runtime.OFXBigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXDateTime;
import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.OFXList;
import org.modellwerkstatt.objectflow.runtime.OFXLocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXVPBase;
import org.modellwerkstatt.objectflow.runtime.OFXValueObject;
import org.modellwerkstatt.objectflow.sdservices.ILgcyGraphPrinter;

public class LgcyGraphIntrospector {
    private boolean keyAndListFieldName = false;
    private long totalCycles = 1L;
    private String keyAndListFieldNamesContent = "(none)";

    public void noteKeyAndListFieldNames() {
        this.keyAndListFieldName = true;
        this.keyAndListFieldNamesContent = "";
    }

    public String getKeyAndListCycleInfo() {
        return this.keyAndListFieldNamesContent;
    }

    public List<MoField> getFields(Object objectWithFields) {
        ArrayList<MoField> fieldsList = new ArrayList<MoField>();
        try {
            MoField f;
            for (Field field : objectWithFields.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                f = new MoField();
                f.name = field.getName();
                f.value = field.get(objectWithFields);
                fieldsList.add(f);
            }
            for (Class<?> superCls = objectWithFields.getClass().getSuperclass(); superCls != null; superCls = superCls.getSuperclass()) {
                for (Field field : superCls.getDeclaredFields()) {
                    field.setAccessible(true);
                    f = new MoField();
                    f.name = field.getName();
                    f.value = field.get(objectWithFields);
                    fieldsList.add(f);
                }
            }
            return fieldsList;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public Object callGetter(Object objectWithGetter, String fieldName) {
        try {
            Method method;
            String methodName1 = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            String methodName2 = "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                method = objectWithGetter.getClass().getMethod(methodName1, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                method = objectWithGetter.getClass().getMethod(methodName2, new Class[0]);
            }
            return method.invoke(objectWithGetter, new Object[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            return "EXCEPTION " + e.getCause().getClass().getName() + ": " + e.getCause().getMessage();
        }
    }

    public void introspectionPrint(String indent, Object objectWithFields, ILgcyGraphPrinter printer) {
        StringBuilder b = new StringBuilder();
        if (objectWithFields == null) {
            printer.handleIntro(indent, "NULL", "");
        } else {
            Object keyProperty = null;
            if (objectWithFields instanceof IOFXEntity) {
                keyProperty = ((IOFXEntity)objectWithFields).getKeyProperty();
            }
            for (MoField field : this.getFields(objectWithFields)) {
                if (!(field.value instanceof Integer) && !(field.value instanceof Boolean) && !(field.value instanceof String) || "entitysessionuid".equals(field.name.toLowerCase())) continue;
                b.append(field.name + ": " + field.value + "  ");
            }
            printer.handleIntro(indent, objectWithFields.getClass().getSimpleName(), b.toString());
            for (MoField field : this.getFields(objectWithFields)) {
                if (field.value instanceof OFXInteger) {
                    printer.handleInteger(indent, field.name, (OFXInteger)field.value, keyProperty == field.value);
                    continue;
                }
                if (field.value instanceof OFXBigDecimal) {
                    printer.handleBigDecimal(indent, field.name, (OFXBigDecimal)field.value, keyProperty == field.value);
                    continue;
                }
                if (field.value instanceof OFXString) {
                    printer.handleString(indent, field.name, (OFXString)field.value, keyProperty == field.value);
                    continue;
                }
                if (field.value instanceof OFXLocalDate) {
                    printer.handleLocalDate(indent, field.name, (OFXLocalDate)field.value);
                    continue;
                }
                if (field.value instanceof OFXDateTime) {
                    printer.handleDateTime(indent, field.name, (OFXDateTime)field.value);
                    continue;
                }
                if (field.value instanceof OFXStatus) {
                    printer.handleStatus(indent, field.name, (OFXStatus)field.value, keyProperty == field.value);
                    continue;
                }
                if (field.value instanceof OFXKeyReference) {
                    if (this.keyAndListFieldName) {
                        this.keyAndListFieldNamesContent = this.keyAndListFieldNamesContent + objectWithFields.getClass().getSimpleName() + "." + field.name + "  ";
                        if (this.totalCycles++ % 10L == 0L) {
                            this.keyAndListFieldNamesContent = this.keyAndListFieldNamesContent + "\n";
                        }
                    }
                    printer.handleKefReference(indent, field.name, (OFXKeyReference)field.value);
                    continue;
                }
                if (field.value instanceof OFXValueObject) {
                    printer.handleValueObject(indent, field.name, (OFXValueObject)field.value, keyProperty == field.value);
                    continue;
                }
                if (field.value instanceof OFXList) {
                    if (this.keyAndListFieldName) {
                        this.keyAndListFieldNamesContent = this.keyAndListFieldNamesContent + objectWithFields.getClass().getSimpleName() + "." + field.name + "  ";
                        if (this.totalCycles++ % 10L == 0L) {
                            this.keyAndListFieldNamesContent = this.keyAndListFieldNamesContent + "\n";
                        }
                    }
                    printer.handleList(indent, field.name, (OFXList)field.value);
                    continue;
                }
                if (!(field.value instanceof OFXVPBase)) continue;
                printer.handleVirtualProperty(indent, field.name, (OFXVPBase)field.value, this.callGetter(objectWithFields, field.name), keyProperty == field.value);
            }
        }
        printer.handleOutro();
    }

    public static void main(String[] args) {
        LgcyGraphIntrospector i = new LgcyGraphIntrospector();
        for (MoField f : i.getFields(new Object())) {
            System.out.println("Name: " + f.name + " / " + f.value);
        }
    }

    public static class MoField {
        public String name;
        public Object value;
    }
}

