/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.serdes;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashMap;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.objectflow.runtime.MoWareFormattersFactory;
import org.modellwerkstatt.objectflow.serdes.ConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.SerdesException;

public class ConvStdFormatters
implements IConvFormatOptions {
    protected ConvFormatOptions options;
    protected DateTimeFormatter dateTimeFormatter;
    protected DateTimeFormatter localDateFormatter;
    protected DecimalFormat decimalFormat;
    protected HashMap<String, String> jsonKeyToField;
    protected HashMap<String, String> fieldKeyToJson;
    protected boolean serializeBigDeciAsString = false;

    public ConvStdFormatters(ConvFormatOptions opt) {
        this.init(opt);
    }

    public ConvStdFormatters(ConvFormatOptions opt, HashMap<String, String> jToF) {
        this.jsonKeyToField = jToF;
        this.init(opt);
    }

    public void init(ConvFormatOptions opts) {
        this.options = opts;
        this.dateTimeFormatter = MoWareFormattersFactory.forDateTimePattern(this.options.dateTimeFormat, this.options.locale);
        this.localDateFormatter = MoWareFormattersFactory.forDateTimePattern(this.options.localDateFormat, this.options.locale);
        this.decimalFormat = MoWareFormattersFactory.forDecimalFormatPattern(this.options.bigDeciFormat, this.options.locale);
        if (this.options.bigDeciFormat.contains(",")) {
            this.serializeBigDeciAsString = true;
        }
        if (this.jsonKeyToField != null) {
            this.fieldKeyToJson = new HashMap();
            for (String key : this.jsonKeyToField.keySet()) {
                String value = this.jsonKeyToField.get(key);
                this.fieldKeyToJson.put(value, key);
            }
        }
    }

    @Override
    public LocalDate parseLocalDate(String dateSt) {
        return this.localDateFormatter.parseLocalDate(dateSt);
    }

    @Override
    public String printLocalDate(LocalDate date) {
        return this.localDateFormatter.print((ReadablePartial)date);
    }

    @Override
    public DateTime parseDateTime(String dtSt) {
        return this.dateTimeFormatter.parseDateTime(dtSt);
    }

    @Override
    public String printDateTime(DateTime dt) {
        return this.dateTimeFormatter.print((ReadableInstant)dt);
    }

    @Override
    public BigDecimal parseBigDecimal(String bdSt) {
        try {
            return (BigDecimal)this.decimalFormat.parse(bdSt);
        }
        catch (ParseException e) {
            throw new SerdesException("Can not convert '" + bdSt + "' to a decimal.", e);
        }
    }

    @Override
    public String printBigDecimal(BigDecimal bd) {
        return this.decimalFormat.format(bd);
    }

    @Override
    public boolean serializeBigDecimalAsString() {
        return this.serializeBigDeciAsString;
    }

    @Override
    public String jsonPathToField(String jsonName) {
        if (this.jsonKeyToField == null) {
            return jsonName;
        }
        if (this.jsonKeyToField.containsKey(jsonName)) {
            return this.jsonKeyToField.get(jsonName);
        }
        return jsonName;
    }

    @Override
    public String fieldPathToJson(String propName) {
        if (this.fieldKeyToJson == null) {
            return propName;
        }
        if (this.fieldKeyToJson.containsKey(propName)) {
            return this.fieldKeyToJson.get(propName);
        }
        return propName;
    }

    @Override
    public boolean hasMode(IConvFormatOptions.Mode mode) {
        for (IConvFormatOptions.Mode m : this.options.modes) {
            if (!mode.equals((Object)m)) continue;
            return true;
        }
        return false;
    }
}

