/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.services;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class HttpConnection {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String jsonConIoEx(RequestType rqType, String targetUrl, Map<String, String> headers, String reqContent) throws IOException {
        HttpURLConnection con = null;
        try {
            String inputLine;
            InputStream stream;
            URL url = new URL(targetUrl);
            con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            con.setInstanceFollowRedirects(false);
            if (rqType == RequestType.POST || rqType == RequestType.PUT || rqType == RequestType.PATCH) {
                con.setRequestProperty("Content-Type", "application/json");
            } else {
                con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            }
            con.setRequestProperty("Accept", "application/json");
            if (headers != null) {
                for (String key : headers.keySet()) {
                    con.setRequestProperty(key, headers.get(key));
                }
            }
            con.setRequestMethod("" + rqType);
            if (reqContent != null) {
                con.setDoOutput(true);
                DataOutputStream out = new DataOutputStream(con.getOutputStream());
                out.writeBytes(reqContent);
                out.flush();
                out.close();
            }
            con.connect();
            int status = con.getResponseCode();
            Object errorStatus = null;
            StringBuilder content = new StringBuilder();
            if (status >= 200 && status < 300) {
                stream = con.getInputStream();
                if (status == 202) {
                    errorStatus = "Http Status 202 (operation not completed) ";
                }
            } else {
                errorStatus = "Http Status " + status + " - " + con.getResponseMessage();
                stream = con.getErrorStream();
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            if (errorStatus != null) {
                throw new IOException((String)errorStatus + "\n" + content.toString());
            }
            String string = content.toString();
            return string;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public static String jsonCon(RequestType rqType, String targetUrl, Map<String, String> headers, String reqContent) {
        try {
            return HttpConnection.jsonConIoEx(rqType, targetUrl, headers, reqContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum RequestType {
        GET,
        POST,
        PUT,
        DELETE,
        PATCH;

    }
}

