/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.services;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;

public class LdapAccess {
    public static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String DEFAULT_SECURITY_AUTHENTICATION = "Simple";
    private String ldapServerAddress;
    private boolean useSsl;

    public LdapAccess(String srv, boolean ssl) {
        this.ldapServerAddress = srv;
        this.useSsl = ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loginPossible(Search srch) {
        LdapContext userContext = null;
        boolean usernameOk = false;
        try {
            userContext = this.createContextToUserPwd(srch.principal, srch.principalPwd);
            usernameOk = true;
            this.closeIfNotNull(userContext);
            return usernameOk;
        }
        catch (NamingException namingException) {
            return usernameOk;
        }
        finally {
            this.closeIfNotNull(userContext);
        }
    }

    public List<String> ldapSingleEntrySearch(Search srch) {
        LdapContext bindContext = null;
        IListSequence results = ListSequence.fromList(new ArrayList());
        try {
            Attributes attrs;
            Attribute returningAttr;
            bindContext = this.createContextToUserPwd(srch.principal, srch.principalPwd);
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            String[] attrIDs = new String[]{srch.returnAttr};
            constraints.setReturningAttributes(attrIDs);
            NamingEnumeration<SearchResult> answer = bindContext.search(srch.searchBase, srch.queryString, constraints);
            if (answer.hasMore() && (returningAttr = (attrs = answer.next().getAttributes()).get(srch.returnAttr)) != null) {
                NamingEnumeration<?> e1 = returningAttr.getAll();
                while (e1.hasMoreElements()) {
                    ListSequence.fromList((List)results).addElement((Object)e1.nextElement().toString());
                }
            }
            if (answer.hasMore()) {
                throw new RuntimeException("More then one entry for query '" + srch.queryString + "' retrieved, contact directory admin.");
            }
            this.closeIfNotNull(bindContext);
        }
        catch (NamingException nex) {
            try {
                throw new RuntimeException("Ldap Bind: Connection failed", nex);
            }
            catch (Throwable throwable) {
                this.closeIfNotNull(bindContext);
                throw throwable;
            }
        }
        return results;
    }

    protected void closeIfNotNull(LdapContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException ex) {
                throw new RuntimeException("LdapContext : Error while closing context", ex);
            }
        }
    }

    protected LdapContext createContextToUserPwd(String principal, String pwd) throws NamingException {
        Hashtable<String, String> userEnv = new Hashtable<String, String>();
        userEnv.put("java.naming.factory.initial", DEFAULT_INITIAL_CONTEXT_FACTORY);
        userEnv.put("java.naming.security.authentication", DEFAULT_SECURITY_AUTHENTICATION);
        userEnv.put("java.naming.security.principal", principal);
        userEnv.put("java.naming.security.credentials", pwd);
        userEnv.put("java.naming.provider.url", this.ldapServerAddress);
        if (this.useSsl) {
            userEnv.put("java.naming.security.protocol", "ssl");
        }
        return new InitialLdapContext(userEnv, null);
    }

    public static class Search {
        private String principal;
        private String principalPwd;
        private String returnAttr;
        private String searchBase;
        private String queryString;

        public Search clone() {
            Search clone = new Search(this.principal, this.principalPwd);
            clone.returnAttr = this.returnAttr;
            clone.searchBase = this.searchBase;
            clone.queryString = this.queryString;
            return clone;
        }

        public Search(String aPrincipal, String aPrincipalPwd) {
            this.principal = aPrincipal;
            this.principalPwd = aPrincipalPwd;
        }

        public Search withPassword(String pwd) {
            Search cl = this.clone();
            cl.principalPwd = pwd;
            return cl;
        }

        public Search withReturnAttr(String attr) {
            Search cl = this.clone();
            cl.returnAttr = attr;
            return cl;
        }

        public Search withBase(String base) {
            Search cl = this.clone();
            cl.searchBase = base;
            return cl;
        }

        public Search queryEq(String field, String value) {
            Search cl = this.clone();
            cl.queryString = field + "=" + value;
            return cl;
        }
    }
}

