/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.services;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IMoLdapService;
import org.modellwerkstatt.objectflow.services.LdapAccess;

public class MoLdapService
extends LdapAccess
implements IMoLdapService {
    private String userInformationSearchbase;
    protected LdapAccess.Search genLdapPrincipal;

    public MoLdapService(String server, String principal, String pwd, String usrInfoSearchBase) {
        this(server, principal, pwd, usrInfoSearchBase, false);
    }

    public MoLdapService(String server, String principal, String pwd, String usrInfoSearchBase, boolean aUseSsl) {
        super(server, aUseSsl);
        this.userInformationSearchbase = usrInfoSearchBase;
        this.genLdapPrincipal = new LdapAccess.Search(principal, pwd);
    }

    @Override
    public void setBindUserPassword(String pwd) {
        this.genLdapPrincipal = this.genLdapPrincipal.withPassword(pwd);
    }

    @Override
    public boolean authenticateUser(String username, String pwd) {
        if (pwd == null || "".equals(pwd)) {
            return false;
        }
        LdapAccess.Search findDistinguishedName = this.genLdapPrincipal.withBase(this.userInformationSearchbase).withReturnAttr("distinguishedName").queryEq("sAMAccountName", username);
        List<String> results = this.ldapSingleEntrySearch(findDistinguishedName);
        if (ListSequence.fromList(results).count() > 1) {
            throw new IllegalStateException("We have " + ListSequence.fromList(results).count() + " users for the username " + username);
        }
        if (ListSequence.fromList(results).count() == 1) {
            LdapAccess.Search userLogin = new LdapAccess.Search((String)ListSequence.fromList(results).getElement(0), pwd);
            return this.loginPossible(userLogin);
        }
        return false;
    }

    @Override
    public List<IMoLdapService.ICnInfo> getGroupsOfUser(String username) {
        LdapAccess.Search memberOf = this.genLdapPrincipal.withBase(this.userInformationSearchbase).withReturnAttr("memberOf").queryEq("sAMAccountName", username);
        List<String> res = this.ldapSingleEntrySearch(memberOf);
        return this.convertCommonName(res);
    }

    @Override
    public List<IMoLdapService.ICnInfo> getGroupsOfCommonName(String srcBase, String commonName) {
        LdapAccess.Search memberOf = this.genLdapPrincipal.withBase(srcBase).withReturnAttr("memberOf").queryEq("cn", commonName);
        List<String> res = this.ldapSingleEntrySearch(memberOf);
        return this.convertCommonName(res);
    }

    @Override
    public List<IMoLdapService.ICnInfo> getNamesToAttrAndCommonName(String srcBase, String attr, String commonName) {
        LdapAccess.Search memberOf = this.genLdapPrincipal.withBase(srcBase).withReturnAttr(attr).queryEq("cn", commonName);
        List<String> res = this.ldapSingleEntrySearch(memberOf);
        return this.convertCommonName(res);
    }

    protected List<IMoLdapService.ICnInfo> convertCommonName(List<String> rawInfos) {
        IListSequence infos = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(rawInfos).visitAll(arg_0 -> this.lambda$convertCommonName$0((List)infos, arg_0));
        return infos;
    }

    protected String getCommonName(String cnName) {
        int position;
        if (cnName != null && cnName.toUpperCase().startsWith("CN=")) {
            cnName = cnName.substring(3);
        }
        if ((position = cnName.indexOf(44)) == -1) {
            return cnName;
        }
        return cnName.substring(0, position);
    }

    private /* synthetic */ void lambda$convertCommonName$0(List infos, String it) {
        ListSequence.fromList((List)infos).addElement((Object)new CNInformation(it, this.getCommonName(it)));
    }

    public static class CNInformation
    implements IMoLdapService.ICnInfo {
        private String unprocessedName;
        private String processedName;

        public CNInformation(String unprocessed, String processed) {
            this.unprocessedName = unprocessed;
            this.processedName = processed;
        }

        @Override
        public String getProcessedName() {
            return this.processedName;
        }

        @Override
        public String getUnprocessedName() {
            return this.unprocessedName;
        }
    }
}

