/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.services;

public class MoMeasure {
    private int max;
    private long[] times;
    private long lastTouch;
    private int replaceIndex;
    private String name;
    private boolean started;

    public MoMeasure(String n, int m) {
        this.max = m;
        this.lastTouch = 0L;
        this.started = false;
        this.name = n + " (@ " + m + " in millis)";
        this.replaceIndex = 0;
        this.times = new long[this.max];
        for (int i = 0; i < this.max; ++i) {
            this.times[i] = 0L;
        }
    }

    public void reset() {
        for (int i = 0; i < this.max; ++i) {
            this.times[i] = 0L;
        }
        this.lastTouch = 0L;
        this.started = false;
        this.replaceIndex = 0;
    }

    public void cycle() {
        if (!this.started) {
            this.started = true;
            this.start();
        } else {
            this.stop();
            this.start();
        }
    }

    public void start() {
        this.lastTouch = System.currentTimeMillis();
    }

    public void stop() {
        long diff = System.currentTimeMillis() - this.lastTouch;
        this.lastTouch = System.currentTimeMillis();
        this.times[this.replaceIndex++] = diff;
        if (this.replaceIndex == this.max) {
            this.replaceIndex = 0;
        }
    }

    public String toString() {
        return this.name + ":  " + this.toLong();
    }

    public long toLong() {
        long avg = 0L;
        int cnt = 0;
        for (int i = 0; i < this.max && this.times[i] != 0L; ++i) {
            avg += this.times[i];
            ++cnt;
        }
        if (cnt > 0) {
            avg /= (long)cnt;
        }
        return avg;
    }

    public static void main(String[] args) {
        MoMeasure m = new MoMeasure("test", 1);
        m.start();
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        m.stop();
        System.out.println("" + m);
    }
}

