/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.services;

import java.io.IOException;
import java.net.NoRouteToHostException;
import mjson.Json;
import org.modellwerkstatt.javaxbus.ConsumerHandler;
import org.modellwerkstatt.javaxbus.ErrorHandler;
import org.modellwerkstatt.javaxbus.EventBus;
import org.modellwerkstatt.javaxbus.Message;
import org.modellwerkstatt.objectflow.runtime.IMoEventBusService;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;

public class MoOptionalEventBus
implements IMoEventBusService {
    public static final boolean DEBUG_SENDER_RECEIVER = false;
    private volatile boolean upNrunning = false;
    private EventBus bus;
    private String sName;
    private int sPort;
    private volatile String systemsInformation = "(no sysinfo set)";
    private volatile String statusInfo = "";

    public MoOptionalEventBus(String serverName, int serverPort) {
        this.sName = serverName;
        this.sPort = serverPort;
        this.init();
    }

    @Override
    public String getServerName() {
        return this.sName;
    }

    @Override
    public int getServerPort() {
        return this.sPort;
    }

    @Override
    public void setSysInfo(String s) {
        this.systemsInformation = s;
    }

    @Override
    public void init() {
        try {
            this.bus = EventBus.create((String)this.sName, (int)this.sPort);
            this.bus.addErrorHandler(new ErrorHandler(){

                public void handleMsgFromBus(boolean stillConnected, boolean eventLoopRunning, Message msg) {
                    String errorText = "Eventbus error msg received: connected-now " + stillConnected + ", bus-receiver-running " + eventLoopRunning + " on [" + MoOptionalEventBus.this.systemsInformation + "] ";
                    errorText = msg.isErrorMsg() ? errorText + "bus-error-msg '" + msg.getErrMessage() + "', code " + msg.getErrFailureCode() + ", type " + msg.getErrFailureType() : errorText + "message '" + msg.getBodyAsMJson().toString() + "'.";
                    if (!eventLoopRunning) {
                        errorText = "EVENT RECEIVER DISABLED! " + errorText;
                    }
                    MoOptionalEventBus.this.statusInfo = errorText;
                    OFXLogger.log(MoOptionalEventBus.class, IOFXCoreReporter.LogPriority.ERROR, errorText, null);
                }

                public void handleException(boolean stillConnected, boolean eventLoopRunning, Exception ex) {
                    String errorText = "Eventbus exception: connected-now " + stillConnected + ", bus-receiver-running " + eventLoopRunning + " on [" + MoOptionalEventBus.this.systemsInformation + "] ";
                    if (!eventLoopRunning) {
                        errorText = " EVENT RECEIVER DISABLED! " + errorText;
                    }
                    if (!(eventLoopRunning && ex instanceof IOException || eventLoopRunning && ex != null && ex.getCause() instanceof NoRouteToHostException)) {
                        OFXLogger.log(MoOptionalEventBus.class, IOFXCoreReporter.LogPriority.ERROR, errorText, (Throwable)ex);
                    }
                    MoOptionalEventBus.this.statusInfo = errorText + " (" + ex + ")";
                }
            });
            this.upNrunning = true;
        }
        catch (Exception ex) {
            this.bus = null;
            this.upNrunning = false;
            this.statusInfo = ex.getClass().getSimpleName() + " " + ex.getMessage();
            OFXLogger.log(MoOptionalEventBus.class, IOFXCoreReporter.LogPriority.ERROR, "Was not able to connect to eventbus at " + this.sName + ":" + this.sPort + ".", (Throwable)ex);
        }
    }

    @Override
    public boolean sendToLogChannel(String ch, Json msg) {
        boolean sent;
        if (!this.upNrunning) {
            sent = false;
        } else if (this.bus.isConnected()) {
            try {
                this.bus.send(ch, msg);
                sent = true;
            }
            catch (RuntimeException ex) {
                OFXLogger.log(MoOptionalEventBus.class, IOFXCoreReporter.LogPriority.FATAL, "Exception while trying to write to global log. This seriously impacts portJ monitoring.", (Throwable)ex);
                sent = false;
            }
        } else {
            sent = false;
        }
        if (!sent) {
            OFXLogger.log(MoOptionalEventBus.class, IOFXCoreReporter.LogPriority.FATAL, "Investigatingh h2forms portj issues (Spring 25), message NOT sent!.  Now upnRunning=" + this.upNrunning + ", bus.isconnected()=" + this.bus.isConnected() + ". Tried to send " + OFXLogger.simpleInfo(msg) + ".", null);
        }
        return sent;
    }

    @Override
    public void publish(String msgType, Json json) {
        if (!this.upNrunning) {
            return;
        }
        if (this.bus.isConnected()) {
            try {
                MoOptionalEventBus.dd("publish " + json);
                this.bus.publish(msgType, json);
            }
            catch (RuntimeException ex) {
                OFXLogger.log(MoOptionalEventBus.class, IOFXCoreReporter.LogPriority.ERROR, "Exception while trying to publish to " + msgType + " the msg " + json.toString(), (Throwable)ex);
            }
        }
    }

    @Override
    public void register(ConsumerHandler recv, String msgType) {
        if (this.upNrunning && this.bus.isConnected()) {
            this.bus.consumer(msgType, recv);
        }
    }

    @Override
    public void unregister(ConsumerHandler recv, String msgType) {
        if (this.upNrunning && this.bus.isConnected()) {
            this.bus.unregisgterConsumer(msgType, recv);
        }
    }

    @Override
    public String getCurrentStatus() {
        String stat = this.sName + ":" + this.sPort + ", up " + this.upNrunning;
        if (this.bus != null && this.upNrunning) {
            stat = stat + ", con " + this.bus.isConnected();
        }
        stat = stat + ", [" + this.statusInfo + "]";
        return stat;
    }

    @Override
    public String testReset() {
        Object msg = "No top level ex while resetting. Check logs. ";
        if (this.bus == null) {
            msg = "Eventbus not correctly initialized (bus is null)";
        } else {
            try {
                this.bus.testReconnect();
                msg = (String)msg + " [up " + this.upNrunning + ", con " + this.bus.isConnected() + ", conup " + this.bus.isUpAndRunning() + "]";
            }
            catch (Exception ex) {
                msg = ex.getClass().getName() + ": " + ex.getMessage();
                this.statusInfo = (String)msg + " after testRest()";
            }
        }
        return msg;
    }

    public static void dd(String msg) {
    }

    @Override
    public void close() {
        if (this.bus != null && this.upNrunning) {
            this.bus.close();
        }
    }
}

