/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.services;

import org.modellwerkstatt.objectflow.runtime.OFXBigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXDateTime;
import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.OFXList;
import org.modellwerkstatt.objectflow.runtime.OFXLocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXVPBase;
import org.modellwerkstatt.objectflow.runtime.OFXValueObject;
import org.modellwerkstatt.objectflow.services.IMoIntrospectionPrinter;
import org.modellwerkstatt.objectflow.services.MoGraphIntrospector;

public class MoStringIntroPrinter
implements IMoIntrospectionPrinter {
    private static final String INDENT = "   ";
    private MoGraphIntrospector introspector;
    private StringBuilder sb = new StringBuilder();
    private Object rootObject;

    public MoStringIntroPrinter(Object rootObj) {
        this.introspector = new MoGraphIntrospector();
        this.rootObject = rootObj;
    }

    @Override
    public void handleIntro(String indent, String objectName, String simpleFields) {
        this.sb.append(indent + objectName + "  (" + simpleFields + ")\n");
    }

    @Override
    public void handleInteger(String indent, String fieldname, OFXInteger value, boolean isKey) {
        this.sb.append(indent + fieldname + ": " + value.getValue() + "\n");
    }

    @Override
    public void handleBigDecimal(String indent, String fieldname, OFXBigDecimal value, boolean isKey) {
        this.sb.append(indent + fieldname + ": " + value.getValue() + "\n");
    }

    @Override
    public void handleString(String indent, String fieldname, OFXString value, boolean isKey) {
        this.sb.append(indent + fieldname + ": " + value.getValue() + "\n");
    }

    @Override
    public void handleLocalDate(String indent, String fieldname, OFXLocalDate value) {
        this.sb.append(indent + fieldname + ": " + value.getValue() + "\n");
    }

    @Override
    public void handleDateTime(String indent, String fieldname, OFXDateTime value) {
        this.sb.append(indent + fieldname + ": " + value.getValue() + "\n");
    }

    @Override
    public void handleStatus(String indent, String fieldname, OFXStatus ofxStatus, boolean isKey) {
        String dbValue = "(null)";
        if (ofxStatus.getValue() != null) {
            dbValue = ofxStatus.getValue().getDbValue();
        }
        this.sb.append(indent + fieldname + ": " + dbValue + "\n");
    }

    @Override
    public void handleKefReference(String indent, String fieldname, OFXKeyReference value) {
        this.sb.append(indent + fieldname + " (Reference): Key:" + value.getKey() + "\n");
        if (!value.getOpposite() && value.isInitialized()) {
            this.introspector.introspectionPrint(indent + INDENT, value.getValue(), this);
        }
    }

    @Override
    public void handleValueObject(String indent, String fieldname, OFXValueObject value, boolean isKey) {
        this.sb.append(indent + fieldname + " (ValueObject): \n");
        this.introspector.introspectionPrint(indent + INDENT, value.getValue(), this);
    }

    @Override
    public void handleList(String indent, String fieldname, OFXList value) {
        if (value.getValue() == null) {
            this.sb.append(indent + fieldname + " (List): NULL !\n");
        } else {
            this.sb.append(indent + fieldname + " (List): \n");
            for (Object obj : value.getValue()) {
                this.introspector.introspectionPrint(indent + INDENT, obj, this);
                this.sb.append("\n");
            }
        }
    }

    @Override
    public void handleVirtualProperty(String indent, String fieldname, OFXVPBase meta, Object value, boolean isKey) {
        this.sb.append(indent + fieldname + " (Virt.Prop.) " + value + "\n");
    }

    @Override
    public void handleOutro() {
    }

    public String printGraph() {
        this.introspector.introspectionPrint("", this.rootObject, this);
        return this.sb.toString();
    }
}

