/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.testsuit;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.testsuit.MoTestSuitHandler;
import org.modellwerkstatt.objectflow.testsuit.TestMethodInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.CannotCreateTransactionException;

public abstract class OFXTestSuit
implements IOFXTestSuit {
    public static final DateTimeFormatter US_DTPARSER = DateTimeFormat.forPattern((String)"MM/dd/yyyy hh:mm:ss");
    @Autowired
    protected IOFXUserEnvironment __userEnvironment;
    @Autowired
    protected IOFXUserServices __userServices;
    @Autowired
    protected DataSource __localDataSource;
    @Autowired
    protected IOFXApplicationFactory __localApplicationFactory;
    protected Map<String, IOFXTestSuit> allIncludedSuitsInstances = MapSequence.fromMap(new HashMap());

    @Override
    public void run(IOFXTestSuit.IOFXTestSuitHandler reporter) {
        String testSuitFqNAme = this.getClass().getName();
        Method[] allMethods = this.getClass().getMethods();
        ArrayList<TestMethodInfo> testMethodInfos = new ArrayList<TestMethodInfo>();
        for (Method mth : allMethods) {
            OFXTestMethod tmAnnotation = mth.getAnnotation(OFXTestMethod.class);
            if (tmAnnotation == null) continue;
            testMethodInfos.add(new TestMethodInfo(mth, tmAnnotation));
        }
        testMethodInfos.sort(new Comparator<TestMethodInfo>(){

            @Override
            public int compare(TestMethodInfo p1, TestMethodInfo p2) {
                return p1.annotation.id() - p2.annotation.id();
            }
        });
        for (TestMethodInfo info : testMethodInfos) {
            if (!info.annotation.enabled()) continue;
            IOFXSession __manMapSession = this.createSession();
            try {
                reporter.startingTest();
                DeprecatedServerDateProvider.fixServerDatetimeToConstant(null);
                if (!"".equals(info.annotation.runAt())) {
                    DateTime dtToRunTestAd = US_DTPARSER.parseDateTime(info.annotation.runAt());
                    DeprecatedServerDateProvider.fixServerDatetimeToConstant(dtToRunTestAd);
                }
                info.method.invoke((Object)this, __manMapSession, reporter);
                reporter.testDone(__manMapSession, testSuitFqNAme, info.annotation.name(), true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("This can not happen.", e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t != null) {
                    reporter.logError(__manMapSession, testSuitFqNAme, info.annotation.name(), t);
                    reporter.testDone(__manMapSession, testSuitFqNAme, info.annotation.name(), false);
                    continue;
                }
                throw new RuntimeException("This can not happen.", e);
            }
            catch (CannotCreateTransactionException ccte) {
                reporter.logError(__manMapSession, testSuitFqNAme, info.annotation.name(), ccte);
                reporter.testDone(__manMapSession, testSuitFqNAme, info.annotation.name(), false);
                reporter.logError(__manMapSession, testSuitFqNAme, info.annotation.name(), "OFXTestSuit - execution stopped due to CannotCreateTransactionException!");
                return;
            }
            catch (Throwable t) {
                reporter.logError(__manMapSession, testSuitFqNAme, info.annotation.name(), t);
                reporter.testDone(__manMapSession, testSuitFqNAme, info.annotation.name(), false);
            }
        }
    }

    public void setupFieldsOfSuit(IOFXTestSuit.IOFXTestSuitHandler hndlr, IOFXTestSuit suit) {
        try {
            Field[] allFields;
            for (Field fld : allFields = suit.getClass().getFields()) {
                OFXIncludedSuit fldAnnotation = fld.getAnnotation(OFXIncludedSuit.class);
                if (fldAnnotation == null) continue;
                fld.setAccessible(true);
                IOFXTestSuit objToSet = hndlr.getOrCreateTestSuit(fldAnnotation.name());
                fld.set(suit, objToSet);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("While initializing fields for " + suit.getClass().getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setupIncludedSuits(String[] allIncludedTests, String[] includedTestsToRun) {
        IOFXTestSuit instance;
        MoTestSuitHandler hndlr = new MoTestSuitHandler();
        for (String fqName : allIncludedTests) {
            instance = hndlr.getOrCreateTestSuit(fqName);
            MapSequence.fromMap(this.allIncludedSuitsInstances).put((Object)fqName, (Object)instance);
        }
        hndlr.testSuitCreateInitDone();
        try {
            for (String fqName : allIncludedTests) {
                instance = (IOFXTestSuit)MapSequence.fromMap(this.allIncludedSuitsInstances).get((Object)fqName);
                this.setupFieldsOfSuit(hndlr, instance);
                instance.onStartup(hndlr, this.createSession());
            }
            this.onStartup(hndlr, this.createSession());
            for (String fqName : includedTestsToRun) {
                instance = (IOFXTestSuit)MapSequence.fromMap(this.allIncludedSuitsInstances).get((Object)fqName);
                instance.run(hndlr);
            }
            this.run(hndlr);
        }
        catch (Throwable t) {
            System.err.println("---- TestSuit setup problems ----");
            System.err.println(OFXConsoleHelper.stackTrace2String(t));
        }
        finally {
            try {
                this.onShutdown(hndlr, this.createSession());
            }
            catch (Throwable t) {
                System.err.println("---- TestSuit setup problems while shutdown ----");
                System.err.println(OFXConsoleHelper.stackTrace2String(t));
            }
            for (int i = allIncludedTests.length - 1; i >= 0; --i) {
                IOFXTestSuit instance2 = (IOFXTestSuit)MapSequence.fromMap(this.allIncludedSuitsInstances).get((Object)allIncludedTests[i]);
                instance2.onShutdown(hndlr, this.createSession());
            }
        }
        hndlr.print(this.createSession(), this.getClass().getName(), hndlr.summary());
        return hndlr.allTestsPassed();
    }

    public IOFXSession createSession() {
        return this.__localApplicationFactory.createNewSession(this.__userEnvironment, this.__userServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAsMain(String config, Class testSuitClass, String[] allIncludedTests, String[] includedTestsToRun) {
        boolean passed = false;
        try {
            if (config.trim().equals("")) {
                System.err.println("The configuration given in this suite is empty: '" + config + "'");
            }
            OFXTestSuit thisTestSuit = (OFXTestSuit)OFXConsoleHelper.initializeForTestSuit(config, testSuitClass);
            passed = thisTestSuit.setupIncludedSuits(allIncludedTests, includedTestsToRun);
        }
        catch (Throwable t) {
            System.err.println("----- TestSuit setup problems -----");
            System.err.println(OFXConsoleHelper.stackTrace2String(t));
        }
        finally {
            OFXConsoleHelper.unbindJmxRmiNaming(passed);
        }
    }
}

