/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.plugin;

import com.intellij.openapi.ui.DialogBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.project.MPSProject;

public class DLGCompleterWindow
extends DialogBuilder {
    private JComponent myComponent;
    public JTextArea detectedProblems;
    private boolean isOkayButton = false;
    private List<String> modelNames;
    private List<String> childsName;
    private JCheckBox mappings;
    private JCheckBox repos;
    private JCheckBox service;
    private JCheckBox searchCmd;
    private JCheckBox graphOwnerCmd;
    private JCheckBox graphEditCmd;
    private JCheckBox creatorCmd;
    private JComboBox childsBox;
    private JComboBox commandsUiBox;
    private JComboBox serviceBox;
    private String entityName;
    private boolean disableDbFeatures;

    public DLGCompleterWindow(MPSProject project, String name, boolean disDbFeat) {
        super(project.getProject());
        this.entityName = name;
        this.setTitle("Werkbank DDD Template");
        this.disableDbFeatures = disDbFeat;
        this.detectedProblems = new JTextArea();
        this.detectedProblems.setEditable(false);
        this.detectedProblems.setEnabled(false);
        this.detectedProblems.setDisabledTextColor(new Color(255, 0, 0));
    }

    public void setModels(List<String> m) {
        IListSequence fullList = ListSequence.fromList(new ArrayList());
        ListSequence.fromList((List)fullList).addSequence((ISequence)ListSequence.fromList(m));
        this.modelNames = fullList;
    }

    public void setChilds(List<String> m) {
        IListSequence fullList = ListSequence.fromList(new ArrayList());
        ListSequence.fromList((List)fullList).addElement((Object)"-");
        ListSequence.fromList((List)fullList).addSequence((ISequence)ListSequence.fromList(m));
        this.childsName = fullList;
    }

    public void addProblem(String txt) {
        this.detectedProblems.setText(this.detectedProblems.getText() + txt + "\n");
    }

    public JComponent createPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel featureSelector = new JPanel(new GridLayout(10, 2));
        featureSelector.add(new Label("SELECT CONCEPTS YOU WANT TO CREATE FOR '" + this.entityName + "':"));
        featureSelector.add(new Label(""));
        featureSelector.add(new Label("Database Mappings"));
        this.mappings = new JCheckBox();
        this.mappings.setSelected(true);
        featureSelector.add(this.mappings);
        if (this.disableDbFeatures) {
            this.mappings.setSelected(false);
            this.mappings.setEnabled(false);
        }
        featureSelector.add(new Label("Repository"));
        this.repos = new JCheckBox();
        this.repos.setSelected(true);
        featureSelector.add(this.repos);
        if (this.disableDbFeatures) {
            this.repos.setSelected(false);
            this.repos.setEnabled(false);
        }
        featureSelector.add(new Label("Aggregate Service / Factory"));
        this.service = new JCheckBox();
        this.service.setSelected(true);
        featureSelector.add(this.service);
        if (this.disableDbFeatures) {
            this.service.setSelected(false);
            this.service.setEnabled(false);
        }
        featureSelector.add(new Label("Search Command"));
        this.searchCmd = new JCheckBox();
        this.searchCmd.setSelected(true);
        featureSelector.add(this.searchCmd);
        featureSelector.add(new Label("Graph Owner Command"));
        this.graphOwnerCmd = new JCheckBox();
        this.graphOwnerCmd.setSelected(true);
        featureSelector.add(this.graphOwnerCmd);
        featureSelector.add(new Label("Graph Edit Command"));
        this.graphEditCmd = new JCheckBox();
        this.graphEditCmd.setSelected(true);
        featureSelector.add(this.graphEditCmd);
        featureSelector.add(new Label("Creator Command (predecessor)"));
        this.creatorCmd = new JCheckBox();
        this.creatorCmd.setSelected(true);
        featureSelector.add(this.creatorCmd);
        featureSelector.add(new Label("Include Child list"));
        this.childsBox = new JComboBox<Object>(ListSequence.fromList(this.childsName).toGenericArray(String.class));
        featureSelector.add(this.childsBox);
        if (ListSequence.fromList(this.childsName).count() > 1) {
            this.childsBox.setSelectedIndex(1);
        }
        JPanel modelSelector = new JPanel(new GridLayout(4, 2));
        this.commandsUiBox = new JComboBox<Object>(ListSequence.fromList(this.modelNames).toGenericArray(String.class));
        this.serviceBox = new JComboBox<Object>(ListSequence.fromList(this.modelNames).toGenericArray(String.class));
        String element = (String)ListSequence.fromList(this.modelNames).findFirst(it -> it.toLowerCase().endsWith(this.entityName.toLowerCase()));
        if (element != null) {
            this.serviceBox.setSelectedIndex(ListSequence.fromList(this.modelNames).indexOf((Object)element));
        }
        if ((element = (String)ListSequence.fromList(this.modelNames).findFirst(it -> it.toLowerCase().endsWith(this.entityName.toLowerCase() + "unit"))) != null) {
            this.commandsUiBox.setSelectedIndex(ListSequence.fromList(this.modelNames).indexOf((Object)element));
        }
        modelSelector.add(new Label("SELECT MODELS TO PLACE CONCEPTS:"));
        modelSelector.add(new Label(""));
        modelSelector.add(new Label("Service and Repo to"));
        modelSelector.add(this.serviceBox);
        modelSelector.add(new Label("Commands and UI to"));
        modelSelector.add(this.commandsUiBox);
        JPanel lowerPart = new JPanel(new BorderLayout());
        lowerPart.add((Component)modelSelector, "First");
        lowerPart.add((Component)new JSeparator(0), "Center");
        lowerPart.add((Component)this.detectedProblems, "Last");
        panel.add((Component)featureSelector, "First");
        panel.add((Component)new JSeparator(0), "Center");
        panel.add((Component)lowerPart, "Last");
        return panel;
    }

    public boolean isMapping() {
        return this.mappings.isSelected();
    }

    public boolean isRepo() {
        return this.repos.isSelected();
    }

    public boolean isServiceNFactory() {
        return this.service.isSelected();
    }

    public boolean isSearchCmd() {
        return this.searchCmd.isSelected();
    }

    public boolean isGraphOwnerCmd() {
        return this.graphOwnerCmd.isSelected();
    }

    public boolean isGraphEditCmd() {
        return this.graphEditCmd.isSelected();
    }

    public boolean isCreatorCmd() {
        return this.creatorCmd.isSelected();
    }

    public String getCommandsModelName() {
        String selection = (String)this.commandsUiBox.getSelectedItem();
        if ("-".equals(selection)) {
            return null;
        }
        return selection;
    }

    public String getMappingsModelName() {
        String selection = (String)this.serviceBox.getSelectedItem();
        if ("-".equals(selection)) {
            return null;
        }
        return selection;
    }

    public String getChildListInEntity() {
        String selection = (String)this.childsBox.getSelectedItem();
        if ("-".equals(selection)) {
            return null;
        }
        return selection;
    }

    public void setReadOnly() {
        this.myComponent.setEnabled(false);
    }

    public void showDialog() {
        this.myComponent = this.createPanel();
        this.myComponent.setMinimumSize(new Dimension(600, 400));
        this.setCenterPanel(this.myComponent);
        this.isOkayButton = super.showAndGet();
    }

    public boolean isOkay() {
        return this.isOkayButton;
    }
}

