/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.awt.Component;
import java.awt.Frame;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.extapi.persistence.FileDataSource;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.project.Project;
import jetbrains.mps.refactoring.Renamer;
import jetbrains.mps.smodel.DefaultSModelDescriptor;
import jetbrains.mps.smodel.ModelDependencyResolver;
import jetbrains.mps.smodel.language.LanguageRegistry;
import jetbrains.mps.workbench.action.ActionAccess;
import jetbrains.mps.workbench.action.BaseAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mps.openapi.language.SLanguage;
import org.jetbrains.mps.openapi.model.EditableSModel;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.mps.openapi.module.SModuleReference;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import org.modellwerkstatt.objectflow.runtime.CSVReader;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class GeneralizedAutoRefactor_Action
extends BaseAction {
    private static final Icon ICON = null;

    public GeneralizedAutoRefactor_Action() {
        super("Werkbank - Generalized Auto Refactorer", "", ICON);
        this.setIsAlwaysVisible(false);
        this.setActionAccess((ActionAccess)ActionAccess.UNDO_PROJECT);
        this.updateInBackground(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean collectActionData(AnActionEvent event, Map<String, Object> _params) {
        if (!super.collectActionData(event, _params)) {
            return false;
        }
        Object p = (MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT);
        if (p == null) {
            return false;
        }
        p = (Frame)event.getData(MPSCommonDataKeys.FRAME);
        return p != null;
    }

    public void doExecute(@NotNull AnActionEvent event, Map<String, Object> _params) {
        block5: {
            List allRelevantModels = MoMdlAccess.relevantModels((MPSProject)((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT)), (boolean)true);
            try {
                CopyPasteDialog dialog = new CopyPasteDialog((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), "Generalized Auto Refactorer(csv)");
                dialog.showDialog();
                String csvData = dialog.myText.getText();
                StringReader sr = new StringReader(csvData);
                CSVReader reader = new CSVReader((Reader)sr, '\t');
                List allLines = reader.readAll();
                sr.close();
                String command = ((String[])ListSequence.fromList((List)allLines).getElement(0))[0].toLowerCase();
                System.err.println("\n\n\n- - - - - - - Generalized Auto Refactorer Protocol - - - - - - -");
                System.err.println("Command is '" + command + "'");
                if ("modelrename".equals(command)) {
                    this.renameModels((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), allRelevantModels, ListSequence.fromList((List)allLines).skip(1).toList(), event);
                    break block5;
                }
                if ("genplan".equals(command)) {
                    this.adjustToGenplan(allRelevantModels, event);
                    break block5;
                }
                throw new Exception("Command " + command + " not found.");
            }
            catch (NullPointerException npe) {
                JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), "NPE \n" + OFXConsoleHelper.stackTrace2String((Throwable)npe), "Problem while generating report ..", 0);
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while generating report . ", 0);
            }
        }
    }

    private void renameModels(MPSProject prj, List<SModel> relevantModels, List<String[]> oldNewPairs, AnActionEvent event) {
        ListSequence.fromList(oldNewPairs).visitAll(it -> {
            final String oldName = it[0];
            String newName = it[1];
            System.err.println("'" + oldName + "' '" + newName + "'");
            EditableSModel test = (EditableSModel)ListSequence.fromList((List)relevantModels).findFirst((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Boolean, SModel>(){

                public Boolean invoke(SModel it) {
                    return SModelOperations.getModelName((SModel)it).equals(oldName);
                }
            });
            if (newName.trim().equals("")) {
                this.createMode((SModel)ListSequence.fromList((List)relevantModels).first(), oldName, event);
            } else if (test == null) {
                System.err.println("ERROR: model " + oldName + " not found and thus not renamed to " + newName);
            } else {
                test.getRepository().saveAll();
                test.rename(newName, test.getSource() instanceof FileDataSource);
                Renamer.updateModelAndModuleReferences((Project)prj);
                test.getRepository().saveAll();
                System.err.println("Renamed " + oldName + " to " + newName);
            }
        });
    }

    private void createMode(SModel proto, String name, AnActionEvent event) {
        EditableSModel editableProto = (EditableSModel)proto;
        editableProto.getModelRoot().createModel(name);
        System.err.println("Created model with name '" + name + "'.");
    }

    private boolean toRemoveLang(String candidate, AnActionEvent event) {
        if (candidate.equals("org.modellwerkstatt.dataux")) {
            return true;
        }
        if (candidate.equals("org.modellwerkstatt.objectflow")) {
            return true;
        }
        if (candidate.equals("org.modellwerkstatt.manmap")) {
            return true;
        }
        if (candidate.equals("jetbrains.mps.baseLanguage")) {
            return true;
        }
        if (candidate.equals("jetbrains.mps.baseLanguage.collections")) {
            return true;
        }
        return candidate.equals("jetbrains.mps.baseLanguage.closures");
    }

    private void adjustToGenplan(List<SModel> relevantModels, AnActionEvent event) {
        DefaultSModelDescriptor m;
        ModelDependencyResolver mdr = new ModelDependencyResolver((LanguageRegistry)((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT)).getComponent(LanguageRegistry.class), ((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT)).getRepository());
        SModuleReference refToDevKit = null;
        for (SModel model : relevantModels) {
            if (!(model instanceof DefaultSModelDescriptor)) continue;
            m = (DefaultSModelDescriptor)model;
            for (SModuleReference devKit : m.importedDevkits()) {
                if (!devKit.getModuleName().endsWith("MoWareWerkbank")) continue;
                refToDevKit = devKit;
                System.err.println("Found MoWareWerkbank @ " + m.getName());
            }
        }
        if (refToDevKit != null) {
            for (SModel model : relevantModels) {
                if (model instanceof DefaultSModelDescriptor) {
                    m = (DefaultSModelDescriptor)model;
                    if (m.importedDevkits().size() == 0) {
                        m.addDevKit(refToDevKit);
                        System.err.println(m.getName() + "  added " + refToDevKit.getModuleName());
                    }
                    for (SLanguage lang : mdr.usedLanguages((SModel)m)) {
                        if (!this.toRemoveLang(lang.getQualifiedName(), event)) continue;
                        m.deleteLanguageId(lang);
                        System.err.println(m.getName() + "  removed " + lang.getQualifiedName());
                    }
                    continue;
                }
                System.err.println("IGNORING: " + model.getName());
            }
        } else {
            System.err.println("No ref to devKit MoWareWerkbank found - add it to just one model in your solution!");
        }
    }
}

