/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.awt.Component;
import java.awt.Frame;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SEnumOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.workbench.action.ActionAccess;
import jetbrains.mps.workbench.action.BaseAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SEnumerationLiteral;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.mps.openapi.model.SNode;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import org.modellwerkstatt.objectflow.runtime.CSVWriter;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.util.CommandPermissionsResolver;

public class MoWareCommandPermissions_Action
extends BaseAction {
    private static final Icon ICON = null;

    public MoWareCommandPermissions_Action() {
        super("Werkbank - Report command permissions", "Generate command permission report", ICON);
        this.setIsAlwaysVisible(true);
        this.setActionAccess((ActionAccess)ActionAccess.UNDO_PROJECT);
        this.updateInBackground(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean collectActionData(AnActionEvent event, Map<String, Object> _params) {
        if (!super.collectActionData(event, _params)) {
            return false;
        }
        Object p = (MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT);
        if (p == null) {
            return false;
        }
        p = (Frame)event.getData(MPSCommonDataKeys.FRAME);
        return p != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(@NotNull AnActionEvent event, Map<String, Object> _params) {
        StringWriter myStringWriter = new StringWriter();
        try {
            List allRelevantModels = MoMdlAccess.relevantModels((MPSProject)((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT)), (boolean)true);
            CSVWriter csvWriter = new CSVWriter((Writer)myStringWriter);
            int SEP = 44;
            csvWriter.line("MoWare Werkbank - command permissions,run @ " + new LocalDate());
            csvWriter.line("for project " + ((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT)).getName());
            csvWriter.newLine();
            for (SModel mod : allRelevantModels) {
                List cmdList = SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.Command$nA);
                IListSequence orderedCmds = ListSequence.fromList(new ArrayList());
                ListSequence.fromList((List)orderedCmds).addSequence(ListSequence.fromList((List)cmdList).where(it -> SEnumOperations.isMember((SEnumerationLiteral)SPropertyOperations.getEnum((SNode)it, (SProperty)PROPS.newCommandType$SkFQ), (long)7912134052599425619L)));
                ListSequence.fromList((List)orderedCmds).addSequence(ListSequence.fromList((List)cmdList).where(it -> SEnumOperations.isMember((SEnumerationLiteral)SPropertyOperations.getEnum((SNode)it, (SProperty)PROPS.newCommandType$SkFQ), (long)7912134052599425627L) || SEnumOperations.isMember((SEnumerationLiteral)SPropertyOperations.getEnum((SNode)it, (SProperty)PROPS.newCommandType$SkFQ), (long)8070894678027838570L)));
                ListSequence.fromList((List)orderedCmds).addSequence(ListSequence.fromList((List)cmdList).where(it -> SEnumOperations.isMember((SEnumerationLiteral)SPropertyOperations.getEnum((SNode)it, (SProperty)PROPS.newCommandType$SkFQ), (long)7912134052599425624L)));
                if (ListSequence.fromList((List)orderedCmds).count() > 0) {
                    csvWriter.newLine();
                    csvWriter.line("," + SModelOperations.getModelName((SModel)mod));
                }
                ListSequence.fromList((List)orderedCmds).visitAll(cmd -> {
                    String permissions = CommandPermissionsResolver.resolveCmdPresmission((SNode)cmd);
                    csvWriter.line((String)INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(cmd, new Object[0]) + "," + SPropertyOperations.getEnum((SNode)cmd, (SProperty)PROPS.newCommandType$SkFQ) + "," + permissions);
                });
            }
            try {
                CopyPasteDialog dialog = new CopyPasteDialog((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), "Generated CSV report");
                dialog.myText.setText(myStringWriter.toString());
                dialog.showDialog();
            }
            finally {
                myStringWriter.close();
            }
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), "NPE \n" + OFXConsoleHelper.stackTrace2String((Throwable)npe), "Problem while generating report ..", 0);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while generating report . ", 0);
        }
    }

    private static final class CONCEPTS {
        static final SConcept Command$nA = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)7192042020163999178L, (String)"org.modellwerkstatt.objectflow.structure.Command");

        private CONCEPTS() {
        }
    }

    private static final class PROPS {
        static final SProperty newCommandType$SkFQ = MetaAdapterFactory.getProperty((long)-1438478098872647182L, (long)-8899840368585285001L, (long)7192042020163999178L, (long)7912134052599426179L, (String)"newCommandType");

        private PROPS() {
        }
    }
}

