/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.workbench.action.ActionAccess;
import jetbrains.mps.workbench.action.BaseAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.mps.openapi.model.SNode;
import org.modellwerkstatt.dataux.autcomplete.MoWareDDDTemplateUtil;
import org.modellwerkstatt.dataux.autcomplete.RefResolve;
import org.modellwerkstatt.dataux.plugin.DLGCompleterWindow;
import org.modellwerkstatt.objectflow.behavior.BusinessProperty__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.behavior.IOFXObject__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import org.modellwerkstatt.objectflow.util.OFXLegacyHelper;

public class MoWareDDDTemplate_Action
extends BaseAction {
    private static final Icon ICON = null;

    public MoWareDDDTemplate_Action() {
        super("Werkbank - DDD Template", "Create DDD environment for entity", ICON);
        this.setIsAlwaysVisible(true);
        this.setActionAccess((ActionAccess)ActionAccess.UNDO_PROJECT);
        this.updateInBackground(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean collectActionData(AnActionEvent event, Map<String, Object> _params) {
        if (!super.collectActionData(event, _params)) {
            return false;
        }
        SNode sNode = (SNode)event.getData(MPSCommonDataKeys.NODE);
        Frame p = (Frame)event.getData(MPSCommonDataKeys.FRAME);
        if (p == null) {
            return false;
        }
        p = (MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT);
        return p != null;
    }

    public void doExecute(@NotNull AnActionEvent event, Map<String, Object> _params) {
        SNode entity;
        boolean DEBUG_DAN_SIMPELSOL = false;
        RefResolve refs = new RefResolve();
        MoMdlAccess mh = new MoMdlAccess((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT));
        if (DEBUG_DAN_SIMPELSOL) {
            SModel autoTestModel = mh.getModel("simple.invoice");
            entity = (SNode)ListSequence.fromList((List)SModelOperations.roots((SModel)autoTestModel, (SAbstractConcept)CONCEPTS.Entity$WP)).findFirst(it -> "Invoice".equals(SPropertyOperations.getString((SNode)it, (SProperty)PROPS.name$MnvL)));
            refs.cleanUpModel(autoTestModel);
        } else {
            if (event.getData(MPSCommonDataKeys.NODE) == null || !((SNode)event.getData(MPSCommonDataKeys.NODE)).isInstanceOfConcept((SAbstractConcept)CONCEPTS.Entity$WP) && !((SNode)event.getData(MPSCommonDataKeys.NODE)).isInstanceOfConcept((SAbstractConcept)CONCEPTS.DTO$UE)) {
                JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), "Select the Entity node in the project explorer you want to run the autocomplete over.", "Selection missing", 0);
                return;
            }
            entity = (SNode)event.getData(MPSCommonDataKeys.NODE);
        }
        DLGCompleterWindow dlg = new DLGCompleterWindow((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), (String)IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(entity, new Object[0]), SNodeOperations.isInstanceOf((SNode)entity, (SAbstractConcept)CONCEPTS.DTO$UE));
        dlg.setModels(ListSequence.fromList((List)mh.getAllModelNames()).sort(it -> it, true).toList());
        dlg.setChilds(ListSequence.fromList((List)((List)IOFXObject__BehaviorDescriptor.getBusinessPropertiesAndInherited_id8dakBL3erK.invoke(entity, new Object[0]))).where(it -> OFXLegacyHelper.isCollecitonWithViewOrEntity((SNode)SLinkOperations.getTarget((SNode)it, (SContainmentLink)LINKS.type$56v0))).select(it -> SPropertyOperations.getString((SNode)it, (SProperty)PROPS.name$MnvL)).toList());
        dlg.showDialog();
        try {
            if (dlg.isOkay()) {
                refs.parent = entity;
                if (dlg.getChildListInEntity() != null) {
                    String nameOfChild = dlg.getChildListInEntity();
                    refs.childListInParent = (SNode)ListSequence.fromList((List)((List)IOFXObject__BehaviorDescriptor.getBusinessPropertiesAndInherited_id8dakBL3erK.invoke(entity, new Object[0]))).findFirst(it -> SPropertyOperations.getString((SNode)it, (SProperty)PROPS.name$MnvL).equals(nameOfChild));
                    refs.child = SNodeOperations.cast((SNode)SLinkOperations.getTarget((SNode)SNodeOperations.cast((SNode)SLinkOperations.getTarget((SNode)SNodeOperations.cast((SNode)SLinkOperations.getTarget((SNode)refs.childListInParent, (SContainmentLink)LINKS.type$56v0), (SAbstractConcept)CONCEPTS.ListType$LR), (SContainmentLink)LINKS.elementType$ssn), (SAbstractConcept)CONCEPTS.ClassifierType$bL), (SReferenceLink)LINKS.classifier$cxMr), (SAbstractConcept)CONCEPTS.IOFXObject$Y7);
                    refs.parentRefInChild = (SNode)ListSequence.fromList((List)SLinkOperations.getChildren((SNode)refs.child, (SContainmentLink)LINKS.businessProperties$cI4J)).findFirst(it -> (boolean)((Boolean)BusinessProperty__BehaviorDescriptor.isOpposite_id1jMXz13pjjo.invoke(it, new Object[0])));
                    refs.usingKeyOnlyMapping = !OFXLegacyHelper.isEntityReference((SNode)SLinkOperations.getTarget((SNode)refs.parentRefInChild, (SContainmentLink)LINKS.type$56v0));
                    MoWareDDDTemplateUtil.ld("settings", "Using child list (KeyOnlyMapping is " + refs.usingKeyOnlyMapping + ")");
                }
                MoWareDDDTemplateUtil util = new MoWareDDDTemplateUtil();
                String problems = util.checker(refs, dlg.isMapping(), dlg.isRepo(), dlg.isServiceNFactory(), dlg.isSearchCmd(), dlg.isGraphOwnerCmd(), dlg.isGraphEditCmd(), dlg.isCreatorCmd());
                int answer = 0;
                if (problems != null) {
                    answer = JOptionPane.showConfirmDialog(null, problems + "\n\n\nDo you still want to continue?", "MoWare DDD Template problems detected.", 0);
                }
                if (answer == 0) {
                    refs.modForService = mh.getModel(dlg.getMappingsModelName());
                    refs.modForCmdsUi = mh.getModel(dlg.getCommandsModelName());
                    refs.staticRessources = mh.searchStaticRessources();
                    util.createConceptsForEntity(refs, dlg.isMapping(), dlg.isRepo(), dlg.isServiceNFactory(), dlg.isSearchCmd(), dlg.isGraphOwnerCmd(), dlg.isGraphEditCmd(), dlg.isCreatorCmd());
                }
            }
        }
        catch (Exception e) {
            System.err.println("\n\n\n ------ SERIOUS Problem while auto completing -----------------------------------------\n");
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "A problem occured while trying to generate concepts!\n\n" + e.getMessage() + "\n\n\n", "Serious problem", 0);
        }
    }

    private static final class CONCEPTS {
        static final SConcept Entity$WP = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)1372017518093514468L, (String)"org.modellwerkstatt.objectflow.structure.Entity");
        static final SConcept DTO$UE = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)5225022991485184063L, (String)"org.modellwerkstatt.objectflow.structure.DTO");
        static final SConcept ListType$LR = MetaAdapterFactory.getConcept((long)-8968771020793164004L, (long)-7182180101671965361L, (long)1151688443754L, (String)"jetbrains.mps.baseLanguage.collections.structure.ListType");
        static final SConcept ClassifierType$bL = MetaAdapterFactory.getConcept((long)-935030926396207931L, (long)-6610165693999523818L, (long)1107535904670L, (String)"jetbrains.mps.baseLanguage.structure.ClassifierType");
        static final SInterfaceConcept IOFXObject$Y7 = MetaAdapterFactory.getInterfaceConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4313579457188683399L, (String)"org.modellwerkstatt.objectflow.structure.IOFXObject");

        private CONCEPTS() {
        }
    }

    private static final class LINKS {
        static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1201370618622L, (long)1201371521209L, (String)"type");
        static final SContainmentLink elementType$ssn = MetaAdapterFactory.getContainmentLink((long)-8968771020793164004L, (long)-7182180101671965361L, (long)1151688443754L, (long)1151688676805L, (String)"elementType");
        static final SReferenceLink classifier$cxMr = MetaAdapterFactory.getReferenceLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1107535904670L, (long)1107535924139L, (String)"classifier");
        static final SContainmentLink businessProperties$cI4J = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4313579457188683399L, (long)3207218222495905601L, (String)"businessProperties");

        private LINKS() {
        }
    }

    private static final class PROPS {
        static final SProperty name$MnvL = MetaAdapterFactory.getProperty((long)-3554657779850784990L, (long)-7236703803128771572L, (long)1169194658468L, (long)1169194664001L, (String)"name");

        private PROPS() {
        }
    }
}

