/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.plugin;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.IAttributeDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.model.SNode;

public class TransKeyVal {
    public String key;
    public String info;
    public String nodeId;
    public List<String> trans;

    public TransKeyVal(String k, String in, String nid) {
        if (k == null) {
            throw new RuntimeException("Do not reg null keys!! (here for " + in + ")");
        }
        this.key = k;
        this.trans = ListSequence.fromList(new ArrayList());
        this.info = in;
        this.nodeId = nid;
    }

    public boolean hasTransLations() {
        return ListSequence.fromList(this.trans).count() > 0;
    }

    public String[] asArray() {
        String[] arr = new String[ListSequence.fromList(this.trans).count() + 3];
        int i = 0;
        arr[i++] = this.key;
        arr[i++] = this.info;
        arr[i++] = this.nodeId;
        for (String s : this.trans) {
            arr[i++] = s;
        }
        return arr;
    }

    public static TransKeyVal fromSL(SNode sl, String in) {
        TransKeyVal keyVal = new TransKeyVal(SPropertyOperations.getString((SNode)sl, (SProperty)PROPS.value$w7MM), in, "" + sl.getNodeId());
        if (new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl) != null) {
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl), (SContainmentLink)LINKS.translations$AQU2)).visitAll(it -> ListSequence.fromList(keyVal.trans).addElement((Object)SPropertyOperations.getString((SNode)it, (SProperty)PROPS.value$llEn)));
        }
        return keyVal;
    }

    public static TransKeyVal fromMS(SNode ms, String in) {
        TransKeyVal keyVal = new TransKeyVal(SPropertyOperations.getString((SNode)SNodeOperations.cast((SNode)SLinkOperations.getTarget((SNode)ms, (SContainmentLink)LINKS.formatString$GGXJ), (SAbstractConcept)CONCEPTS.StringFormatString$sD), (SProperty)PROPS.formatStringValue$2TVh), in, "" + ms.getNodeId());
        if (ListSequence.fromList((List)SLinkOperations.getChildren((SNode)ms, (SContainmentLink)LINKS.translations$kKvQ)).count() > 0) {
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)ms, (SContainmentLink)LINKS.translations$kKvQ)).visitAll(it -> ListSequence.fromList(keyVal.trans).addElement((Object)SPropertyOperations.getString((SNode)it, (SProperty)PROPS.formatString$eXrT)));
        }
        return keyVal;
    }

    public static TransKeyVal fromCSV(String[] in) {
        if (in.length < 3) {
            throw new RuntimeException("Need at least 3 columns for lang-csv: " + TransKeyVal.printArray(in));
        }
        TransKeyVal keyVal = new TransKeyVal(in[0], in[1], in[2]);
        for (int i = 3; i < in.length; ++i) {
            ListSequence.fromList(keyVal.trans).addElement((Object)in[i]);
        }
        return keyVal;
    }

    public static void updateSLifTransNotNull(TransKeyVal val, SNode sl) {
        if (val == null || !val.hasTransLations()) {
            return;
        }
        if (new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl) == null) {
            new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).setNew(sl);
        }
        int index = 0;
        for (String singleT : val.trans) {
            if (ListSequence.fromList((List)SLinkOperations.getChildren((SNode)new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl), (SContainmentLink)LINKS.translations$AQU2)).count() <= index) {
                SLinkOperations.addNewChild((SNode)new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl), (SContainmentLink)LINKS.translations$AQU2, (SAbstractConcept)CONCEPTS.TranslatedStringLiteral$rI);
            }
            if (!singleT.equals(SPropertyOperations.getString((SNode)((SNode)ListSequence.fromList((List)SLinkOperations.getChildren((SNode)new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl), (SContainmentLink)LINKS.translations$AQU2)).getElement(index)), (SProperty)PROPS.value$llEn))) {
                SPropertyOperations.assign((SNode)((SNode)ListSequence.fromList((List)SLinkOperations.getChildren((SNode)new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl), (SContainmentLink)LINKS.translations$AQU2)).getElement(index)), (SProperty)PROPS.value$llEn, (String)singleT);
            }
            ++index;
        }
    }

    public static void updateMSifTransNotNull(TransKeyVal val, SNode ms) {
        if (val == null || !val.hasTransLations()) {
            return;
        }
        int index = 0;
        for (String singleT : val.trans) {
            if (ListSequence.fromList((List)SLinkOperations.getChildren((SNode)ms, (SContainmentLink)LINKS.translations$kKvQ)).count() <= index) {
                SLinkOperations.addNewChild((SNode)ms, (SContainmentLink)LINKS.translations$kKvQ, (SAbstractConcept)CONCEPTS.TranslatedMultiString$Cx);
            }
            if (!singleT.equals(SPropertyOperations.getString((SNode)((SNode)ListSequence.fromList((List)SLinkOperations.getChildren((SNode)ms, (SContainmentLink)LINKS.translations$kKvQ)).getElement(index)), (SProperty)PROPS.formatString$eXrT))) {
                SPropertyOperations.assign((SNode)((SNode)ListSequence.fromList((List)SLinkOperations.getChildren((SNode)ms, (SContainmentLink)LINKS.translations$kKvQ)).getElement(index)), (SProperty)PROPS.formatString$eXrT, (String)singleT);
            }
            ++index;
        }
    }

    public static String printArray(String[] ar) {
        StringBuilder sb = new StringBuilder();
        for (String s : ar) {
            sb.append(s + ", ");
        }
        return sb.toString();
    }

    private static final class PROPS {
        static final SProperty value$w7MM = MetaAdapterFactory.getProperty((long)-935030926396207931L, (long)-6610165693999523818L, (long)1070475926800L, (long)1070475926801L, (String)"value");
        static final SProperty value$llEn = MetaAdapterFactory.getProperty((long)-1438478098872647182L, (long)-8899840368585285001L, (long)6436022531931825983L, (long)6436022531931826103L, (String)"value");
        static final SProperty formatStringValue$2TVh = MetaAdapterFactory.getProperty((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4986415014450757922L, (long)4986415014450757981L, (String)"formatStringValue");
        static final SProperty formatString$eXrT = MetaAdapterFactory.getProperty((long)-1438478098872647182L, (long)-8899840368585285001L, (long)3976364335720280601L, (long)3976364335720280712L, (String)"formatString");

        private PROPS() {
        }
    }

    private static final class CONCEPTS {
        static final SConcept StringLiteralTransAttribut$Bh = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)6436022531931825683L, (String)"org.modellwerkstatt.objectflow.structure.StringLiteralTransAttribut");
        static final SConcept StringFormatString$sD = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4986415014450757922L, (String)"org.modellwerkstatt.objectflow.structure.StringFormatString");
        static final SConcept TranslatedStringLiteral$rI = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)6436022531931825983L, (String)"org.modellwerkstatt.objectflow.structure.TranslatedStringLiteral");
        static final SConcept TranslatedMultiString$Cx = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)3976364335720280601L, (String)"org.modellwerkstatt.objectflow.structure.TranslatedMultiString");

        private CONCEPTS() {
        }
    }

    private static final class LINKS {
        static final SContainmentLink translations$AQU2 = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)6436022531931825683L, (long)6436022531931826628L, (String)"translations");
        static final SContainmentLink formatString$GGXJ = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)3585259589779248202L, (long)4986415014450757612L, (String)"formatString");
        static final SContainmentLink translations$kKvQ = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)3585259589779248202L, (long)3976364335720280796L, (String)"translations");

        private LINKS() {
        }
    }
}

