/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.intentions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jetbrains.mps.intentions.AbstractIntentionAspectDescriptor;
import jetbrains.mps.lang.smodel.ConceptSwitchIndex;
import jetbrains.mps.lang.smodel.ConceptSwitchIndexBuilder;
import jetbrains.mps.openapi.intentions.IntentionFactory;
import jetbrains.mps.smodel.adapter.ids.MetaIdFactory;
import jetbrains.mps.smodel.adapter.ids.SConceptId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.modellwerkstatt.dataux.intentions.AutoCompleteDelegates_Intention;
import org.modellwerkstatt.dataux.intentions.AutoCompleteEditorPagePane_Intention;
import org.modellwerkstatt.dataux.intentions.AutoCompleteMainDocPagePane_Intention;
import org.modellwerkstatt.dataux.intentions.AutoCompleteTablePagePane_Intention;
import org.modellwerkstatt.dataux.intentions.ConvertLvdsToGlobalApiVarDecl_Intention;
import org.modellwerkstatt.dataux.intentions.NameElement_Intention;
import org.modellwerkstatt.dataux.intentions.RemoveInnerGraphEdit_Intention;

public final class IntentionsDescriptor
extends AbstractIntentionAspectDescriptor {
    private static final IntentionFactory[] EMPTY_ARRAY = new IntentionFactory[0];
    private Map<SAbstractConcept, IntentionFactory[]> myCached = new HashMap<SAbstractConcept, IntentionFactory[]>();
    private static final ConceptSwitchIndex conceptIndex = new ConceptSwitchIndexBuilder().put(new SConceptId[]{MetaIdFactory.conceptId((long)7254672812249400821L, (long)-9017496836359438957L, (long)465568541575437347L), MetaIdFactory.conceptId((long)7254672812249400821L, (long)-9017496836359438957L, (long)5337297293525625533L), MetaIdFactory.conceptId((long)-935030926396207931L, (long)-6610165693999523818L, (long)1068581242864L), MetaIdFactory.conceptId((long)7254672812249400821L, (long)-9017496836359438957L, (long)2019652483308169511L), MetaIdFactory.conceptId((long)-1438478098872647182L, (long)-8899840368585285001L, (long)7192042020163999174L)}).seal();

    @Nullable
    public Collection<IntentionFactory> getIntentions(@NotNull SAbstractConcept concept) {
        if (this.myCached.containsKey(concept)) {
            return Arrays.asList(this.myCached.get(concept));
        }
        IntentionFactory[] intentions = EMPTY_ARRAY;
        SAbstractConcept cncpt = concept;
        switch (conceptIndex.index(cncpt)) {
            case 0: {
                intentions = new IntentionFactory[]{new AutoCompleteDelegates_Intention()};
                break;
            }
            case 1: {
                intentions = new IntentionFactory[]{new NameElement_Intention()};
                break;
            }
            case 2: {
                intentions = new IntentionFactory[]{new ConvertLvdsToGlobalApiVarDecl_Intention()};
                break;
            }
            case 3: {
                intentions = new IntentionFactory[]{new RemoveInnerGraphEdit_Intention()};
                break;
            }
            case 4: {
                intentions = new IntentionFactory[]{new AutoCompleteEditorPagePane_Intention(), new AutoCompleteMainDocPagePane_Intention(), new AutoCompleteTablePagePane_Intention()};
                break;
            }
        }
        this.myCached.put(concept, intentions);
        return Arrays.asList(intentions);
    }

    @NotNull
    public Collection<IntentionFactory> getAllIntentions() {
        IntentionFactory[] rv = new IntentionFactory[]{new NameElement_Intention(), new AutoCompleteDelegates_Intention(), new RemoveInnerGraphEdit_Intention(), new AutoCompleteEditorPagePane_Intention(), new AutoCompleteMainDocPagePane_Intention(), new AutoCompleteTablePagePane_Intention(), new ConvertLvdsToGlobalApiVarDecl_Intention()};
        return Arrays.asList(rv);
    }
}

