/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.awt.Component;
import java.awt.Frame;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.workbench.action.ActionAccess;
import jetbrains.mps.workbench.action.BaseAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mps.openapi.model.SModel;
import org.modellwerkstatt.dataux.plugin.TransHelper;
import org.modellwerkstatt.dataux.plugin.TransKeyVal;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import org.modellwerkstatt.objectflow.runtime.CSVWriter;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class LanguageStringsExport_Action
extends BaseAction {
    private static final Icon ICON = null;

    public LanguageStringsExport_Action() {
        super("Werkbank - Language Translations export", "", ICON);
        this.setIsAlwaysVisible(false);
        this.setActionAccess((ActionAccess)ActionAccess.UNDO_PROJECT);
        this.updateInBackground(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean collectActionData(AnActionEvent event, Map<String, Object> _params) {
        if (!super.collectActionData(event, _params)) {
            return false;
        }
        Frame p = (Frame)event.getData(MPSCommonDataKeys.FRAME);
        if (p == null) {
            return false;
        }
        p = (MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT);
        return p != null;
    }

    public void doExecute(@NotNull AnActionEvent event, Map<String, Object> _params) {
        try {
            List models = MoMdlAccess.relevantModels((MPSProject)((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT)), (boolean)true);
            Object translations = ListSequence.fromList(new ArrayList());
            for (SModel m : models) {
                System.err.println("Checking model " + SModelOperations.getModelName((SModel)m));
                TransHelper.attachToList((List<TransKeyVal>)translations, TransHelper.fromStati(m));
                TransHelper.attachToList((List<TransKeyVal>)translations, TransHelper.fromIOFXObjects(m));
                TransHelper.attachToList((List<TransKeyVal>)translations, TransHelper.fromUiLabels(m));
                TransHelper.attachToList((List<TransKeyVal>)translations, TransHelper.fromMultiStrings(m));
                TransHelper.attachToList((List<TransKeyVal>)translations, TransHelper.fromOldStringLiteralInFlagCommand(m));
                TransHelper.attachToList((List<TransKeyVal>)translations, TransHelper.fromDataUX(m));
            }
            translations = ListSequence.fromList((List)translations).sort(it -> Integer.valueOf(it.key.length()), true).alsoSort(it -> it.key, true).toList();
            StringWriter sw = new StringWriter();
            CSVWriter write = new CSVWriter((Writer)sw);
            ListSequence.fromList((List)translations).visitAll(it -> write.writeNext(it.asArray()));
            CopyPasteDialog dialog = new CopyPasteDialog((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), "Exported Strings for translation (csv)");
            dialog.myText.setText(sw.toString());
            try {
                sw.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            dialog.showDialog();
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), "Null Pointer Exception \n" + OFXConsoleHelper.stackTrace2String((Throwable)npe), "Problem while importing langstrings... ", 0);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while importing langstrings... ", 0);
        }
    }
}

