/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.awt.Component;
import java.awt.Frame;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.workbench.action.ActionAccess;
import jetbrains.mps.workbench.action.BaseAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mps.openapi.model.SModel;
import org.modellwerkstatt.dataux.plugin.TransHelper;
import org.modellwerkstatt.dataux.plugin.TransKeyVal;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import org.modellwerkstatt.objectflow.runtime.CSVReader;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class LanguageStringsImport_Action
extends BaseAction {
    private static final Icon ICON = null;

    public LanguageStringsImport_Action() {
        super("Werkbank - Language Translations import", "", ICON);
        this.setIsAlwaysVisible(false);
        this.setActionAccess((ActionAccess)ActionAccess.UNDO_PROJECT);
        this.updateInBackground(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean collectActionData(AnActionEvent event, Map<String, Object> _params) {
        if (!super.collectActionData(event, _params)) {
            return false;
        }
        Frame p = (Frame)event.getData(MPSCommonDataKeys.FRAME);
        if (p == null) {
            return false;
        }
        p = (MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT);
        return p != null;
    }

    public void doExecute(@NotNull AnActionEvent event, Map<String, Object> _params) {
        try {
            List models = MoMdlAccess.relevantModels((MPSProject)((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT)), (boolean)true);
            IListSequence translations = ListSequence.fromList(new ArrayList());
            CopyPasteDialog dialog = new CopyPasteDialog((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), "Exported Strings for translation (csv)");
            dialog.showDialog();
            String csvData = dialog.myText.getText();
            StringReader sr = new StringReader(csvData);
            CSVReader reader = new CSVReader((Reader)sr);
            List allLines = reader.readAll();
            sr.close();
            for (String[] line : allLines) {
                ListSequence.fromList((List)translations).addElement((Object)TransKeyVal.fromCSV(line));
            }
            for (SModel m : models) {
                TransHelper.updateStati(m, (List<TransKeyVal>)translations);
                TransHelper.updateIOFXObjects(m, (List<TransKeyVal>)translations);
                TransHelper.updateUiLabels(m, (List<TransKeyVal>)translations);
                TransHelper.updateMultiStrings(m, (List<TransKeyVal>)translations);
                TransHelper.updateOldStringLiteralInFlagCommand(m, (List<TransKeyVal>)translations);
                TransHelper.updateDataUX(m, (List<TransKeyVal>)translations);
            }
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), "Null Pointer Exception \n" + OFXConsoleHelper.stackTrace2String((Throwable)npe), "Problem while importing langstrings... ", 0);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while importing langstrings... ", 0);
        }
    }
}

