/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.awt.Component;
import java.awt.Frame;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jetbrains.mps.baseLanguage.behavior.Classifier__BehaviorDescriptor;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.lang.core.behavior.BaseConcept__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.lang.text.behavior.TextElement__BehaviorDescriptor;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.smodel.SModelInternal;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.workbench.action.ActionAccess;
import jetbrains.mps.workbench.action.BaseAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.mps.openapi.model.SModelReference;
import org.jetbrains.mps.openapi.model.SNode;
import org.joda.time.LocalDate;
import org.modellwerkstatt.manmap.behavior.Repository__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.behavior.Service__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import org.modellwerkstatt.objectflow.runtime.CSVWriter;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class MoWareDDDAnalyzer_Action
extends BaseAction {
    private static final Icon ICON = null;

    public MoWareDDDAnalyzer_Action() {
        super("Werkbank - Report of DDD analyzer", "Generate DDD report", ICON);
        this.setIsAlwaysVisible(true);
        this.setActionAccess((ActionAccess)ActionAccess.UNDO_PROJECT);
        this.updateInBackground(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean collectActionData(AnActionEvent event, Map<String, Object> _params) {
        if (!super.collectActionData(event, _params)) {
            return false;
        }
        Object p = (MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT);
        if (p == null) {
            return false;
        }
        p = (Frame)event.getData(MPSCommonDataKeys.FRAME);
        return p != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(@NotNull AnActionEvent event, Map<String, Object> _params) {
        boolean TESTS_ALSO = true;
        StringWriter myStringWriter = new StringWriter();
        IListSequence allCommands = ListSequence.fromList(new ArrayList());
        IListSequence allRepos = ListSequence.fromList(new ArrayList());
        IListSequence allServices = ListSequence.fromList(new ArrayList());
        IListSequence allCalls = ListSequence.fromList(new ArrayList());
        IListSequence allObjects = ListSequence.fromList(new ArrayList());
        IListSequence allObjectMethodCalls = ListSequence.fromList(new ArrayList());
        try {
            List allRelevantModels = MoMdlAccess.relevantModels((MPSProject)((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT)), (boolean)TESTS_ALSO);
            for (SModel mod : allRelevantModels) {
                ListSequence.fromList((List)allCommands).addSequence((ISequence)ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.Command$nA)));
                ListSequence.fromList((List)allRepos).addSequence((ISequence)ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.Repository$WM)));
                ListSequence.fromList((List)allServices).addSequence((ISequence)ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.Service$HK)));
                ListSequence.fromList((List)allCalls).addSequence((ISequence)ListSequence.fromList((List)SModelOperations.nodes((SModel)mod, (SAbstractConcept)CONCEPTS.OperationCall$7H)));
                ListSequence.fromList((List)allObjects).addSequence((ISequence)ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.IOFXObject$Y7)));
                ListSequence.fromList((List)allObjectMethodCalls).addSequence((ISequence)ListSequence.fromList((List)SModelOperations.nodes((SModel)mod, (SAbstractConcept)CONCEPTS.InstanceMethodCallOperation$uu)));
            }
            CSVWriter csvWriter = new CSVWriter((Writer)myStringWriter);
            char SEP = ',';
            csvWriter.line("MoWare Werkbank - DDD Analyzer" + SEP + "run @ " + new LocalDate());
            csvWriter.line("for project " + ((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT)).getName());
            csvWriter.newLine();
            csvWriter.line("Models in project " + ((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT)).getName());
            String[] headers = new String[]{"Model", "Nodes", "Entities", "ValueObjects", "DTOs", "Commands", "UxRoots", "Services", "Repos", "Tests", "Apps", "Jobs", "Imports", "ImportedBy"};
            csvWriter.writeNext(headers);
            int[] totals = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            for (SModel mod : allRelevantModels) {
                List<String> imports = this.imports(allRelevantModels, mod, event);
                List<SModel> importedBy = this.importedBy(allRelevantModels, mod, event);
                int[] data = new int[]{ListSequence.fromList((List)SModelOperations.nodes((SModel)mod, null)).count(), ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.Entity$WP)).count(), ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.ValueObject$bz)).count(), ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.DTO$UE)).count(), ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.Command$nA)).count(), ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.UxRoot$gH)).count(), ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.Service$HK)).count(), ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.Repository$WM)).count(), ListSequence.fromList((List)SModelOperations.nodes((SModel)mod, (SAbstractConcept)CONCEPTS.OFXTestMethod$cv)).count(), ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.AppUiModule$oo)).count(), ListSequence.fromList((List)SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.BatchJobModule$QP)).count(), ListSequence.fromList(imports).count(), ListSequence.fromList(importedBy).count()};
                String importsText = IterableUtils.join((Iterable)ListSequence.fromList(imports).select(it -> MoVersion.getCapitalizedShortNameFromFQ((String)it)), (String)" ");
                String importedByText = IterableUtils.join((Iterable)ListSequence.fromList(importedBy).select(it -> MoVersion.getCapitalizedShortNameFromFQ((String)SModelOperations.getModelName((SModel)it))), (String)" ");
                csvWriter.writeNext(this.updateTotals(SModelOperations.getModelName((SModel)mod), data, totals, new String[]{importsText, importedByText}, event));
            }
            csvWriter.writeNext(this.updateTotals("TOTAL", totals, totals, new String[0], event));
            csvWriter.newLine();
            csvWriter.newLine();
            csvWriter.line("Service & Repo Analysis");
            csvWriter.writeNext(new String[]{"", "model", "name", "nodes", "methods", "privat", "protected", "public", "cmds", "tests"});
            ListSequence.fromList((List)allServices).visitAll(arg_0 -> this.lambda$doExecute$2(csvWriter, (List)allCalls, event, arg_0));
            ListSequence.fromList((List)allRepos).visitAll(arg_0 -> this.lambda$doExecute$3(csvWriter, (List)allCalls, event, arg_0));
            csvWriter.newLine();
            csvWriter.newLine();
            csvWriter.line("Method Analysis");
            csvWriter.writeNext(new String[]{"", "model", "component", "name", "nodes", "privat", "protected", "public", "fan-out", "cmds", "tests"});
            ListSequence.fromList((List)allServices).visitAll(arg_0 -> this.lambda$doExecute$5(csvWriter, event, (List)allCalls, arg_0));
            ListSequence.fromList((List)allRepos).visitAll(arg_0 -> this.lambda$doExecute$7(csvWriter, event, (List)allCalls, arg_0));
            csvWriter.newLine();
            csvWriter.newLine();
            csvWriter.line("Object Analysis");
            csvWriter.writeNext(new String[]{"", "model", "component", "name", "nodes", "privat", "protected", "public", "cmds", "tests"});
            ListSequence.fromList((List)allObjects).visitAll(arg_0 -> this.lambda$doExecute$9(csvWriter, event, (List)allObjectMethodCalls, arg_0));
            csvWriter.newLine();
            csvWriter.newLine();
            csvWriter.line("ToDo & Deprecated summary of all models:");
            Wrappers._int toDosTotal = new Wrappers._int(0);
            Wrappers._int deprecatedTota = new Wrappers._int(0);
            for (SModel mod : allRelevantModels) {
                ListSequence.fromList((List)SModelOperations.nodes((SModel)mod, (SAbstractConcept)CONCEPTS.Word$Dn)).where(it -> MoWareDDDAnalyzer_Action.isNotEmptyString(SPropertyOperations.getString((SNode)it, (SProperty)PROPS.value$zQr_)) && SPropertyOperations.getString((SNode)it, (SProperty)PROPS.value$zQr_).toLowerCase().contains("todo")).visitAll(it -> {
                    String fullComment = IterableUtils.join((Iterable)ListSequence.fromList((List)SLinkOperations.getChildren((SNode)SNodeOperations.cast((SNode)SNodeOperations.getParent((SNode)it), (SAbstractConcept)CONCEPTS.Line$yC), (SContainmentLink)LINKS.elements$_j45)).select((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<String, SNode>(){

                        public String invoke(SNode it) {
                            return (String)TextElement__BehaviorDescriptor.getTextualRepresentation_idfB3l81it7u.invoke(it, new Object[0]);
                        }
                    }), (String)" ");
                    csvWriter.line("Todo", MoVersion.getCapitalizedShortNameFromFQ((String)SModelOperations.getModelName((SModel)mod)), SNodeOperations.present((SNode)SNodeOperations.getContainingRoot((SNode)it)), fullComment);
                    ++toDosTotal.value;
                });
                ListSequence.fromList((List)SModelOperations.nodes((SModel)mod, (SAbstractConcept)CONCEPTS.AnnotationInstance$yl)).where(it -> SPropertyOperations.getString((SNode)SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.annotation$12Ek), (SProperty)PROPS.name$MnvL).equals("Deprecated")).visitAll(it -> {
                    csvWriter.line("Deprecated", MoVersion.getCapitalizedShortNameFromFQ((String)SModelOperations.getModelName((SModel)mod)), SNodeOperations.present((SNode)SNodeOperations.getContainingRoot((SNode)it)), "Deprecated " + (String)BaseConcept__BehaviorDescriptor.getPresentation_idhEwIMiw.invoke(SNodeOperations.getParent((SNode)it), new Object[0]));
                    ++deprecatedTota.value;
                });
            }
            csvWriter.line("Todos total", "" + toDosTotal.value, "Deprecated total", "" + deprecatedTota.value);
            csvWriter.newLine();
            csvWriter.newLine();
            try {
                CopyPasteDialog dialog = new CopyPasteDialog((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), "Generated CSV report");
                dialog.myText.setText(myStringWriter.toString());
                dialog.showDialog();
            }
            finally {
                myStringWriter.close();
            }
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), "NPE \n" + OFXConsoleHelper.stackTrace2String((Throwable)npe), "Problem while generating report ..", 0);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while generating report . ", 0);
        }
    }

    private String tos(int val, AnActionEvent event) {
        return val > 0 ? "" + val : "";
    }

    private String[] updateTotals(String modelName, int[] data, int[] totals, String[] addOnContent, AnActionEvent event) {
        int i;
        String[] conv = new String[data.length + 1 + addOnContent.length];
        conv[0] = modelName;
        for (i = 1; i <= data.length; ++i) {
            int d = data[i - 1];
            conv[i] = this.tos(d, event);
            int n = i - 1;
            totals[n] = totals[n] + data[i - 1];
        }
        for (i = data.length + 1; i < data.length + 1 + addOnContent.length; ++i) {
            conv[i] = addOnContent[i - (data.length + 1)];
        }
        return conv;
    }

    private List<SModel> importedBy(List<SModel> allModels, SModel toInspect, AnActionEvent event) {
        IListSequence dependentModel = ListSequence.fromList(new ArrayList());
        String lookingForFqName = SModelOperations.getModelName((SModel)toInspect);
        for (SModel a : allModels) {
            SModelInternal aInternal = (SModelInternal)a;
            for (SModelReference ref : aInternal.getModelImports()) {
                if (!ref.getModelName().equals(lookingForFqName)) continue;
                ListSequence.fromList((List)dependentModel).addElement((Object)a);
            }
        }
        return dependentModel;
    }

    private List<String> imports(List<SModel> allModels, SModel toInspect, AnActionEvent event) {
        IListSequence imported = ListSequence.fromList(new ArrayList());
        List relevant = ListSequence.fromList(allModels).select(it -> SModelOperations.getModelName((SModel)it)).toList();
        SModelInternal iInternal = (SModelInternal)toInspect;
        for (SModelReference ref : iInternal.getModelImports()) {
            if (!ListSequence.fromList((List)relevant).contains((Object)ref.getModelName())) continue;
            ListSequence.fromList((List)imported).addElement((Object)ref.getModelName());
        }
        return imported;
    }

    private int privatUsageCmpt(List<SNode> allCalls, SNode cmpt, AnActionEvent event) {
        int opCalls = ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.runtimeHandledObject$2jLr) == cmpt && SNodeOperations.getContainingRoot((SNode)it) == cmpt).count();
        return opCalls += ListSequence.fromList((List)SNodeOperations.getNodeDescendants((SNode)cmpt, (SAbstractConcept)CONCEPTS.LocalMethodCall$zT, (boolean)false, (SAbstractConcept[])new SAbstractConcept[0])).count();
    }

    private List<SNode> protectedUsageCmpt(List<SNode> allCalls, SNode cmpt, AnActionEvent event) {
        return ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.runtimeHandledObject$2jLr) == cmpt && SNodeOperations.getModel((SNode)it) == SNodeOperations.getModel((SNode)cmpt) && SNodeOperations.getContainingRoot((SNode)it) != cmpt).toList();
    }

    private List<SNode> publicUsageCmpt(List<SNode> allCalls, SNode cmpt, AnActionEvent event) {
        return ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.runtimeHandledObject$2jLr) == cmpt && SNodeOperations.getModel((SNode)it) != SNodeOperations.getModel((SNode)cmpt) && !SNodeOperations.isInstanceOf((SNode)SNodeOperations.getContainingRoot((SNode)it), (SAbstractConcept)CONCEPTS.OFXTestSuit$Iy)).toList();
    }

    private List<SNode> inTestUsageCmpt(List<SNode> allCalls, SNode cmpt, AnActionEvent event) {
        return ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.runtimeHandledObject$2jLr) == cmpt && SNodeOperations.getModel((SNode)it) != SNodeOperations.getModel((SNode)cmpt) && SNodeOperations.isInstanceOf((SNode)SNodeOperations.getContainingRoot((SNode)it), (SAbstractConcept)CONCEPTS.OFXTestSuit$Iy)).toList();
    }

    private List<SNode> inCmdUsageCmpt(List<SNode> allCalls, SNode cmpt, AnActionEvent event) {
        return ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.runtimeHandledObject$2jLr) == cmpt && SNodeOperations.isInstanceOf((SNode)SNodeOperations.getContainingRoot((SNode)it), (SAbstractConcept)CONCEPTS.Command$nA)).toList();
    }

    private int privatUsageMeth(List<SNode> allCalls, SNode m, AnActionEvent event) {
        int opCalls = ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getContainingRoot((SNode)it) == SNodeOperations.getContainingRoot((SNode)m)).count();
        return opCalls += ListSequence.fromList((List)SNodeOperations.getNodeDescendants((SNode)SNodeOperations.getContainingRoot((SNode)m), (SAbstractConcept)CONCEPTS.LocalMethodCall$zT, (boolean)false, (SAbstractConcept[])new SAbstractConcept[0])).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.baseMethodDeclaration$pyYw) == m).count();
    }

    private List<SNode> protectedUsageMeth(List<SNode> allCalls, SNode m, AnActionEvent event) {
        return ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getModel((SNode)it) == SNodeOperations.getModel((SNode)m) && SNodeOperations.getContainingRoot((SNode)it) != SNodeOperations.getContainingRoot((SNode)m)).toList();
    }

    private List<SNode> publicUsageMeth(List<SNode> allCalls, SNode m, AnActionEvent event) {
        return ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getModel((SNode)it) != SNodeOperations.getModel((SNode)m) && !SNodeOperations.isInstanceOf((SNode)SNodeOperations.getContainingRoot((SNode)it), (SAbstractConcept)CONCEPTS.OFXTestSuit$Iy)).toList();
    }

    private List<SNode> inTestUsageMeth(List<SNode> allCalls, SNode m, AnActionEvent event) {
        return ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getModel((SNode)it) != SNodeOperations.getModel((SNode)m) && SNodeOperations.isInstanceOf((SNode)SNodeOperations.getContainingRoot((SNode)it), (SAbstractConcept)CONCEPTS.OFXTestSuit$Iy)).toList();
    }

    private List<SNode> inCmdUsageMeth(List<SNode> allCalls, SNode m, AnActionEvent event) {
        return ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.isInstanceOf((SNode)SNodeOperations.getContainingRoot((SNode)it), (SAbstractConcept)CONCEPTS.Command$nA)).toList();
    }

    private String methodInfo(SNode imd, AnActionEvent event) {
        String st = (String)BaseConcept__BehaviorDescriptor.getPresentation_idhEwIMiw.invoke(SLinkOperations.getTarget((SNode)imd, (SContainmentLink)LINKS.returnType$5xoi), new Object[0]) + " " + SPropertyOperations.getString((SNode)imd, (SProperty)PROPS.name$MnvL) + " (";
        st = st + IterableUtils.join((Iterable)ListSequence.fromList((List)SLinkOperations.getChildren((SNode)imd, (SContainmentLink)LINKS.parameter$5xBj)).select(it -> (String)BaseConcept__BehaviorDescriptor.getPresentation_idhEwIMiw.invoke(SLinkOperations.getTarget((SNode)it, (SContainmentLink)LINKS.type$a1UY), new Object[0])), (String)", ");
        return st + ")";
    }

    private int methodForeignOpCalls(SNode imd, AnActionEvent event) {
        return ListSequence.fromList((List)SNodeOperations.getNodeDescendants((SNode)imd, (SAbstractConcept)CONCEPTS.OperationCall$7H, (boolean)false, (SAbstractConcept[])new SAbstractConcept[0])).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.runtimeHandledObject$2jLr) != SNodeOperations.getContainingRoot((SNode)imd)).count();
    }

    private int privatUsageObjMeth(List<SNode> allCalls, SNode m, AnActionEvent event) {
        int opCalls = ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getContainingRoot((SNode)it) == SNodeOperations.getContainingRoot((SNode)m)).count();
        return opCalls += ListSequence.fromList((List)SNodeOperations.getNodeDescendants((SNode)SNodeOperations.getContainingRoot((SNode)m), (SAbstractConcept)CONCEPTS.LocalMethodCall$zT, (boolean)false, (SAbstractConcept[])new SAbstractConcept[0])).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.baseMethodDeclaration$pyYw) == m).count();
    }

    private List<SNode> protectedUsageObjMeth(List<SNode> allCalls, SNode m, AnActionEvent event) {
        return ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getModel((SNode)it) == SNodeOperations.getModel((SNode)m) && SNodeOperations.getContainingRoot((SNode)it) != SNodeOperations.getContainingRoot((SNode)m)).toList();
    }

    private List<SNode> publicUsageObjMeth(List<SNode> allCalls, SNode m, AnActionEvent event) {
        return ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getModel((SNode)it) != SNodeOperations.getModel((SNode)m) && !SNodeOperations.isInstanceOf((SNode)SNodeOperations.getContainingRoot((SNode)it), (SAbstractConcept)CONCEPTS.OFXTestSuit$Iy)).toList();
    }

    private List<SNode> inTestUsageObjMeth(List<SNode> allCalls, SNode m, AnActionEvent event) {
        return ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getModel((SNode)it) != SNodeOperations.getModel((SNode)m) && SNodeOperations.isInstanceOf((SNode)SNodeOperations.getContainingRoot((SNode)it), (SAbstractConcept)CONCEPTS.OFXTestSuit$Iy)).toList();
    }

    private List<SNode> inCmdUsageObjMeth(List<SNode> allCalls, SNode m, AnActionEvent event) {
        return ListSequence.fromList(allCalls).where(it -> SLinkOperations.getTarget((SNode)it, (SReferenceLink)LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.isInstanceOf((SNode)SNodeOperations.getContainingRoot((SNode)it), (SAbstractConcept)CONCEPTS.Command$nA)).toList();
    }

    private static boolean isNotEmptyString(String str) {
        return str != null && str.length() > 0;
    }

    private /* synthetic */ void lambda$doExecute$9(CSVWriter csvWriter, AnActionEvent event, List allObjectMethodCalls, SNode it) {
        Sequence.fromIterable((Iterable)((Iterable)Classifier__BehaviorDescriptor.methods_id4_LVZ3pBKCn.invoke(SNodeOperations.cast((SNode)it, (SAbstractConcept)CONCEPTS.ClassConcept$bK), new Object[0]))).visitAll(method -> {
            String type = "obj";
            if (SNodeOperations.isInstanceOf((SNode)it, (SAbstractConcept)CONCEPTS.Entity$WP)) {
                type = "entity";
            } else if (SNodeOperations.isInstanceOf((SNode)it, (SAbstractConcept)CONCEPTS.DTO$UE)) {
                type = "dto";
            } else if (SNodeOperations.isInstanceOf((SNode)it, (SAbstractConcept)CONCEPTS.ValueObject$bz)) {
                type = "vo";
            }
            csvWriter.writeNext(new String[]{type, SModelOperations.getModelName((SModel)SNodeOperations.getModel((SNode)method)), SNodeOperations.present((SNode)SNodeOperations.getContainingRoot((SNode)method)), this.methodInfo((SNode)method, event), "" + ListSequence.fromList((List)SNodeOperations.getNodeDescendants((SNode)method, null, (boolean)false, (SAbstractConcept[])new SAbstractConcept[0])).count(), this.tos(this.privatUsageObjMeth(allObjectMethodCalls, (SNode)method, event), event), this.tos(ListSequence.fromList(this.protectedUsageObjMeth(allObjectMethodCalls, (SNode)method, event)).count(), event), this.tos(ListSequence.fromList(this.publicUsageObjMeth(allObjectMethodCalls, (SNode)method, event)).count(), event), this.tos(ListSequence.fromList(this.inCmdUsageObjMeth(allObjectMethodCalls, (SNode)method, event)).count(), event), this.tos(ListSequence.fromList(this.inTestUsageObjMeth(allObjectMethodCalls, (SNode)method, event)).count(), event)});
        });
    }

    private /* synthetic */ void lambda$doExecute$7(CSVWriter csvWriter, AnActionEvent event, List allCalls, SNode it) {
        ListSequence.fromList((List)((List)Repository__BehaviorDescriptor.repoMethods_id7CiiQbKHd38.invoke(it, new Object[0]))).visitAll(method -> csvWriter.writeNext(new String[]{"repo", SModelOperations.getModelName((SModel)SNodeOperations.getModel((SNode)method)), SNodeOperations.present((SNode)SNodeOperations.getContainingRoot((SNode)method)), this.methodInfo((SNode)method, event), "" + ListSequence.fromList((List)SNodeOperations.getNodeDescendants((SNode)method, null, (boolean)false, (SAbstractConcept[])new SAbstractConcept[0])).count(), this.tos(this.privatUsageMeth(allCalls, (SNode)method, event), event), this.tos(ListSequence.fromList(this.protectedUsageMeth(allCalls, (SNode)method, event)).count(), event), this.tos(ListSequence.fromList(this.publicUsageMeth(allCalls, (SNode)method, event)).count(), event), this.tos(this.methodForeignOpCalls((SNode)method, event), event), this.tos(ListSequence.fromList(this.inCmdUsageMeth(allCalls, (SNode)method, event)).count(), event), this.tos(ListSequence.fromList(this.inTestUsageMeth(allCalls, (SNode)method, event)).count(), event)}));
    }

    private /* synthetic */ void lambda$doExecute$5(CSVWriter csvWriter, AnActionEvent event, List allCalls, SNode it) {
        Sequence.fromIterable((Iterable)((Iterable)Service__BehaviorDescriptor.servicesMethods_id6RAFKVNrPUM.invoke(it, new Object[0]))).visitAll(method -> csvWriter.writeNext(new String[]{"srv", SModelOperations.getModelName((SModel)SNodeOperations.getModel((SNode)method)), SNodeOperations.present((SNode)SNodeOperations.getContainingRoot((SNode)method)), this.methodInfo((SNode)method, event), "" + ListSequence.fromList((List)SNodeOperations.getNodeDescendants((SNode)method, null, (boolean)false, (SAbstractConcept[])new SAbstractConcept[0])).count(), this.tos(this.privatUsageMeth(allCalls, (SNode)method, event), event), this.tos(ListSequence.fromList(this.protectedUsageMeth(allCalls, (SNode)method, event)).count(), event), this.tos(ListSequence.fromList(this.publicUsageMeth(allCalls, (SNode)method, event)).count(), event), this.tos(this.methodForeignOpCalls((SNode)method, event), event), this.tos(ListSequence.fromList(this.inCmdUsageMeth(allCalls, (SNode)method, event)).count(), event), this.tos(ListSequence.fromList(this.inTestUsageMeth(allCalls, (SNode)method, event)).count(), event)}));
    }

    private /* synthetic */ void lambda$doExecute$3(CSVWriter csvWriter, List allCalls, AnActionEvent event, SNode repo) {
        csvWriter.writeNext(new String[]{"repo", SModelOperations.getModelName((SModel)SNodeOperations.getModel((SNode)repo)), SPropertyOperations.getString((SNode)repo, (SProperty)PROPS.name$MnvL), "" + ListSequence.fromList((List)SNodeOperations.getNodeDescendants((SNode)repo, null, (boolean)false, (SAbstractConcept[])new SAbstractConcept[0])).count(), "" + ListSequence.fromList((List)((List)Repository__BehaviorDescriptor.repoMethods_id7CiiQbKHd38.invoke(repo, new Object[0]))).count(), this.tos(this.privatUsageCmpt(allCalls, repo, event), event), this.tos(ListSequence.fromList(this.protectedUsageCmpt(allCalls, repo, event)).count(), event), this.tos(ListSequence.fromList(this.publicUsageCmpt(allCalls, repo, event)).count(), event), this.tos(ListSequence.fromList(this.inCmdUsageCmpt(allCalls, repo, event)).count(), event), this.tos(ListSequence.fromList(this.inTestUsageCmpt(allCalls, repo, event)).count(), event)});
    }

    private /* synthetic */ void lambda$doExecute$2(CSVWriter csvWriter, List allCalls, AnActionEvent event, SNode service) {
        csvWriter.writeNext(new String[]{"srv", SModelOperations.getModelName((SModel)SNodeOperations.getModel((SNode)service)), SPropertyOperations.getString((SNode)service, (SProperty)PROPS.name$MnvL), "" + ListSequence.fromList((List)SNodeOperations.getNodeDescendants((SNode)service, null, (boolean)false, (SAbstractConcept[])new SAbstractConcept[0])).count(), "" + Sequence.fromIterable((Iterable)((Iterable)Service__BehaviorDescriptor.servicesMethods_id6RAFKVNrPUM.invoke(service, new Object[0]))).count(), this.tos(this.privatUsageCmpt(allCalls, service, event), event), this.tos(ListSequence.fromList(this.protectedUsageCmpt(allCalls, service, event)).count(), event), this.tos(ListSequence.fromList(this.publicUsageCmpt(allCalls, service, event)).count(), event), this.tos(ListSequence.fromList(this.inCmdUsageCmpt(allCalls, service, event)).count(), event), this.tos(ListSequence.fromList(this.inTestUsageCmpt(allCalls, service, event)).count(), event)});
    }

    private static final class CONCEPTS {
        static final SConcept Command$nA = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)7192042020163999178L, (String)"org.modellwerkstatt.objectflow.structure.Command");
        static final SConcept Repository$WM = MetaAdapterFactory.getConcept((long)6533198583024797571L, (long)-5622828788674067564L, (long)4421815423107469587L, (String)"org.modellwerkstatt.manmap.structure.Repository");
        static final SConcept Service$HK = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4517030675489743647L, (String)"org.modellwerkstatt.objectflow.structure.Service");
        static final SConcept OperationCall$7H = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)7926373352206300571L, (String)"org.modellwerkstatt.objectflow.structure.OperationCall");
        static final SInterfaceConcept IOFXObject$Y7 = MetaAdapterFactory.getInterfaceConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4313579457188683399L, (String)"org.modellwerkstatt.objectflow.structure.IOFXObject");
        static final SConcept InstanceMethodCallOperation$uu = MetaAdapterFactory.getConcept((long)-935030926396207931L, (long)-6610165693999523818L, (long)1202948039474L, (String)"jetbrains.mps.baseLanguage.structure.InstanceMethodCallOperation");
        static final SConcept Entity$WP = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)1372017518093514468L, (String)"org.modellwerkstatt.objectflow.structure.Entity");
        static final SConcept ValueObject$bz = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)8009046666042261418L, (String)"org.modellwerkstatt.objectflow.structure.ValueObject");
        static final SConcept DTO$UE = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)5225022991485184063L, (String)"org.modellwerkstatt.objectflow.structure.DTO");
        static final SConcept UxRoot$gH = MetaAdapterFactory.getConcept((long)7254672812249400821L, (long)-9017496836359438957L, (long)8798915378417756405L, (String)"org.modellwerkstatt.dataux.structure.UxRoot");
        static final SConcept OFXTestMethod$cv = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)6952410984685067935L, (String)"org.modellwerkstatt.objectflow.structure.OFXTestMethod");
        static final SConcept AppUiModule$oo = MetaAdapterFactory.getConcept((long)7254672812249400821L, (long)-9017496836359438957L, (long)7784207101901652180L, (String)"org.modellwerkstatt.dataux.structure.AppUiModule");
        static final SConcept BatchJobModule$QP = MetaAdapterFactory.getConcept((long)7254672812249400821L, (long)-9017496836359438957L, (long)3226612376919648489L, (String)"org.modellwerkstatt.dataux.structure.BatchJobModule");
        static final SConcept ClassConcept$bK = MetaAdapterFactory.getConcept((long)-935030926396207931L, (long)-6610165693999523818L, (long)1068390468198L, (String)"jetbrains.mps.baseLanguage.structure.ClassConcept");
        static final SConcept Word$Dn = MetaAdapterFactory.getConcept((long)-4036523103261015289L, (long)-8525114440436176696L, (long)155656958578482948L, (String)"jetbrains.mps.lang.text.structure.Word");
        static final SConcept Line$yC = MetaAdapterFactory.getConcept((long)-4036523103261015289L, (long)-8525114440436176696L, (long)2535923850359271782L, (String)"jetbrains.mps.lang.text.structure.Line");
        static final SConcept AnnotationInstance$yl = MetaAdapterFactory.getConcept((long)-935030926396207931L, (long)-6610165693999523818L, (long)1188207840427L, (String)"jetbrains.mps.baseLanguage.structure.AnnotationInstance");
        static final SConcept LocalMethodCall$zT = MetaAdapterFactory.getConcept((long)-935030926396207931L, (long)-6610165693999523818L, (long)7812454656619025412L, (String)"jetbrains.mps.baseLanguage.structure.LocalMethodCall");
        static final SConcept OFXTestSuit$Iy = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)1335996842166371514L, (String)"org.modellwerkstatt.objectflow.structure.OFXTestSuit");

        private CONCEPTS() {
        }
    }

    private static final class LINKS {
        static final SContainmentLink elements$_j45 = MetaAdapterFactory.getContainmentLink((long)-4036523103261015289L, (long)-8525114440436176696L, (long)2535923850359271782L, (long)2535923850359271783L, (String)"elements");
        static final SReferenceLink annotation$12Ek = MetaAdapterFactory.getReferenceLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1188207840427L, (long)1188208074048L, (String)"annotation");
        static final SReferenceLink runtimeHandledObject$2jLr = MetaAdapterFactory.getReferenceLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)7926373352206300571L, (long)7926373352206300596L, (String)"runtimeHandledObject");
        static final SReferenceLink baseMethodDeclaration$pyYw = MetaAdapterFactory.getReferenceLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1204053956946L, (long)1068499141037L, (String)"baseMethodDeclaration");
        static final SContainmentLink returnType$5xoi = MetaAdapterFactory.getContainmentLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1068580123132L, (long)1068580123133L, (String)"returnType");
        static final SContainmentLink parameter$5xBj = MetaAdapterFactory.getContainmentLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1068580123132L, (long)1068580123134L, (String)"parameter");
        static final SContainmentLink type$a1UY = MetaAdapterFactory.getContainmentLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)4972933694980447171L, (long)5680397130376446158L, (String)"type");

        private LINKS() {
        }
    }

    private static final class PROPS {
        static final SProperty name$MnvL = MetaAdapterFactory.getProperty((long)-3554657779850784990L, (long)-7236703803128771572L, (long)1169194658468L, (long)1169194664001L, (String)"name");
        static final SProperty value$zQr_ = MetaAdapterFactory.getProperty((long)-4036523103261015289L, (long)-8525114440436176696L, (long)155656958578482948L, (long)155656958578482949L, (String)"value");

        private PROPS() {
        }
    }
}

