/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.javaxbus;

import mjson.Json;
import org.modellwerkstatt.javaxbus.ConsumerHandler;
import org.modellwerkstatt.javaxbus.ErrorHandler;
import org.modellwerkstatt.javaxbus.EventBusRunnable;

public class EventBus {
    public static final String VERSION = "1.0";
    public static final boolean USE_NIO = true;
    private Thread communicatorThread;
    private EventBusRunnable com;

    public void consumer(String address, ConsumerHandler handler) {
        if (this.com == null) {
            throw new IllegalStateException("Eventbus not initialized.");
        }
        this.com.registerHander(address, handler, true);
    }

    public void unregisgterConsumer(String address, ConsumerHandler handler) {
        if (this.com == null) {
            throw new IllegalStateException("Eventbus not initialized.");
        }
        this.com.unRegisterHander(address, handler);
    }

    public void addErrorHandler(ErrorHandler handler) {
        if (this.com == null) {
            throw new IllegalStateException("Eventbus not initialized.");
        }
        this.com.addErrorHandler(handler);
    }

    public void removeErrorHandler(ErrorHandler handler) {
        if (this.com == null) {
            throw new IllegalStateException("Eventbus not initialized.");
        }
        this.com.addErrorHandler(handler);
    }

    public void send(String adr, Json content) {
        if (this.com == null) {
            throw new IllegalStateException("Eventbus not initialized.");
        }
        this.com.sendToStream(false, adr, content, null);
    }

    public void send(String adr, Json content, ConsumerHandler replyHandler) {
        if (this.com == null) {
            throw new IllegalStateException("Eventbus not initialized.");
        }
        this.com.sendToStream(false, adr, content, replyHandler);
    }

    public void publish(String adr, Json content) {
        if (this.com == null) {
            throw new IllegalStateException("Eventbus not initialized.");
        }
        this.com.sendToStream(true, adr, content, null);
    }

    public boolean isConnected() {
        if (this.com == null) {
            return false;
        }
        return this.com.isConnected();
    }

    public boolean isUpAndRunning() {
        if (this.com == null) {
            return false;
        }
        return this.com.isUpNRunning();
    }

    public boolean testReconnect() {
        this.com.tryReconnect();
        return true;
    }

    public void close() {
        if (this.com == null) {
            throw new IllegalStateException("Eventbus not initialized.");
        }
        this.com.shutdown();
        this.communicatorThread.interrupt();
        this.com.closeCon();
        this.communicatorThread = null;
        this.com = null;
    }

    public void setUnderTestingMode() {
        if (this.com == null) {
            throw new IllegalStateException("Eventbus not initialized.");
        }
        this.com.setUnderTest();
    }

    private void init(String hostname, int port) {
        this.com = new EventBusRunnable();
        this.com.init(hostname, port);
        this.communicatorThread = new Thread(this.com);
        this.communicatorThread.setName("VertX EventBus Recv.");
        this.communicatorThread.setDaemon(true);
        this.communicatorThread.start();
    }

    public static EventBus create(String hostname, int port) {
        EventBus bus = new EventBus();
        bus.init(hostname, port);
        return bus;
    }
}

