/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.javaxbus;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mjson.Json;
import org.modellwerkstatt.javaxbus.ConsumerHandler;
import org.modellwerkstatt.javaxbus.ErrorHandler;
import org.modellwerkstatt.javaxbus.IOSocketService;
import org.modellwerkstatt.javaxbus.Message;
import org.modellwerkstatt.javaxbus.NonBlockingIO;
import org.modellwerkstatt.javaxbus.VertXProtoMJson;

public class EventBusRunnable
implements Runnable {
    public static final int RECON_TIMEOUT = 10000;
    public static final int FAST_RECON_TIMEOUT = 500;
    public static final String TEMP_HANDLER_SIGNATURE = "__MODWERK_HC__";
    private String hostname;
    private int port;
    private IOSocketService io = null;
    private volatile boolean upNRunning = false;
    private volatile boolean stillConnected = false;
    private VertXProtoMJson proto = new VertXProtoMJson();
    private HashMap<String, List<ConsumerHandler>> consumerHandlers = new HashMap();
    private List<ErrorHandler> errorHandler = new ArrayList<ErrorHandler>();
    private boolean underTest = false;

    public void sendToStream(boolean publish, String adr, Json msg, ConsumerHandler replyHandler) {
        try {
            String replyAdr = null;
            if (replyHandler != null) {
                replyAdr = adr + TEMP_HANDLER_SIGNATURE + replyHandler.hashCode();
                this.registerHander(replyAdr, replyHandler, false);
            }
            if (publish) {
                this.io.writeToStream(this.proto.publish(adr, msg, replyAdr));
            } else {
                this.io.writeToStream(this.proto.send(adr, msg, replyAdr));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHander(String adr, ConsumerHandler handler, boolean registerWithServer) {
        EventBusRunnable eventBusRunnable = this;
        synchronized (eventBusRunnable) {
            try {
                if (!this.consumerHandlers.containsKey(adr)) {
                    this.consumerHandlers.put(adr, new ArrayList());
                }
                List<ConsumerHandler> listOfHandlers = this.consumerHandlers.get(adr);
                listOfHandlers.add(handler);
                if (listOfHandlers.size() == 1 && registerWithServer) {
                    this.io.writeToStream(this.proto.register(adr));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterHander(String adr, ConsumerHandler handler) {
        EventBusRunnable eventBusRunnable = this;
        synchronized (eventBusRunnable) {
            try {
                if (!this.consumerHandlers.containsKey(adr)) {
                    throw new IllegalStateException("No handlers registered for adr " + adr);
                }
                List<ConsumerHandler> existingHandlers = this.consumerHandlers.get(adr);
                if (!existingHandlers.contains(handler)) {
                    throw new IllegalStateException("Handler not registered for adr " + adr);
                }
                existingHandlers.remove(handler);
                if (existingHandlers.size() == 0) {
                    this.io.writeToStream(this.proto.unregister(adr));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorHandler(ErrorHandler handler) {
        EventBusRunnable eventBusRunnable = this;
        synchronized (eventBusRunnable) {
            if (this.errorHandler.contains(handler)) {
                throw new IllegalStateException("You should not register this handler twice.");
            }
            this.errorHandler.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorHandler(ErrorHandler handler) {
        EventBusRunnable eventBusRunnable = this;
        synchronized (eventBusRunnable) {
            if (!this.errorHandler.contains(handler)) {
                throw new IllegalStateException("The given handler was never registered.....");
            }
            this.errorHandler.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMessage(String adr, Message msg) {
        EventBusRunnable eventBusRunnable = this;
        synchronized (eventBusRunnable) {
            if (!this.consumerHandlers.containsKey(adr)) {
                throw new IllegalStateException("No handlers registered for " + adr + " but msg " + msg.toString() + " received.");
            }
            List<ConsumerHandler> handlers = this.consumerHandlers.get(adr);
            for (ConsumerHandler h : handlers) {
                h.handle(msg);
            }
            if (adr.contains(TEMP_HANDLER_SIGNATURE)) {
                this.consumerHandlers.get(adr).clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchErrorFromBus(Message msg) {
        EventBusRunnable eventBusRunnable = this;
        synchronized (eventBusRunnable) {
            if (this.errorHandler.size() == 0) {
                if (!("unknown_address".equals(msg.getErrMessage()) && "".equals(msg.getErrFailureCode()) && "".equals(msg.getErrFailureType()))) {
                    System.err.println("EventBusRunnable.dispatchErrorFromBus(): no errorHandlers registered, but received msg:" + msg.toString());
                }
            } else {
                for (ErrorHandler e : this.errorHandler) {
                    e.handleMsgFromBus(this.stillConnected, this.upNRunning, msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchException(Exception exception) {
        EventBusRunnable eventBusRunnable = this;
        synchronized (eventBusRunnable) {
            if (this.errorHandler.size() == 0) {
                exception.printStackTrace();
            } else {
                for (ErrorHandler e : this.errorHandler) {
                    e.handleException(this.stillConnected, this.upNRunning, exception);
                }
            }
        }
    }

    @Override
    public void run() {
        this.upNRunning = true;
        while (!Thread.interrupted() && this.upNRunning) {
            try {
                if (this.stillConnected) {
                    Message msgToSend;
                    Json msg = this.io.readFormStream();
                    String msgType = msg.at("type").asString();
                    if ("pong".equals(msgType)) continue;
                    if ("message".equals(msgType)) {
                        if (!this.upNRunning) continue;
                        msgToSend = this.proto.prepareMessageToDeliver(msgType, msg);
                        this.dispatchMessage(msgToSend.getAddress(), msgToSend);
                        continue;
                    }
                    if (!"err".equals(msgType)) continue;
                    if (this.upNRunning && msg.has("address")) {
                        msgToSend = this.proto.prepareMessageToDeliver(msgType, msg);
                        this.dispatchMessage(msgToSend.getAddress(), msgToSend);
                        continue;
                    }
                    msgToSend = this.proto.prepareMessageToDeliver(msgType, msg);
                    this.dispatchErrorFromBus(msgToSend);
                    continue;
                }
                this.tryReconnect();
            }
            catch (SocketException e) {
                this.stillConnected = false;
                if (!this.upNRunning) continue;
                this.dispatchException(e);
            }
            catch (ClosedByInterruptException e) {
                this.stillConnected = false;
                if (!this.upNRunning) continue;
                this.dispatchException(e);
            }
            catch (ClosedChannelException e) {
                this.stillConnected = false;
                if (!this.upNRunning) continue;
                this.dispatchException(e);
            }
            catch (EOFException e) {
                this.stillConnected = false;
                this.dispatchException(e);
            }
            catch (IOException e) {
                this.stillConnected = false;
                this.dispatchException(e);
            }
            catch (Exception e) {
                this.stillConnected = false;
                this.dispatchException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryReconnect() {
        block12: {
            try {
                this.closeCon();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(this.underTest ? 500L : 10000L);
                if (!this.upNRunning) break block12;
                this.initCon();
                EventBusRunnable eventBusRunnable = this;
                synchronized (eventBusRunnable) {
                    for (String adr : this.consumerHandlers.keySet()) {
                        this.io.writeToStream(this.proto.register(adr));
                    }
                }
            }
            catch (IOException e) {
                this.stillConnected = false;
                this.dispatchException(e);
            }
            catch (RuntimeException e) {
                if (e.getCause() == null || !e.getCause().getClass().equals(ConnectException.class)) {
                    this.stillConnected = false;
                    this.dispatchException(e);
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                this.stillConnected = false;
                this.dispatchException(e);
            }
        }
    }

    public boolean isUpNRunning() {
        return this.upNRunning;
    }

    public boolean isConnected() {
        return this.stillConnected;
    }

    public void init(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.initCon();
    }

    private void initCon() {
        try {
            this.io = new NonBlockingIO();
            this.io.init(this.hostname, this.port);
            this.io.writeToStream(this.proto.ping());
            this.stillConnected = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setUnderTest() {
        this.underTest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        EventBusRunnable eventBusRunnable = this;
        synchronized (eventBusRunnable) {
            try {
                this.upNRunning = false;
                if (this.stillConnected) {
                    for (String adr : this.consumerHandlers.keySet()) {
                        if (!adr.contains(TEMP_HANDLER_SIGNATURE)) {
                            this.io.writeToStream(this.proto.unregister(adr));
                        }
                        this.consumerHandlers.get(adr).clear();
                    }
                }
                this.consumerHandlers.clear();
                this.errorHandler.clear();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCon() {
        EventBusRunnable eventBusRunnable = this;
        synchronized (eventBusRunnable) {
            try {
                if (this.stillConnected) {
                    this.stillConnected = false;
                    this.io.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

