/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.javaxbus;

import mjson.Json;

public class Message {
    private boolean typeError;
    private String errorMessage;
    private String errorCode;
    private String errorType;
    private boolean send;
    private Json payLoad;
    private String replyAddress;
    private String address;

    public Message(String adr, boolean sended, String reply, Json content) {
        this.typeError = false;
        this.payLoad = content;
        this.send = sended;
        this.address = adr;
        this.replyAddress = reply;
    }

    public Message(String adr, boolean sended, String reply, String message, String failCode, String failType) {
        this.typeError = true;
        this.send = sended;
        this.address = adr;
        this.replyAddress = reply;
        this.errorMessage = message;
        this.errorCode = failCode;
        this.errorType = failType;
    }

    public boolean isPublishedMsg() {
        return !this.send;
    }

    public Json getBodyAsMJson() {
        if (this.isErrorMsg()) {
            String exMsg = String.format("This is a error msg '%s' (code: %s, type %s), no body present!", this.getErrMessage(), this.getErrFailureCode(), this.getErrFailureType());
            throw new IllegalStateException(exMsg);
        }
        return this.payLoad;
    }

    public String getReplyAddress() {
        return this.replyAddress;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isErrorMsg() {
        return this.typeError;
    }

    public String getErrFailureCode() {
        if (!this.isErrorMsg()) {
            throw new IllegalStateException("This is not an error message! Msg body is " + this.getBodyAsShortString());
        }
        return this.errorCode;
    }

    public String getErrFailureType() {
        if (!this.isErrorMsg()) {
            throw new IllegalStateException("This is not an error message! Msg body is " + this.getBodyAsShortString());
        }
        return this.errorType;
    }

    public String getErrMessage() {
        if (!this.isErrorMsg()) {
            throw new IllegalStateException("This is not an error message! Msg body is " + this.getBodyAsShortString());
        }
        return this.errorMessage;
    }

    private String getBodyAsShortString() {
        return this.payLoad.toString(50);
    }

    public String toString() {
        if (this.isErrorMsg()) {
            return String.format("[ErrorMsg '%s' (code %s, type %s)]", this.getErrMessage(), this.getErrFailureCode(), this.getErrFailureType());
        }
        return "[Message " + this.payLoad + "]";
    }
}

