/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.javaxbus;

import mjson.Json;
import org.modellwerkstatt.javaxbus.Message;

public class VertXProtoMJson {
    public Json send(String adr, Json msg, String replyAddr) {
        Json json = Json.object();
        json.set("type", (Object)"send");
        json.set("address", (Object)adr);
        json.set("body", msg);
        if (replyAddr != null) {
            json.set("replyAddress", (Object)replyAddr);
        }
        return json;
    }

    public Json publish(String adr, Json msg, String replyAddr) {
        Json sendJson = this.send(adr, msg, replyAddr);
        sendJson.set("type", (Object)"publish");
        return sendJson;
    }

    public Json register(String adr) {
        Json json = Json.object();
        json.set("type", (Object)"register");
        json.set("address", (Object)adr);
        return json;
    }

    public Json unregister(String adr) {
        Json json = Json.object();
        json.set("type", (Object)"unregister");
        json.set("address", (Object)adr);
        return json;
    }

    public Json ping() {
        return Json.object().set("type", (Object)"ping");
    }

    public Message prepareMessageToDeliver(String type, Json json) {
        Message msgToDeliver;
        String reply;
        String string = reply = json.has("replyAddress") ? json.at("replyAddress").asString() : null;
        if ("message".equals(type)) {
            String address = json.at("address").asString();
            Json body = json.at("body");
            boolean sended = json.at("send").asBoolean();
            msgToDeliver = new Message(address, sended, reply, body);
        } else {
            String address = json.has("address") ? json.at("address").asString() : null;
            String failMsg = json.at("message").asString();
            String failCode = json.has("failureCode") ? json.at("failureCode").asString() : "";
            String failType = json.has("failureType") ? json.at("failureType").asString() : "";
            boolean send = json.has("send") ? json.at("send").asBoolean() : true;
            msgToDeliver = new Message(address, send, reply, failMsg, failCode, failType);
        }
        return msgToDeliver;
    }
}

