/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.fop;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.ImageAdapter;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.RendererContextConstants;
import org.apache.fop.render.XMLHandler;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.fop.VariableUtil;
import org.krysalis.barcode4j.output.BarcodeCanvasSetupException;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.output.eps.EPSCanvasProvider;
import org.krysalis.barcode4j.output.java2d.Java2DCanvasProvider;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.krysalis.barcode4j.tools.ConfigurationUtil;
import org.krysalis.barcode4j.tools.UnitConv;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class BarcodeXMLHandler
implements XMLHandler,
RendererContextConstants {
    private static final boolean DEBUG = false;
    private static final String PS_GENERATOR = "psGenerator";

    public void handleXML(RendererContext context, Document doc, String ns) throws Exception {
        Configuration cfg = ConfigurationUtil.buildConfiguration(doc);
        String msg = ConfigurationUtil.getMessage(cfg);
        String renderMode = cfg.getAttribute("render-mode", "native");
        int orientation = cfg.getAttributeAsInteger("orientation", 0);
        orientation = BarcodeDimension.normalizeOrientation(orientation);
        PageViewport page = (PageViewport)context.getProperty("pageViewport");
        BarcodeGenerator bargen = BarcodeUtil.getInstance().createBarcodeGenerator(cfg);
        String expandedMsg = VariableUtil.getExpandedMessage(page, msg);
        boolean handled = false;
        String effRenderMode = renderMode;
        if ("native".equals(renderMode)) {
            if (context.getProperty(PS_GENERATOR) != null) {
                this.renderUsingEPS(context, bargen, expandedMsg, orientation);
                effRenderMode = "native";
                handled = true;
            }
        } else if ("g2d".equals(renderMode)) {
            handled = this.renderUsingGraphics2D(context, bargen, expandedMsg, orientation);
            if (handled) {
                effRenderMode = "g2d";
            }
        } else if ("bitmap".equals(renderMode) && (handled = this.renderUsingBitmap(context, bargen, expandedMsg, orientation))) {
            effRenderMode = "bitmap";
        }
        if (!handled) {
            this.convertToSVG(context, bargen, expandedMsg, orientation);
            effRenderMode = "svg";
        }
    }

    private void renderUsingEPS(RendererContext context, BarcodeGenerator bargen, String msg, int orientation) throws IOException {
        PSGenerator gen = (PSGenerator)context.getProperty(PS_GENERATOR);
        ByteArrayOutputStream baout = new ByteArrayOutputStream(1024);
        EPSCanvasProvider canvas = new EPSCanvasProvider(baout, orientation);
        bargen.generateBarcode(canvas, msg);
        canvas.finish();
        BarcodeDimension barDim = canvas.getDimensions();
        float bw = (float)UnitConv.mm2pt(barDim.getWidthPlusQuiet(orientation));
        float bh = (float)UnitConv.mm2pt(barDim.getHeightPlusQuiet(orientation));
        float width = (float)((Integer)context.getProperty("width")).intValue() / 1000.0f;
        float height = (float)((Integer)context.getProperty("height")).intValue() / 1000.0f;
        float x = (float)((Integer)context.getProperty("xpos")).intValue() / 1000.0f;
        float y = (float)((Integer)context.getProperty("ypos")).intValue() / 1000.0f;
        PSImageUtils.renderEPS((InputStream)new ByteArrayInputStream(baout.toByteArray()), (String)("Barcode:" + msg), (Rectangle2D)new Rectangle2D.Float(x, y, width, height), (Rectangle2D)new Rectangle2D.Float(0.0f, 0.0f, bw, bh), (PSGenerator)gen);
    }

    private boolean renderUsingGraphics2D(RendererContext context, final BarcodeGenerator bargen, final String msg, final int orientation) throws IOException {
        Graphics2DAdapter g2dAdapter = context.getRenderer().getGraphics2DAdapter();
        if (g2dAdapter != null) {
            final BarcodeDimension barDim = bargen.calcDimensions(msg);
            final int w = (int)Math.ceil(UnitConv.mm2pt(barDim.getWidthPlusQuiet())) * 1000;
            final int h = (int)Math.ceil(UnitConv.mm2pt(barDim.getHeightPlusQuiet())) * 1000;
            Graphics2DImagePainter painter = new Graphics2DImagePainter(){

                public void paint(Graphics2D g2d, Rectangle2D area) {
                    Java2DCanvasProvider canvas = new Java2DCanvasProvider(null, orientation);
                    canvas.setGraphics2D(g2d);
                    g2d.scale(area.getWidth() / barDim.getWidthPlusQuiet(), area.getHeight() / barDim.getHeightPlusQuiet());
                    bargen.generateBarcode(canvas, msg);
                }

                public Dimension getImageSize() {
                    return new Dimension(w, h);
                }
            };
            g2dAdapter.paintImage(painter, context, ((Integer)context.getProperty("xpos")).intValue(), ((Integer)context.getProperty("ypos")).intValue(), ((Integer)context.getProperty("width")).intValue(), ((Integer)context.getProperty("height")).intValue());
            return true;
        }
        return false;
    }

    private boolean renderUsingBitmap(RendererContext context, BarcodeGenerator bargen, String msg, int orientation) throws IOException {
        ImageAdapter imgAdapter = context.getRenderer().getImageAdapter();
        if (imgAdapter != null) {
            BitmapCanvasProvider canvas = new BitmapCanvasProvider(300, 12, false, orientation);
            bargen.generateBarcode(canvas, msg);
            imgAdapter.paintImage((RenderedImage)canvas.getBufferedImage(), context, ((Integer)context.getProperty("xpos")).intValue(), ((Integer)context.getProperty("ypos")).intValue(), ((Integer)context.getProperty("width")).intValue(), ((Integer)context.getProperty("height")).intValue());
            return true;
        }
        return false;
    }

    private void convertToSVG(RendererContext context, BarcodeGenerator bargen, String msg, int orientation) throws BarcodeCanvasSetupException {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        SVGCanvasProvider canvas = new SVGCanvasProvider(impl, true, orientation);
        bargen.generateBarcode(canvas, msg);
        Document svg = canvas.getDOM();
        context.getRenderer().renderXML(context, svg, "http://www.w3.org/2000/svg");
    }

    public String getMimeType() {
        return "*";
    }

    public String getNamespace() {
        return "http://barcode4j.krysalis.org/ns";
    }

    public boolean supportsRenderer(Renderer renderer) {
        return renderer.getGraphics2DAdapter() != null;
    }
}

