/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.smodel.action.SNodeFactoryOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.workbench.action.ActionAccess;
import jetbrains.mps.workbench.action.BaseAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.mps.openapi.model.SNode;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import org.modellwerkstatt.objectflow.util.SQLDescTableParser;

public class DbDescribeToDTO_Action
extends BaseAction {
    private static final Icon ICON = null;

    public DbDescribeToDTO_Action() {
        super("Werkbank - Create DTO / NoKeyMapper from DESC", "DTO from SQL desc table", ICON);
        this.setIsAlwaysVisible(true);
        this.setActionAccess((ActionAccess)ActionAccess.UNDO_PROJECT);
        this.updateInBackground(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean collectActionData(AnActionEvent event, Map<String, Object> _params) {
        if (!super.collectActionData(event, _params)) {
            return false;
        }
        Frame p = (Frame)event.getData(MPSCommonDataKeys.FRAME);
        if (p == null) {
            return false;
        }
        p = (MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT);
        if (p == null) {
            return false;
        }
        SNode sNode = (SNode)event.getData(MPSCommonDataKeys.NODE);
        return true;
    }

    public void doExecute(@NotNull AnActionEvent event, Map<String, Object> _params) {
        SNode modelRepository = (SNode)event.getData(MPSCommonDataKeys.NODE);
        if (modelRepository == null || !SNodeOperations.isInstanceOf((SNode)modelRepository, (SAbstractConcept)CONCEPTS.Repository$WM)) {
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), "Selected a Respository where NoKeyMapper should be put in . . .", "Wrong selection in project explorer", 0);
            return;
        }
        CopyPasteDialog dialog = new CopyPasteDialog((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), "Paste SQL here...");
        dialog.showDialog();
        SModel mod = SNodeOperations.getModel((SNode)modelRepository);
        if (dialog.isOkay()) {
            String content = dialog.myText.getText().toString();
            SNode createdViewObject = SNodeFactoryOperations.createNewRootNode((SModel)mod, (SAbstractConcept)CONCEPTS.DTO$UE, null);
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)createdViewObject, (SContainmentLink)LINKS.businessProperties$cI4J)).clear();
            SNode noKeyMapper = SNodeFactoryOperations.addNewChild((SNode)SNodeOperations.cast((SNode)modelRepository, (SAbstractConcept)CONCEPTS.Repository$WM), (SContainmentLink)LINKS.member$L_2d, (SAbstractConcept)CONCEPTS.NoKeyMapperField$_P);
            try {
                SQLDescTableParser parser = new SQLDescTableParser(content);
                parser.parse(createdViewObject, noKeyMapper);
            }
            catch (Exception e) {
                e.printStackTrace();
                SNodeOperations.deleteNode((SNode)createdViewObject);
                SNodeOperations.deleteNode((SNode)noKeyMapper);
                JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), e.getMessage(), "Problem while parsing ... ", 0);
            }
        }
    }

    private static final class CONCEPTS {
        static final SConcept Repository$WM = MetaAdapterFactory.getConcept((long)6533198583024797571L, (long)-5622828788674067564L, (long)4421815423107469587L, (String)"org.modellwerkstatt.manmap.structure.Repository");
        static final SConcept DTO$UE = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)5225022991485184063L, (String)"org.modellwerkstatt.objectflow.structure.DTO");
        static final SConcept NoKeyMapperField$_P = MetaAdapterFactory.getConcept((long)6533198583024797571L, (long)-5622828788674067564L, (long)781751828139414632L, (String)"org.modellwerkstatt.manmap.structure.NoKeyMapperField");

        private CONCEPTS() {
        }
    }

    private static final class LINKS {
        static final SContainmentLink businessProperties$cI4J = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4313579457188683399L, (long)3207218222495905601L, (String)"businessProperties");
        static final SContainmentLink member$L_2d = MetaAdapterFactory.getContainmentLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1107461130800L, (long)5375687026011219971L, (String)"member");

        private LINKS() {
        }
    }
}

