/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.plugin;

import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jetbrains.mps.ide.datatransfer.TextPasteUtil;
import jetbrains.mps.project.MPSProject;

public class JSONImportDialog
extends DialogBuilder {
    private JComponent myComponent = this.createPanel();
    public JTextArea myText;
    public JTextField dateTimeFormat;
    public JTextField localDateFormat;
    public JTextField bigDeciFormat;
    public JCheckBox allEncompassing;
    private boolean isOkayButton = false;

    public JSONImportDialog(MPSProject project, String title) {
        super(project.getProject());
        this.setCenterPanel(this.myComponent);
        this.myComponent.setMinimumSize(new Dimension(800, 600));
        this.setTitle(title);
    }

    public JSONImportDialog(MPSProject project, String title, String text) {
        super(project.getProject());
        this.setCenterPanel(this.myComponent);
        this.myText.setText(text);
        this.setTitle(title);
    }

    protected JComponent getMainComponent() {
        return this.myComponent;
    }

    public JComponent createPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)new JLabel("Paste your data here:"), "North");
        this.myText = new JTextArea("");
        String str = TextPasteUtil.getStringFromClipboard();
        if (str != null) {
            this.myText.setText(str);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myText);
        scrollPane.getVerticalScrollBar().setBlockIncrement(40);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        scrollPane.getHorizontalScrollBar().setBlockIncrement(40);
        mainPanel.add((Component)scrollPane, "Center");
        JPanel optionsPanel = new JPanel(new GridLayout(4, 2));
        optionsPanel.add(new JLabel("DateTime Format"));
        this.dateTimeFormat = new JTextField("dd.MM.yyyy hh:mm:ss");
        optionsPanel.add(this.dateTimeFormat);
        optionsPanel.add(new JLabel("LocalDate Format"));
        this.localDateFormat = new JTextField("dd.MM.yy");
        optionsPanel.add(this.localDateFormat);
        optionsPanel.add(new JLabel("BigDecimal Format"));
        this.bigDeciFormat = new JTextField("#,##0.00");
        optionsPanel.add(this.bigDeciFormat);
        optionsPanel.add(new JLabel("Build max encompassing obj."));
        this.allEncompassing = new JCheckBox();
        this.allEncompassing.setSelected(false);
        optionsPanel.add(this.allEncompassing);
        mainPanel.add((Component)optionsPanel, "South");
        return mainPanel;
    }

    public boolean isOkay() {
        return this.isOkayButton;
    }

    public void showDialog() {
        this.isOkayButton = super.showAndGet();
    }
}

