/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.util;

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SConceptOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.smodel.builder.SNodeBuilder;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SLanguage;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.model.SNode;
import org.modellwerkstatt.manmap.conventions.ImpExpNameHelper;
import org.modellwerkstatt.objectflow.behavior.IOFXObject__BehaviorDescriptor;

public class SQLDescTableParser {
    private String lineText;
    private int currentPosition;

    public SQLDescTableParser(String text) {
        this.lineText = text == null ? null : text.trim();
        this.currentPosition = 0;
        this.lineText = this.lineText.replace(";", "\n");
        this.lineText = this.lineText.replace("\r", "\n");
        this.lineText = this.lineText.replace("\n\n", "\n");
        this.lineText = this.lineText.replace("\n\n\n", "\n");
        this.lineText = this.lineText.replace("NOT NULL", "NOT_NULL");
    }

    public void eatSpace(boolean withNewLine) {
        while (this.currentPosition < this.lineText.length() && (this.lineText.charAt(this.currentPosition) == ' ' || withNewLine && this.lineText.charAt(this.currentPosition) == '\n')) {
            ++this.currentPosition;
        }
    }

    public Token nextToken() {
        char curChar;
        Token newToken = new Token();
        this.eatSpace(true);
        if (this.currentPosition >= this.lineText.length()) {
            return null;
        }
        int i = this.currentPosition;
        while (i < this.lineText.length() && (curChar = this.lineText.charAt(i)) != ' ' && curChar != '\n' && curChar != '(') {
            if (curChar == ')') {
                throw new RuntimeException("Missing the opening parenthesis '(' after processing \n\n" + this.lineText.substring(0, this.currentPosition));
            }
            newToken.id = newToken.id + curChar;
            ++i;
            ++this.currentPosition;
        }
        this.eatSpace(false);
        if (this.currentPosition < this.lineText.length() && this.lineText.charAt(this.currentPosition) == '(') {
            newToken.hasParentInfo = true;
            ++this.currentPosition;
            i = this.currentPosition;
            while (i < this.lineText.length() && (curChar = this.lineText.charAt(i)) != ')' && curChar != '\n') {
                newToken.parenthesisInfo = newToken.parenthesisInfo + curChar;
                ++i;
                ++this.currentPosition;
            }
            if (this.lineText.charAt(this.currentPosition) != ')') {
                throw new RuntimeException("Missing the closing parenthesis ')' after processing \n\n" + this.lineText.substring(0, this.currentPosition));
            }
            ++this.currentPosition;
        }
        if ("".equals(newToken.id)) {
            throw new RuntimeException("Token id equals empty string after processing \n\n" + this.lineText.substring(0, this.currentPosition));
        }
        return newToken;
    }

    public SNode getTypeFor(String typeString) {
        boolean decimalSuspicious = false;
        if (typeString.indexOf("(") >= 0) {
            if (typeString.indexOf(",") > typeString.indexOf("(")) {
                decimalSuspicious = true;
            }
            typeString = typeString.substring(0, typeString.indexOf("("));
        }
        typeString = typeString.toLowerCase().trim();
        return null;
    }

    public void parse(SNode theObject, SNode mapping) {
        Token tok = this.nextToken();
        if (tok == null || !tok.id.toLowerCase().equals("desc")) {
            throw new RuntimeException("Given description does not start with 'desc' keyWord followed by table name.");
        }
        tok = this.nextToken();
        if (tok == null) {
            throw new RuntimeException("Given description does not start with 'desc' keyWord followed by table name. Table name missing");
        }
        System.out.println("Table Name: " + tok.id);
        if (SNodeOperations.isInstanceOf((SNode)mapping, (SAbstractConcept)CONCEPTS.EntityMapping$ux)) {
            SNode em = SNodeOperations.cast((SNode)mapping, (SAbstractConcept)CONCEPTS.EntityMapping$ux);
            SPropertyOperations.assign((SNode)SNodeOperations.cast((SNode)theObject, (SAbstractConcept)CONCEPTS.Entity$WP), (SProperty)PROPS.name$MnvL, (String)ImpExpNameHelper.dbIdToJavaId((String)tok.id, (boolean)true));
            SPropertyOperations.assign((SNode)em, (SProperty)PROPS.name$MnvL, (String)("Map" + (String)IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(theObject, new Object[0])));
            SLinkOperations.setTarget((SNode)em, (SContainmentLink)LINKS.tableName$PpjQ, (SNode)SQLDescTableParser._quotation_createNode_qg6e6v_a0e0k0r());
            SPropertyOperations.assign((SNode)SLinkOperations.getTarget((SNode)em, (SContainmentLink)LINKS.tableName$PpjQ), (SProperty)PROPS.value$w7MM, (String)tok.id);
            SLinkOperations.setTarget((SNode)em, (SReferenceLink)LINKS.classConcept$r5Kr, (SNode)SNodeOperations.cast((SNode)theObject, (SAbstractConcept)CONCEPTS.Entity$WP));
        } else if (SNodeOperations.isInstanceOf((SNode)mapping, (SAbstractConcept)CONCEPTS.NoKeyMapperField$_P)) {
            SNode nkmf = SNodeOperations.cast((SNode)mapping, (SAbstractConcept)CONCEPTS.NoKeyMapperField$_P);
            SPropertyOperations.assign((SNode)SNodeOperations.cast((SNode)theObject, (SAbstractConcept)CONCEPTS.DTO$UE), (SProperty)PROPS.name$MnvL, (String)ImpExpNameHelper.dbIdToJavaId((String)tok.id, (boolean)true));
            SPropertyOperations.assign((SNode)nkmf, (SProperty)PROPS.name$MnvL, (String)("map" + (String)IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(theObject, new Object[0])));
            SLinkOperations.setTarget((SNode)nkmf, (SReferenceLink)LINKS.classConcept$G7ah, (SNode)SNodeOperations.cast((SNode)theObject, (SAbstractConcept)CONCEPTS.DTO$UE));
        }
        tok = this.nextToken();
        tok = this.nextToken();
        tok = this.nextToken();
        tok = this.nextToken();
        tok = this.nextToken();
        tok = this.nextToken();
        tok = this.nextToken();
        while (tok != null) {
            String fieldName = tok.id;
            if (tok.hasParentInfo) {
                throw new RuntimeException("Parenthesis info given for field name? Not parsable " + tok.id + " / " + tok.parenthesisInfo);
            }
            System.err.println("Field Name: " + tok.id);
            tok = this.nextToken();
            if ("NOT_NULL".equals(tok.id)) {
                tok = this.nextToken();
                System.err.println("       NOT_NULL given");
            }
            if (tok == null) {
                throw new RuntimeException("Unexpected end of description, expecting a type for field " + fieldName);
            }
            SNode newProp = SConceptOperations.createNewNode((SConcept)MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)8396343267227475961L, (String)"org.modellwerkstatt.objectflow.structure.BusinessProperty"));
            SPropertyOperations.assign((SNode)newProp, (SProperty)PROPS.propertyName$DLW4, (String)ImpExpNameHelper.dbIdToJavaId((String)fieldName, (boolean)false));
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)theObject, (SContainmentLink)LINKS.businessProperties$cI4J)).addElement((Object)newProp);
            String type = tok.id.toLowerCase();
            if (type.equals("varchar2") || type.equals("varchar")) {
                SLinkOperations.setTarget((SNode)newProp, (SContainmentLink)LINKS.type$56v0, (SNode)SQLDescTableParser._quotation_createNode_qg6e6v_a0a0q0db0r());
            } else if (type.equals("date")) {
                SLinkOperations.setTarget((SNode)newProp, (SContainmentLink)LINKS.type$56v0, (SNode)SQLDescTableParser._quotation_createNode_qg6e6v_a0a0a61a92a71());
            } else if (type.equals("number")) {
                if (!tok.hasParentInfo) {
                    throw new RuntimeException("After a number type in field " + fieldName + " a field size is expected in parenthesis.");
                }
                String fieldLenght = tok.parenthesisInfo.replace(".", ",");
                if (fieldLenght.contains(",")) {
                    SLinkOperations.setTarget((SNode)newProp, (SContainmentLink)LINKS.type$56v0, (SNode)SQLDescTableParser._quotation_createNode_qg6e6v_a0a0c0b61a92a71());
                    String[] deciInfo = fieldLenght.split(",");
                    SNode so = SConceptOperations.createNewNode((SConcept)MetaAdapterFactory.getConcept((long)6533198583024797571L, (long)-5622828788674067564L, (long)774207833082557411L, (String)"org.modellwerkstatt.manmap.structure.SizeOption"));
                    SPropertyOperations.assign((SNode)so, (SProperty)PROPS.value$hAZI, (int)new Integer(deciInfo[0]));
                    SPropertyOperations.assign((SNode)so, (SProperty)PROPS.decvalue$hBeJ, (int)new Integer(deciInfo[1]));
                    ListSequence.fromList((List)SLinkOperations.getChildren((SNode)newProp, (SContainmentLink)LINKS.propertyOption$7dlM)).addElement((Object)so);
                } else {
                    SLinkOperations.setTarget((SNode)newProp, (SContainmentLink)LINKS.type$56v0, (SNode)SQLDescTableParser._quotation_createNode_qg6e6v_a0a0a2a1q0db0r());
                }
            } else {
                throw new RuntimeException("Unknown type in description text: " + type);
            }
            SNode fm = SConceptOperations.createNewNode((SConcept)MetaAdapterFactory.getConcept((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900209251L, (String)"org.modellwerkstatt.manmap.structure.FieldMapping"));
            SLinkOperations.setTarget((SNode)fm, (SReferenceLink)LINKS.property$JxuR, (SNode)newProp);
            SLinkOperations.setTarget((SNode)fm, (SContainmentLink)LINKS.fieldName$un98, (SNode)SQLDescTableParser._quotation_createNode_qg6e6v_a0u0db0r());
            SPropertyOperations.assign((SNode)SLinkOperations.getTarget((SNode)fm, (SContainmentLink)LINKS.fieldName$un98), (SProperty)PROPS.value$w7MM, (String)fieldName);
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)mapping, (SContainmentLink)LINKS.atomMpig$bBsC)).addElement((Object)fm);
            tok = this.nextToken();
        }
    }

    private static SNode _quotation_createNode_qg6e6v_a0e0k0r() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1070475926800L, (String)"StringLiteral"));
        quotedNode_1 = nb.getResult();
        return quotedNode_1;
    }

    private static SNode _quotation_createNode_qg6e6v_a0a0q0db0r() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1225271177708L, (String)"StringType"));
        quotedNode_1 = nb.getResult();
        return quotedNode_1;
    }

    private static SNode _quotation_createNode_qg6e6v_a0a0a61a92a71() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1107535904670L, (String)"ClassifierType"));
        quotedNode_1 = nb.getResult();
        nb.setReference(MetaAdapterFactory.getReferenceLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1107535904670L, (long)1107535924139L, (String)"classifier"), "37fdf88a-1025-4d01-864a-0bf987f72e6f/java:org.joda.time(org.modellwerkstatt.manmap.runtime/)/~DateTime");
        return quotedNode_1;
    }

    private static SNode _quotation_createNode_qg6e6v_a0a0c0b61a92a71() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1107535904670L, (String)"ClassifierType"));
        quotedNode_1 = nb.getResult();
        nb.setReference(MetaAdapterFactory.getReferenceLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1107535904670L, (long)1107535924139L, (String)"classifier"), "6354ebe7-c22a-4a0f-ac54-50b52ab9b065/java:java.math(JDK/)/~BigDecimal");
        return quotedNode_1;
    }

    private static SNode _quotation_createNode_qg6e6v_a0a0a2a1q0db0r() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1070534370425L, (String)"IntegerType"));
        quotedNode_1 = nb.getResult();
        return quotedNode_1;
    }

    private static SNode _quotation_createNode_qg6e6v_a0u0db0r() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1070475926800L, (String)"StringLiteral"));
        quotedNode_1 = nb.getResult();
        return quotedNode_1;
    }

    public static class Token {
        public String id = "";
        public String parenthesisInfo = "";
        public boolean hasParentInfo = false;
    }

    private static final class CONCEPTS {
        static final SConcept EntityMapping$ux = MetaAdapterFactory.getConcept((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900209258L, (String)"org.modellwerkstatt.manmap.structure.EntityMapping");
        static final SConcept Entity$WP = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)1372017518093514468L, (String)"org.modellwerkstatt.objectflow.structure.Entity");
        static final SConcept NoKeyMapperField$_P = MetaAdapterFactory.getConcept((long)6533198583024797571L, (long)-5622828788674067564L, (long)781751828139414632L, (String)"org.modellwerkstatt.manmap.structure.NoKeyMapperField");
        static final SConcept DTO$UE = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)5225022991485184063L, (String)"org.modellwerkstatt.objectflow.structure.DTO");

        private CONCEPTS() {
        }
    }

    private static final class PROPS {
        static final SProperty name$MnvL = MetaAdapterFactory.getProperty((long)-3554657779850784990L, (long)-7236703803128771572L, (long)1169194658468L, (long)1169194664001L, (String)"name");
        static final SProperty value$w7MM = MetaAdapterFactory.getProperty((long)-935030926396207931L, (long)-6610165693999523818L, (long)1070475926800L, (long)1070475926801L, (String)"value");
        static final SProperty propertyName$DLW4 = MetaAdapterFactory.getProperty((long)-935030926396207931L, (long)-6610165693999523818L, (long)1201370618622L, (long)1201371481316L, (String)"propertyName");
        static final SProperty value$hAZI = MetaAdapterFactory.getProperty((long)6533198583024797571L, (long)-5622828788674067564L, (long)774207833082557411L, (long)774207833082557412L, (String)"value");
        static final SProperty decvalue$hBeJ = MetaAdapterFactory.getProperty((long)6533198583024797571L, (long)-5622828788674067564L, (long)774207833082557411L, (long)774207833082557413L, (String)"decvalue");

        private PROPS() {
        }
    }

    private static final class LINKS {
        static final SContainmentLink tableName$PpjQ = MetaAdapterFactory.getContainmentLink((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900209258L, (long)871579071901472001L, (String)"tableName");
        static final SReferenceLink classConcept$r5Kr = MetaAdapterFactory.getReferenceLink((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900209258L, (long)871579071900233967L, (String)"classConcept");
        static final SReferenceLink classConcept$G7ah = MetaAdapterFactory.getReferenceLink((long)6533198583024797571L, (long)-5622828788674067564L, (long)781751828139414632L, (long)781751828139414889L, (String)"classConcept");
        static final SContainmentLink businessProperties$cI4J = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4313579457188683399L, (long)3207218222495905601L, (String)"businessProperties");
        static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1201370618622L, (long)1201371521209L, (String)"type");
        static final SContainmentLink propertyOption$7dlM = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)8396343267227475961L, (long)3674496190757459099L, (String)"propertyOption");
        static final SReferenceLink property$JxuR = MetaAdapterFactory.getReferenceLink((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900209251L, (long)871579071900248751L, (String)"property");
        static final SContainmentLink fieldName$un98 = MetaAdapterFactory.getContainmentLink((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900209251L, (long)871579071900290535L, (String)"fieldName");
        static final SContainmentLink atomMpig$bBsC = MetaAdapterFactory.getContainmentLink((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900248872L, (long)4557816287827057767L, (String)"atomMpig");

        private LINKS() {
        }
    }
}

