/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.auth;

import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class CredentialReporter {
    private static final int CHECK_INTERVAL_MIN = 1440;
    private static final int TWO_WEEKS = 20160;
    private static DateTime lastCheck;

    public static boolean checkExpirationDateOnceInWindow(DateTime now, LocalDate target) {
        Duration diff;
        if (lastCheck == null) {
            lastCheck = now.minusMinutes(1441);
        }
        if ((diff = new Duration((ReadableInstant)lastCheck, (ReadableInstant)now)).getStandardMinutes() >= 1440L) {
            lastCheck = now;
            Duration toTarget = new Duration((ReadableInstant)now, (ReadableInstant)target.toDateTimeAtStartOfDay());
            if (toTarget.getStandardMinutes() < 20160L || now.isAfter((ReadableInstant)target.toDateTimeAtStartOfDay())) {
                return true;
            }
        }
        return false;
    }
}

