/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.auth;

import java.io.IOException;
import java.util.HashMap;
import mjson.Json;
import org.joda.time.LocalDate;
import org.modellwerkstatt.dataux.runtime.auth.GoogleOAuth2;
import org.modellwerkstatt.dataux.runtime.auth.IExtAuthProvider;

public class EntraIdOAuth2
implements IExtAuthProvider {
    private String AUTHINIT_ENDPOINT = "https://login.microsoftonline.com/-TENANT-/oauth2/v2.0/authorize";
    private String TOKEN_ENDPOINT = "https://login.microsoftonline.com/-TENANT-/oauth2/v2.0/token";
    private String SCOPE = "User.Read";
    private String CLIENT_ID = "not set";
    private String REDIRECT_URI = "not set";
    private String CLIENT_SECRET = "not set";
    private String USERNAME_FIELD_TO_USE = "not set";
    public String USERINFO_ENDPOINT = "https://graph.microsoft.com/v1.0/me";
    private LocalDate expirationDate;

    public EntraIdOAuth2(String tenant, String client_id, String client_secret, String redirect_to, String query_url, String username_field) {
        this.AUTHINIT_ENDPOINT = this.AUTHINIT_ENDPOINT.replace("-TENANT-", tenant);
        this.TOKEN_ENDPOINT = this.TOKEN_ENDPOINT.replace("-TENANT-", tenant);
        this.CLIENT_ID = client_id;
        this.CLIENT_SECRET = client_secret;
        this.REDIRECT_URI = redirect_to;
        this.USERINFO_ENDPOINT = query_url;
        this.USERNAME_FIELD_TO_USE = username_field;
    }

    public void setExpirationDate(String val) {
        try {
            this.expirationDate = new LocalDate((Object)val);
        }
        catch (Exception ex) {
            this.expirationDate = null;
            ex.printStackTrace();
        }
    }

    public String getExpirationDate() {
        return "" + this.expirationDate;
    }

    @Override
    public LocalDate getNullOrCredentialExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public String getAuthProviderName() {
        return "EntraID";
    }

    @Override
    public String initialRedirect(String state) {
        String result = this.AUTHINIT_ENDPOINT + "?client_id=" + this.CLIENT_ID + "&redirect_uri=" + this.REDIRECT_URI + "&response_type=code&scope=" + this.SCOPE + "&state=" + state;
        return result;
    }

    @Override
    public String retrieveUserWithAccessToken(String code) throws IOException {
        String request = "code=" + code + "&client_id=" + this.CLIENT_ID + "&client_secret=" + this.CLIENT_SECRET + "&redirect_uri=" + this.REDIRECT_URI + "&grant_type=authorization_code";
        String content = GoogleOAuth2.httpConnection(this.TOKEN_ENDPOINT, null, request);
        Json someJson = Json.read((String)content);
        if (!someJson.has("access_token")) {
            throw new RuntimeException("Did not receive a valid token: " + content);
        }
        String token = someJson.at("access_token").asString();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", "Bearer " + token);
        content = GoogleOAuth2.httpConnection(this.USERINFO_ENDPOINT, headerMap, null);
        someJson = Json.read((String)content);
        if (!someJson.has(this.USERNAME_FIELD_TO_USE)) {
            throw new RuntimeException("The field " + this.USERNAME_FIELD_TO_USE + " was not found in oauth2 servers return." + content);
        }
        content = someJson.at(this.USERNAME_FIELD_TO_USE).asString();
        return content;
    }
}

