/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.auth;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import mjson.Json;
import org.joda.time.LocalDate;
import org.modellwerkstatt.dataux.runtime.auth.IExtAuthProvider;

public class GoogleOAuth2
implements IExtAuthProvider {
    public String AUTHINIT_ENDPOINT = "https://accounts.google.com/o/oauth2/auth";
    public String TOKEN_ENDPOINT = "https://oauth2.googleapis.com/token";
    public String USERINFO_ENDPOINT = "https://www.googleapis.com/oauth2/v3/userinfo";
    public String SCOPE = "https://www.googleapis.com/auth/userinfo.email%20https://www.googleapis.com/auth/userinfo.profile";
    private String CLIENT_ID = "not set";
    private String REDIRECT_URI = "not set";
    private String CLIENT_SECRET = "not set";

    public GoogleOAuth2(String client_id, String client_secret, String redirect_to) {
        this.CLIENT_ID = client_id;
        this.CLIENT_SECRET = client_secret;
        this.REDIRECT_URI = redirect_to;
    }

    @Override
    public String getAuthProviderName() {
        return "Google";
    }

    @Override
    public LocalDate getNullOrCredentialExpirationDate() {
        return null;
    }

    @Override
    public String initialRedirect(String state) {
        String result = this.AUTHINIT_ENDPOINT + "?client_id=" + this.CLIENT_ID + "&redirect_uri=" + this.REDIRECT_URI + "&response_type=code&scope=" + this.SCOPE + "&state=" + state;
        return result;
    }

    @Override
    public String retrieveUserWithAccessToken(String code) throws IOException {
        String request = "code=" + code + "&client_id=" + this.CLIENT_ID + "&client_secret=" + this.CLIENT_SECRET + "&redirect_uri=" + this.REDIRECT_URI + "&grant_type=authorization_code";
        String content = GoogleOAuth2.httpConnection(this.TOKEN_ENDPOINT, null, request);
        if (content == null) {
            return null;
        }
        Json someJson = Json.read((String)content);
        if (!someJson.has("access_token")) {
            return null;
        }
        String token = someJson.at("access_token").asString();
        content = GoogleOAuth2.httpConnection(this.USERINFO_ENDPOINT + "?access_token=" + token, null, null);
        if (content == null) {
            return null;
        }
        someJson = Json.read((String)content);
        if (!someJson.has("email")) {
            return null;
        }
        content = someJson.at("email").asString();
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpConnection(String targetUrl, Map<String, String> headers, String postRequest) throws IOException {
        HttpURLConnection con = null;
        try {
            String inputLine;
            InputStream stream;
            URL url = new URL(targetUrl);
            con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            con.setInstanceFollowRedirects(false);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("Accept", "application/json");
            if (headers != null) {
                for (String key : headers.keySet()) {
                    con.setRequestProperty(key, headers.get(key));
                }
            }
            if (postRequest != null) {
                con.setRequestMethod("POST");
                con.setDoOutput(true);
                DataOutputStream out = new DataOutputStream(con.getOutputStream());
                out.writeBytes(postRequest);
                out.flush();
                out.close();
            } else {
                con.setRequestMethod("GET");
            }
            int status = con.getResponseCode();
            String errorStatus = null;
            StringBuilder content = new StringBuilder();
            if (status >= 200 && status < 300) {
                stream = con.getInputStream();
            } else {
                errorStatus = "Http Status " + status + " - " + con.getResponseMessage();
                stream = con.getErrorStream();
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            if (errorStatus != null) {
                throw new IOException(errorStatus + "\n" + content.toString());
            }
            String string = content.toString();
            return string;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }
}

