/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.auth;

import java.io.IOException;
import java.util.HashMap;
import mjson.Json;
import org.joda.time.LocalDate;
import org.modellwerkstatt.dataux.runtime.auth.GoogleOAuth2;
import org.modellwerkstatt.dataux.runtime.auth.IExtAuthProvider;

public class LinkedinOAuth2
implements IExtAuthProvider {
    public String AUTHINIT_ENDPOINT = "https://www.linkedin.com/oauth/v2/authorization";
    public String TOKEN_ENDPOINT = "https://www.linkedin.com/oauth/v2/accessToken";
    public String USERINFO_ENDPOINT = "https://api.linkedin.com/v2/userinfo";
    public String SCOPE = "profile email openid";
    private String CLIENT_ID = "not set";
    private String REDIRECT_URI = "not set";
    private String CLIENT_SECRET = "not set";

    public LinkedinOAuth2(String client_id, String client_secret, String redirect_to) {
        this.CLIENT_ID = client_id;
        this.CLIENT_SECRET = client_secret;
        this.REDIRECT_URI = redirect_to;
    }

    @Override
    public String initialRedirect(String state) {
        String result = this.AUTHINIT_ENDPOINT + "?client_id=" + this.CLIENT_ID + "&redirect_uri=" + this.REDIRECT_URI + "&response_type=code&scope=" + this.SCOPE + "&state=" + state;
        return result;
    }

    @Override
    public String retrieveUserWithAccessToken(String code) throws IOException {
        String request = "code=" + code + "&client_id=" + this.CLIENT_ID + "&client_secret=" + this.CLIENT_SECRET + "&redirect_uri=" + this.REDIRECT_URI + "&grant_type=authorization_code";
        String content = GoogleOAuth2.httpConnection(this.TOKEN_ENDPOINT + "?" + request, null, null);
        if (content == null) {
            return null;
        }
        Json someJson = Json.read((String)content);
        if (!someJson.has("access_token")) {
            return null;
        }
        String token = someJson.at("access_token").asString();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", "Bearer " + token);
        content = GoogleOAuth2.httpConnection(this.USERINFO_ENDPOINT, headerMap, null);
        if (content == null) {
            return null;
        }
        someJson = Json.read((String)content);
        if (!someJson.has("email")) {
            return null;
        }
        content = someJson.at("email").asString();
        return content;
    }

    @Override
    public String getAuthProviderName() {
        return "LinkedIn";
    }

    @Override
    public LocalDate getNullOrCredentialExpirationDate() {
        return null;
    }
}

