/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.core;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.core.ApplicationBasis;
import org.modellwerkstatt.dataux.runtime.core.ApplicationMDI;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.core.ISelectionController;
import org.modellwerkstatt.dataux.runtime.core.UxEvent;
import org.modellwerkstatt.dataux.runtime.core.WindowController;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.genspecifications.TileAction;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;

public abstract class AppMainWindowController
extends ApplicationBasis {
    protected WindowController mainWindowController;
    protected IOFXSession mainMenuEvalSession;
    protected IToolkit_MainWindow appMainWindow;
    protected List<CmdAction> mainMenuAndTileActions;
    private IOFXSession tilesSession = null;
    private List<TileAction> tileActions = null;
    private String currentDynamicStatusInfo = "0";
    private int currentBranding = -1;
    private boolean confirmClosedInstalled = false;

    public AppMainWindowController(IToolkit_UiFactory uf, IGenAppUiModule behave, AppJmxRegistration helper, IOFXCoreReporter.MoWarePlatform aPlatFrm) {
        super(uf, behave, helper, aPlatFrm);
    }

    public void userLoggedIn(String sysName, IOFXUserEnvironment userEnv, IOFXUserServices services, String connInfo, String connectInfoAddOn, String appFqName, String appShortName, String swVersion) {
        super.userLoggedIn(sysName, userEnv, connInfo, connectInfoAddOn, appFqName, appShortName, swVersion);
        this.mainMenuEvalSession = this.uiFactory.createNewSession(userEnv, services);
        this.appPrintService = this.uiFactory.createConfiguredUserPrintService(this.appMainWindow, userEnv);
    }

    protected boolean initializeApplication(OFXUrlParams url, ISelectionController fakeCrtl, String systemName, IOFXUserEnvironment userEnv, String userConnectionInfo, String startupInfo) {
        boolean startupCmdUsed = false;
        try {
            this.userEnvironment = userEnv;
            this.userEnvironment.setAppStartupLocalMillis(System.currentTimeMillis());
            this.userLoggedIn(systemName, userEnv, this, userConnectionInfo, startupInfo, this.applicationBehaviour.getClass().getName(), this.applicationBehaviour.getShortAppName(), this.applicationBehaviour.getApplicationVersion());
            Menu startFolder = this.applicationBehaviour.createStartMenu(this.userEnvironment);
            Menu extraFolder = this.applicationBehaviour.createExtrasMenu(this.userEnvironment);
            Menu helpFolder = this.applicationBehaviour.createHelpMenu(this.userEnvironment);
            this.mainMenuAndTileActions = startFolder.getAllCmdActionsOfMenu();
            ListSequence.fromList(this.mainMenuAndTileActions).addSequence((ISequence)ListSequence.fromList(extraFolder.getAllCmdActionsOfMenu()));
            ListSequence.fromList(this.mainMenuAndTileActions).addSequence((ISequence)ListSequence.fromList(helpFolder.getAllCmdActionsOfMenu()));
            this.tilesSession = this.uiFactory.createNewSession(this.userEnvironment, this);
            this.tileActions = this.applicationBehaviour.createAppTileActions(this.uiFactory, this.userEnvironment);
            ListSequence.fromList(this.tileActions).visitAll(it -> {
                it.setupTileAction();
                ListSequence.fromList(this.mainMenuAndTileActions).addElement((Object)it.getAction());
            });
            Wrappers._T mainWinHotkeys = new Wrappers._T((Object)ListSequence.fromList(new ArrayList()));
            ListSequence.fromList(this.mainMenuAndTileActions).visitAll(action -> {
                action.configure(this.uiFactory, this.mainWindowController, fakeCrtl, this.userEnvironment.getLangIndex());
                if (action.hotKey != null && !"".equals(action.hotKey)) {
                    ListSequence.fromList((List)((List)mainWinHotkeys.value)).addElement((Object)action.hotKey);
                }
            });
            List<Menu> allSubs = startFolder.getAllPlainMenus();
            ListSequence.fromList(allSubs).addSequence((ISequence)ListSequence.fromList(extraFolder.getAllPlainMenus()));
            ListSequence.fromList(allSubs).addSequence((ISequence)ListSequence.fromList(helpFolder.getAllPlainMenus()));
            ListSequence.fromList(allSubs).visitAll(it -> {
                if (it.labelText != null) {
                    it.configureLabel(this.uiFactory.getTransProvider().translateSingle(userEnv.getLangIndex(), it.labelText));
                }
            });
            this.appMainWindow.setMenuAndInit(this.userEnvironment.getLangIndex(), startFolder, extraFolder, helpFolder);
            this.appMainWindow.addStatusInformation("user " + userEnv.getUserName() + " / " + userEnv.getUserId());
            this.updateDynamicStatusInfo();
            mainWinHotkeys.value = ListSequence.fromList((List)((List)mainWinHotkeys.value)).distinct().toList();
            this.appMainWindow.ensureHotkeyAvailable((List)mainWinHotkeys.value);
            this.applicationBehaviour.userLoggedIn(userEnv, this);
            this.logAppTrace("", "", "org.modellwerkstatt.Login", "application startup", this.getuser_connectionInfoAddOn(), null);
            this.recalcAndShowTiles();
            this.reevalEnabledInMenusAndTiles();
            BasisCmdStart cmdStart = this.applicationBehaviour.createStartupCmd(this.mainMenuEvalSession);
            if (cmdStart != null) {
                IOFXCmdModule.CmdUrlDefaults def = null;
                if (url != null && url.hasCmdName()) {
                    def = this.getUrlDefaultFor(this.uiFactory.getAllCmdUrlDefaults(), url);
                }
                if (def == null || !cmdStart.getCommandName().equals(def.cmdFqName)) {
                    startupCmdUsed = true;
                    if (!cmdStart.hasParamsSet()) {
                        IOFXCmdModule mod = this.uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)cmdStart.getCommandName()));
                        cmdStart = cmdStart.cloneWithParams(mod.getCommandDefaultParams(cmdStart.getCommandName(), null, (Object)false));
                    }
                    this.mainWindowController.receiveAndProcess(cmdStart);
                    this.setCurrentAsAppStartupContainer();
                }
            }
        }
        catch (Exception ex) {
            this.mainWindowController.showException(ApplicationMDI.class.getName(), "", this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.FATA_APPFRMWRK_PROBLEM), "in initializeApplication()", ex, new IApplication.DlgRunnable(){

                @Override
                public void run(boolean confirmed) {
                    AppMainWindowController.this.internal_immediatelyShutdown();
                    AppMainWindowController.this.appMainWindow.closeApplicationAndExit();
                }
            });
        }
        this.updateDynamicStatusInfo();
        return startupCmdUsed;
    }

    public String getUserName() {
        if (this.userEnvironment == null) {
            return "(app already shut down)";
        }
        return this.userEnvironment.getUserName();
    }

    public String getDynamicStatusInfoOrSD() {
        if (this.userEnvironment == null) {
            return "(shut down)";
        }
        return this.userEnvironment.getDynamicStatusInfo();
    }

    public void adjustDeviceID(String newId) {
        if (newId != null && !newId.trim().equals("")) {
            this.userEnvironment.adjustDeviceId(newId);
            this.deviceId = this.userEnvironment.getDeviceId();
        }
    }

    private void updateDynamicStatusInfo() {
        if (this.userEnvironment != null) {
            String newOne = this.getDynamicStatusInfoOrSD();
            int newBranding = this.userEnvironment.getBrandingId();
            if (newOne == null) {
                newOne = "";
            }
            if (!newOne.equals(this.currentDynamicStatusInfo) || newBranding != this.currentBranding) {
                this.currentDynamicStatusInfo = newOne.trim();
                this.currentBranding = newBranding;
                this.appMainWindow.setAppInfo(this.applicationBehaviour.getShortAppName(), this.applicationBehaviour.getApplicationVersion(), this.currentDynamicStatusInfo, this.currentBranding);
            }
        }
    }

    public void recalcAndShowTiles() {
        this.applicationBehaviour.recalcTilesLabel(this.userEnvironment, this.tilesSession, this.tileActions);
        this.appMainWindow.showTiles(this.tileActions);
    }

    @Override
    public void reevalEnabledInMenusAndTiles() {
        this.touch();
        ListSequence.fromList(this.mainMenuAndTileActions).visitAll(it -> it.reevalEnabled());
        if (!this.shutdownMode) {
            this.updateDynamicStatusInfo();
        }
    }

    public void checkToInstallConfirmCloseAlert() {
        boolean needInstall;
        boolean bl = needInstall = !this.noGraphsToCommit();
        if (needInstall && !this.confirmClosedInstalled) {
            this.appMainWindow.installCloseConfirmQuestion(true);
            this.confirmClosedInstalled = true;
        } else if (this.confirmClosedInstalled && !needInstall) {
            this.appMainWindow.installCloseConfirmQuestion(false);
            this.confirmClosedInstalled = false;
        }
    }

    public abstract boolean noGraphsToCommit();

    @Override
    public boolean checkForAppParDeploymentForward() {
        boolean forwardPlease = false;
        if (this.getAppTelemetrics().isParDeploymentForwardImmediate() || this.getAppTelemetrics().isParDeploymentForwardGracefully() && this.noGraphsToCommit()) {
            forwardPlease = true;
            if (!this.userAlreadyNotifiedParDeplyForward) {
                this.userAlreadyNotifiedParDeplyForward = true;
                this.mainWindowController.showSimpleInfoDialog(this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.APPLICATION_LOCKED), new IApplication.DlgRunnable(){

                    @Override
                    public void run(boolean confirmed) {
                        AppMainWindowController.this.internal_immediatelyShutdown();
                        AppMainWindowController.this.appMainWindow.parDeploymentForwardNow();
                    }
                });
            }
        }
        return forwardPlease;
    }

    public abstract void internal_closeAllRunningCmds();

    public void internal_immediatelyShutdown() {
        this.shutdownMode = true;
        this.internal_closeAllRunningCmds();
        if (this.tilesSession != null) {
            this.tilesSession.closeSessionAndfreeGC();
        }
        if (this.mainMenuEvalSession != null) {
            this.mainMenuEvalSession.closeSessionAndfreeGC();
        }
        ListSequence.fromList(this.tileActions).clear();
        this.tileActions = null;
        ListSequence.fromList(this.mainMenuAndTileActions).visitAll(it -> it.gcClear());
        ListSequence.fromList(this.mainMenuAndTileActions).clear();
        this.mainMenuAndTileActions = null;
        super.closeReporting();
        if (this.userEnvironment != null) {
            this.userEnvironment.gcClean();
            this.userEnvironment = null;
        }
    }

    public boolean inShutdownMode() {
        return this.shutdownMode;
    }

    public void receiveAndProcess(UxEvent ev) {
        this.mainWindowController.receiveAndProcess(ev);
    }

    public void showException(String cmdOrComponent, String sessId, String reason, String contextInformation, Throwable throwable, IApplication.DlgRunnable run) {
        this.mainWindowController.showException(cmdOrComponent, sessId, reason, contextInformation, throwable, run);
    }

    public void showSimpleInfoDialog(String info, IApplication.DlgRunnable run) {
        this.mainWindowController.showSimpleInfoDialog(info, run);
    }

    public void showBigInformationDialog(String info, IApplication.DlgRunnable run) {
        this.mainWindowController.showBigInformationDialog(info, run);
    }

    @Override
    public IOFXSession getMainWindowEvalSession() {
        return this.mainMenuEvalSession;
    }

    @Override
    public IToolkit_MainWindow getMainWindowImpl() {
        return this.appMainWindow;
    }
}

