/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.core.ApplicationReporter;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;
import org.modellwerkstatt.dataux.runtime.core.GlobalCmdTermEvent;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.IPrintingServiceImpl;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;

public abstract class ApplicationBasis
extends ApplicationReporter
implements IApplication,
IOFXUserServices {
    protected IGenAppUiModule applicationBehaviour;
    protected boolean applicationModalTabMode;
    protected List<ICommandContainer> allRunningContainersToTerminate;
    protected ICommandContainer startupCommandContainer;
    protected IPrintingServiceImpl appPrintService;
    protected boolean shutdownMode;
    protected boolean userAlreadyNotifiedParDeplyForward;
    protected Runnable afterStartupCmd;

    public ApplicationBasis(IToolkit_UiFactory uf, IGenAppUiModule behave, AppJmxRegistration helper, IOFXCoreReporter.MoWarePlatform aPlatFrm) {
        super(uf, helper, aPlatFrm);
        this.applicationBehaviour = behave;
        this.applicationModalTabMode = false;
        this.allRunningContainersToTerminate = new ArrayList<ICommandContainer>();
        this.shutdownMode = false;
        this.userAlreadyNotifiedParDeplyForward = false;
        this.startupCommandContainer = null;
        this.afterStartupCmd = null;
    }

    @Override
    public boolean isApplicationModalTabMode() {
        return this.applicationModalTabMode;
    }

    @Override
    public void addToContainerRecorder(ICommandContainer container) {
        this.allRunningContainersToTerminate.add(container);
    }

    public void setCurrentAsAppStartupContainer() {
        if (this.allRunningContainersToTerminate.size() > 0) {
            this.startupCommandContainer = this.allRunningContainersToTerminate.get(0);
        }
    }

    @Override
    public void removeFromContainerRecorder(ICommandContainer container) {
        if (this.startupCommandContainer == container) {
            this.startupCommandContainer = null;
            if (this.afterStartupCmd != null) {
                try {
                    this.afterStartupCmd.run();
                }
                catch (Exception ex) {
                    this.logFrmwrkProblem("", "", "org.modellwerkstatt.App", ex, "Exception while running afterStartupCmd!");
                }
                finally {
                    this.afterStartupCmd = null;
                }
            }
        }
        if (!this.allRunningContainersToTerminate.contains(container)) {
            this.logFrmwrkProblem("", "", "org.modellwerkstatt.App", "The terminated container " + container + " was not found in the allRunningContainersToTerminate - this can not happen.", this.fullApplicationCrtlState());
        } else {
            this.allRunningContainersToTerminate.remove(container);
        }
    }

    public void execAfterStartupOrNow(Runnable rnbl) {
        if (this.isStartupCmdRunning()) {
            this.afterStartupCmd = rnbl;
        } else {
            rnbl.run();
        }
    }

    public boolean isStartupCmdRunning() {
        return this.isCommandRunning() && this.allRunningContainersToTerminate.get(0) == this.startupCommandContainer;
    }

    public boolean isCommandRunning() {
        return this.allRunningContainersToTerminate.size() > 0;
    }

    @Override
    public boolean distributeTermEventOnRecorder(GlobalCmdTermEvent event) {
        boolean parentFound = false;
        ICommandContainer parent = event.getParentOfClosed();
        for (ICommandContainer cntr : List.copyOf(this.allRunningContainersToTerminate)) {
            cntr.receiveAndProcess(event);
            if (cntr != parent) continue;
            parentFound = true;
        }
        return parentFound;
    }

    public File renderPrint(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
        return this.appPrintService.renderPrint(documentFilename, xsltTemplateName, xmlGraphData, barcode);
    }

    public File renderView(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
        return this.appPrintService.renderView(documentFilename, xsltTemplateName, xmlGraphData, barcode);
    }

    public File render(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
        return this.appPrintService.render(documentFilename, xsltTemplateName, xmlGraphData, barcode);
    }

    public void view(File pdfFile) {
        this.appPrintService.view(pdfFile);
    }

    public void print(File pdfFile) {
        this.appPrintService.print(pdfFile);
    }

    public void openUrl(String url) {
        this.appPrintService.openUrl(url);
    }

    public void logOnCoreReporter(String cmdFqName, String sessId, String source, IOFXCoreReporter.LogPriority prio, String msg, HashMap<String, Object> paramMap) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.APP_MESSAGE, source, cmdFqName, sessId, prio, msg);
        if (paramMap != null) {
            for (String key : paramMap.keySet()) {
                info.addParameter(key, paramMap.get(key));
            }
        }
        this.uiFactory.report(info);
    }

    @Override
    public IOFXUserEnvironment getUserEnvironment() {
        return this.userEnvironment;
    }

    @Override
    public IOFXUserServices getUserService() {
        return this;
    }

    public IOFXCmdModule.CmdUrlDefaults getUrlDefaultFor(List<IOFXCmdModule.CmdUrlDefaults> urlDefaults, OFXUrlParams urlParam) {
        if (!urlParam.hasCmdName()) {
            throw new RuntimeException("This can not happen.");
        }
        IOFXCmdModule.CmdUrlDefaults infoForCmd = (IOFXCmdModule.CmdUrlDefaults)ListSequence.fromList(urlDefaults).findFirst(it -> it.url.equals(urlParam.getCmdName()) && urlParam.numParams() >= it.minNumParams && urlParam.numParams() <= it.maxNumParams);
        if (infoForCmd != null) {
            IOFXCmdModule module = this.uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)infoForCmd.cmdFqName));
            try {
                Object[] objectArray = module.getCommandUrlDefaultParams(infoForCmd.cmdFqName, urlParam);
            }
            catch (NumberFormatException ex) {
                infoForCmd = null;
            }
            catch (IllegalArgumentException ex) {
                infoForCmd = null;
            }
        }
        return infoForCmd;
    }

    public BasisCmdStart cmdStartForUrlDefault(IOFXCmdModule.CmdUrlDefaults def, OFXUrlParams urlParams, IOFXSession session) {
        boolean enabled;
        IOFXCmdModule module = this.uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)def.cmdFqName));
        Object[] params = module.getCommandUrlDefaultParams(def.cmdFqName, urlParams);
        if (params == null) {
            throw new RuntimeException("This can not be true. Tried to start a command with params null.");
        }
        boolean bl = enabled = module.getCommandPermission(IOFXCmdModule.CmdExecStrategy.SINGLE, def.cmdFqName, params, session) != IOFXCmdModule.CommandPermission.DISABLED;
        if (!enabled) {
            return null;
        }
        BasisCmdStart ev = new BasisCmdStart(def.cmdFqName, params);
        ev.setLabelText(def.desc);
        return ev;
    }
}

