/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.core;

import java.util.ArrayList;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.core.FukYouEvent;
import org.modellwerkstatt.dataux.runtime.core.UxEvent;

public class CircularEventStore {
    private int max;
    private int currentPos;
    private int eventsStored;
    private String[] events;

    public CircularEventStore(int maxSize) {
        this.max = maxSize;
        this.events = new String[this.max];
        this.currentPos = 0;
        this.eventsStored = 0;
    }

    public void add(UxEvent ev) {
        this.events[this.currentPos] = ev.toString();
        ++this.currentPos;
        if (this.eventsStored < this.max) {
            ++this.eventsStored;
        }
        if (this.currentPos >= this.max) {
            this.currentPos = 0;
        }
    }

    public String getLast() {
        if (this.eventsStored == 0) {
            return null;
        }
        int lastEventIndex = this.currentPos - 1;
        if (lastEventIndex < 0) {
            lastEventIndex = this.max - 1;
        }
        return this.events[lastEventIndex];
    }

    public List<String> toList() {
        ArrayList<String> inOrder = new ArrayList<String>(this.max);
        int index = this.currentPos - this.eventsStored;
        if (index < 0) {
            index = this.max + index;
        }
        for (int cnt = 0; cnt < this.eventsStored; ++cnt) {
            inOrder.add(this.events[index]);
            if (++index < this.max) continue;
            index = 0;
        }
        return inOrder;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (String e : this.toList()) {
            b.append(String.format("%10s: %s\n", "" + i++, e));
        }
        return b.toString();
    }

    public static void main(String[] args) {
        CircularEventStore es = new CircularEventStore(3);
        es.add(new FukYouEvent("first"));
        es.add(new FukYouEvent("second"));
        es.add(new FukYouEvent("third"));
        es.add(new FukYouEvent("fourth"));
        es.add(new FukYouEvent("fivth"));
        es.add(new FukYouEvent("sixth"));
        es.add(new FukYouEvent("seventh"));
        System.out.println(es.toString());
    }
}

