/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.core;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;
import org.modellwerkstatt.dataux.runtime.core.GlobalCmdTermEvent;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.IWindowController;
import org.modellwerkstatt.dataux.runtime.core.InitCmdEvent;
import org.modellwerkstatt.dataux.runtime.core.MultiCmdStart;
import org.modellwerkstatt.dataux.runtime.core.PushSelEvent;
import org.modellwerkstatt.dataux.runtime.core.UxEvent;
import org.modellwerkstatt.dataux.runtime.core.WindowReporter;
import org.modellwerkstatt.dataux.runtime.sdicore.ApplicationSDI;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Window;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.IOFXCommand;
import org.modellwerkstatt.objectflow.runtime.IOFXDynCmdParams;
import org.modellwerkstatt.objectflow.runtime.IOFXSelcrtlBasics;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class WindowController
extends WindowReporter
implements IWindowController {
    private BlockingQueue<UxEvent> windowEvents = new LinkedBlockingQueue<UxEvent>(10);
    private boolean inEventLoop;
    protected MultiCmdStart multiActEvent;
    protected ICommandContainer currentMultiActContainer;

    public WindowController(IToolkit_UiFactory uf, IApplication theApp, IToolkit_Window win) {
        super(uf, win, theApp);
    }

    @Override
    public void receiveAndProcess(UxEvent ev) {
        this.windowEvents.add(ev);
        if (!this.inEventLoop) {
            this.processPendingEvents();
        }
    }

    public synchronized void processPendingEvents() {
        UxEvent eventToProcess = null;
        try {
            this.inEventLoop = true;
            if (this.windowEvents.size() == 0) {
                this.app.logFrmwrkProblem("", "", "org.modellwerkstatt.App", "processPendingEvents() in AppEventBridge called without any events to process.", null);
            }
            while (this.windowEvents.size() > 0) {
                eventToProcess = this.windowEvents.take();
                this.app.logMowareTracing("", "", "org.modellwerkstatt.Event", eventToProcess.name(), eventToProcess.paramInfo());
                if (eventToProcess instanceof BasisCmdStart) {
                    this.startCommandByEvent((BasisCmdStart)eventToProcess);
                    continue;
                }
                if (eventToProcess instanceof MultiCmdStart) {
                    if (this.isMultiAction()) {
                        throw new RuntimeException("Can not start Multi while processing multi: " + eventToProcess + " but processing " + this.multiActEvent);
                    }
                    this.multiActEvent = (MultiCmdStart)eventToProcess;
                    this.currentMultiActContainer = null;
                    this.handleMultiStartEvent();
                    continue;
                }
                throw new RuntimeException("Unknown event " + eventToProcess);
            }
        }
        catch (Exception t) {
            this.showException(WindowController.class.getName(), "", "Exception in processPendingEvents()", "" + eventToProcess, t, null);
        }
        finally {
            this.inEventLoop = false;
        }
    }

    public void sameInstanceRunningUserNotification() {
    }

    public void startCommandByEvent(BasisCmdStart ev) {
        boolean startNewWindow;
        boolean startIt = true;
        IOFXCmdModule module = this.uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)ev.getCommandName()));
        Object[] params = ev.getParams();
        ICommandContainer parent = ev.getParentContainer();
        IOFXSession parentSession = null;
        if (parent != null) {
            parentSession = parent.getSession();
        }
        if (this.app.isApplicationModalTabMode() && module.isCommandType(ev.getCommandName(), new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL, IOFXCommand.OFXCmdTyp.SEARCH_CMD})) {
            throw new RuntimeException("When a modal tab is opened, only GRAPH_EDIT commands can be started. This is a programming error.");
        }
        if (!this.isMultiAction()) {
            boolean bl = startIt = !this.app.isSameInstanceRunningThenFocus(ev.getCommandName(), params);
            if (!startIt) {
                this.sameInstanceRunningUserNotification();
            }
        }
        if ((!this.isMultiAction() || this.isMultiAction() && this.multiActEvent.willBeFirstExecution()) && this.app.checkForAppParDeploymentForward()) {
            this.stopMultiActionIfOne();
            startIt = false;
        }
        boolean bl = startNewWindow = this.app instanceof ApplicationSDI && !ev.isForcedToThisWindowCrtl() && !this.isMultiAction() && !module.isCommandType(ev.getCommandName(), new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.GRAPH_EDIT_CMD}) && module.supportUrlDefaultParams(ev.getCommandName());
        if (startIt && !startNewWindow) {
            IOFXCommand cmd = module.startCommand(IOFXCmdModule.CmdExecStrategy.SINGLE, ev.getCommandName(), params, parentSession, this.app.getUserEnvironment(), this.app.getUserService());
            ICommandContainer container = this.uiFactory.createCommandContainer();
            container.initContainer(this.uiFactory, this.app, this, parent, ev, cmd.getCommandSession().getSessionLoggingId());
            if (this.isMultiAction() && this.currentMultiActContainer == null) {
                this.currentMultiActContainer = container;
            }
            boolean inBackground = this.uiFactory.useBackgroundThread() && (cmd.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.SEARCH_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL}) || cmd.hasOption(IOFXCommand.OFXCmdOptions.BACKGROUND));
            this.app.addToContainerRecorder(container);
            container.receiveAndProcess(new InitCmdEvent(inBackground, cmd, params));
        } else if (startIt) {
            ((ApplicationSDI)this.app).startWithNewCrtl(this.window, ev);
        }
    }

    public boolean isMultiAction() {
        return this.multiActEvent != null;
    }

    public void handleMultiStartEvent() {
        if (!this.multiActEvent.isLast()) {
            Object[] params;
            if (!this.multiActEvent.isFastExecNoUi()) {
                Object nextSelection = this.multiActEvent.getCurrentLocalSelection();
                this.multiActEvent.getParentContainer().receiveAndProcess(new PushSelEvent(nextSelection));
            }
            if (this.multiActEvent.hasNonDefaultParamProvider()) {
                IOFXDynCmdParams paramProvider = this.multiActEvent.getNonDefaultParamProvider();
                params = paramProvider.calc((IOFXSelcrtlBasics)this.multiActEvent.getLocalSelCrtl(), this.multiActEvent.getCurrentLocalSelection());
            } else {
                IOFXCmdModule cmdModule = this.uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)this.multiActEvent.getCommandName()));
                params = cmdModule.getCommandDefaultParams(this.multiActEvent.getCommandName(), (IOFXSelcrtlBasics)this.multiActEvent.getLocalSelCrtl(), this.multiActEvent.getCurrentLocalSelection());
            }
            BasisCmdStart startEvent = this.multiActEvent.getParameterizedStartEvent(params);
            this.multiActEvent.incExecutions();
            this.receiveAndProcess(startEvent);
        } else {
            this.stopMultiActionIfOne();
        }
    }

    public void stopMultiActionIfOne() {
        if (this.isMultiAction()) {
            this.multiActEvent.gcClean();
            this.currentMultiActContainer = null;
            this.multiActEvent = null;
        }
    }

    @Override
    public void showException(String cmdOrComponent, String sessId, String reason, String contextInformation, Throwable throwable, IApplication.DlgRunnable run) {
        this.stopMultiActionIfOne();
        super.showException(cmdOrComponent, sessId, reason, contextInformation, throwable, run);
    }

    @Override
    public void askCloseQuestionDialog(String question, IApplication.DlgRunnable run) {
        this.stopMultiActionIfOne();
        super.askCloseQuestionDialog(question, run);
    }

    @Override
    public void showGraphDebugger(List<Object> graph, String controllerInformation) {
        this.stopMultiActionIfOne();
        super.showGraphDebugger(graph, controllerInformation);
    }

    @Override
    public void commandClosed(GlobalCmdTermEvent termEvent) {
        this.app.removeFromContainerRecorder(termEvent.getClosedContainer());
        ICommandContainer parent = termEvent.getParentOfClosed();
        if (this.isMultiAction() && this.multiActEvent.isFastExecNoUi() && termEvent.wasOk() && !this.multiActEvent.isLast()) {
            termEvent.setNotReloadViewsOnParent();
        }
        boolean parentFound = this.app.distributeTermEventOnRecorder(termEvent);
        if (this.isMultiAction()) {
            if (!this.multiActEvent.getParentContainer().isStillOkayAsParentForMultiExecution()) {
                this.stopMultiActionIfOne();
            } else if (this.currentMultiActContainer == termEvent.getClosedContainer()) {
                boolean startNext;
                boolean bl = startNext = termEvent.wasOk() || this.multiActEvent.isGoOnWhenCanceled() && termEvent.wasCancelOrUserCancel();
                if (startNext) {
                    this.currentMultiActContainer = null;
                    this.handleMultiStartEvent();
                } else {
                    this.stopMultiActionIfOne();
                }
            }
        }
        if (!parentFound && parent != null) {
            if (!parent.isAutoConNoUi()) {
                this.app.logFrmwrkProblem("", "", "org.modellwerkstatt.App", "Parent " + parent + " not found as tab/prompt of " + termEvent.getClosedContainer().toString(), OFXConsoleHelper._____organizeCurrentStacktrace_____());
            }
            parent.receiveAndProcess(termEvent);
        }
    }

    @Override
    public void showCommandContainerUI(ICommandContainer cc, IToolkit_CommandContainerUi ui, String windowTitle, IToolkit_Form content) {
        throw new RuntimeException("Not implemented in plain WindowController");
    }

    @Override
    public void closeCommandContainerUI(ICommandContainer cc, IToolkit_CommandContainerUi ui, ICommandContainer parent) {
        throw new RuntimeException("Not implemented in plain WindowController");
    }

    @Override
    public void focusTab(ICommandContainer cc, IToolkit_CommandContainerUi ui) {
        throw new RuntimeException("Not implemented in plain WindowController");
    }

    @Override
    public void internal_immediatelyShutdown() {
        throw new RuntimeException("Not implemented right now [SMR 24]");
    }

    @Override
    public IOFXSession getSession() {
        return this.app.getMainWindowEvalSession();
    }
}

