/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.dataux.runtime.delegates.Delegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public class DateTimeDelegate
extends Delegate<DateTime, IToolkit_DateOrTimeEditor> {
    private DateTimeFormatter formatter;
    private String format;
    private DateTime oldDateTime;
    private boolean timeOnly;

    public DateTimeDelegate(IToolkit_UiFactory factory, int langIdx, IToolkit_TextEditor.Option ... pickerOption) {
        super(factory, langIdx);
        boolean needsPicker = IToolkit_TextEditor.has(IToolkit_TextEditor.Option.ALTER_PICKER, pickerOption);
        this.timeOnly = IToolkit_TextEditor.has(IToolkit_TextEditor.Option.DATETIME_TIMEONLY, pickerOption);
        this.format = factory.getTransProvider().getDefaultDelegateDateTimeEditorFormat();
        this.formatter = factory.getTransProvider().getDelegateDateTimeEditorFormatter(langIdx, null);
        this.toolkitEditor = factory.createDateAndTimeEditor(needsPicker, this.timeOnly);
        ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setDelegate(this);
        ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setFormatter(this.format, this.formatter.getLocale().toLanguageTag(), this.langIndex);
        ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setEditorPrompt(DateTimeDelegate.convertFormatToPromptString(this.format));
        this.oldDateTime = null;
    }

    @Override
    public DateTime getValue() {
        if (this.isCurrentlyInOptionalState()) {
            return null;
        }
        try {
            DateTime returnDateTime = this.formatter.parseDateTime(((IToolkit_DateOrTimeEditor)this.toolkitEditor).getText());
            if (this.oldDateTime != null && returnDateTime.equals((Object)this.oldDateTime.withSecondOfMinute(0))) {
                returnDateTime = returnDateTime.withSecondOfMinute(this.oldDateTime.getSecondOfMinute());
            }
            return returnDateTime;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setValue(DateTime value) {
        if (value != null) {
            this.oldDateTime = value;
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setText(this.formatter.print((ReadableInstant)value));
        } else {
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setText("");
        }
    }

    @Override
    public String isInputValid() {
        if (!((Boolean)this.enabled.getValue()).booleanValue()) {
            return null;
        }
        ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setValidationErrorText("");
        try {
            if (this.isCurrentlyInOptionalState()) {
                return null;
            }
            this.formatter.parseDateTime(((IToolkit_DateOrTimeEditor)this.toolkitEditor).getText());
        }
        catch (Exception ex) {
            String errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.DATETIME_VALIDATION_ERR), this.format);
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setValidationErrorText(errText);
            return errText;
        }
        return null;
    }

    @Override
    public void setFormat(String frmt) {
        if (frmt != null && !"".equals(frmt.trim())) {
            if (frmt.lastIndexOf(" ") < 0) {
                throw new RuntimeException("Format has to contain one space to divide date from time format. Eg. dd.MM.yy[SPACE]HH:mm");
            }
            this.format = frmt;
            this.formatter = this.uiFactory.getTransProvider().getDelegateDateTimeEditorFormatter(this.langIndex, this.format);
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setFormatter(this.format, this.formatter.getLocale().toLanguageTag(), this.langIndex);
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setEditorPrompt(DateTimeDelegate.convertFormatToPromptString(this.format));
            this.setEnabled(false);
        }
    }

    public static String convertFormatToPromptString(String frmt) {
        Object s = "";
        for (int i = 0; i < frmt.length(); ++i) {
            char c = frmt.charAt(i);
            s = c == '.' || c == '/' || c == ':' || c == '\\' ? (String)s + c : (String)s + "_";
        }
        return s;
    }

    private static boolean isSeperator(char c) {
        return c == '.' || c == ':' || c == ' ' || c == '/' || c == ',';
    }

    private static int toNextSeperator(String txt, int idx, String sep, StringBuilder res) {
        if (idx >= txt.length()) {
            return idx;
        }
        if (Character.isDigit(txt.charAt(idx))) {
            res.append(txt.charAt(idx));
            ++idx;
        }
        if (idx < txt.length() && Character.isDigit(txt.charAt(idx))) {
            res.append(txt.charAt(idx));
            ++idx;
        }
        if (idx < txt.length() && DateTimeDelegate.isSeperator(txt.charAt(idx))) {
            ++idx;
        }
        res.append(sep);
        return idx;
    }

    public static String adjusDateTimeDotInputText(String txt) {
        StringBuilder result = new StringBuilder();
        int cur = DateTimeDelegate.toNextSeperator(txt, 0, ".", result);
        cur = DateTimeDelegate.toNextSeperator(txt, cur, ".", result);
        cur = DateTimeDelegate.toNextSeperator(txt, cur, " ", result);
        cur = DateTimeDelegate.toNextSeperator(txt, cur, ":", result);
        cur = DateTimeDelegate.toNextSeperator(txt, cur, "", result);
        result.append(txt.substring(cur));
        return result.toString();
    }

    public static void main(String[] args) {
        System.err.println(DateTimeDelegate.adjusDateTimeDotInputText("270180 1400"));
        System.err.println(DateTimeDelegate.adjusDateTimeDotInputText("2701801400"));
        System.err.println(DateTimeDelegate.adjusDateTimeDotInputText("27.01.80 14:00"));
        System.err.println(DateTimeDelegate.adjusDateTimeDotInputText("27.1.80 1 1"));
        System.err.println(DateTimeDelegate.adjusDateTimeDotInputText("27.1.80 1 1 dan"));
        System.err.println(DateTimeDelegate.adjusDateTimeDotInputText("2718011"));
        System.err.println(DateTimeDelegate.adjusDateTimeDotInputText("270180 9.00"));
        System.err.println(DateTimeDelegate.adjusDateTimeDotInputText("270180 9."));
        System.err.println(DateTimeDelegate.adjusDateTimeDotInputText("270180 9"));
        System.err.println(DateTimeDelegate.adjusDateTimeDotInputText("271.801.1"));
    }
}

