/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.dataux.runtime.delegates.DateTimeDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.Delegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public class LocalDateDelegate
extends Delegate<LocalDate, IToolkit_DateOrTimeEditor> {
    private DateTimeFormatter formatter;
    private String format;

    public LocalDateDelegate(IToolkit_UiFactory factory, int langIdx, IToolkit_TextEditor.Option ... pickerOption) {
        super(factory, langIdx);
        this.format = factory.getTransProvider().getDefaultLocalDateFormat();
        this.formatter = factory.getTransProvider().getLocalDateFormatter(langIdx, null);
        boolean needsPicker = IToolkit_TextEditor.has(IToolkit_TextEditor.Option.ALTER_PICKER, pickerOption);
        this.toolkitEditor = factory.createDateEditor(needsPicker);
        ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setDelegate(this);
        ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setFormatter(this.format, this.formatter.getLocale().toLanguageTag(), this.langIndex);
        ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setEditorPrompt(DateTimeDelegate.convertFormatToPromptString(this.format));
    }

    @Override
    public LocalDate getValue() {
        if (this.isCurrentlyInOptionalState()) {
            return null;
        }
        try {
            String text = ((IToolkit_DateOrTimeEditor)this.toolkitEditor).getText();
            if (this.hasDelegateHook()) {
                return (LocalDate)this.delegateHook.getValue(text);
            }
            return this.formatter.parseLocalDate(text);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setValue(LocalDate value) {
        if (value != null) {
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setText(this.formatter.print((ReadablePartial)value));
        } else {
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setText("");
        }
    }

    @Override
    public String isInputValid() {
        String errText;
        block6: {
            if (!((Boolean)this.enabled.getValue()).booleanValue()) {
                return null;
            }
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setValidationErrorText("");
            if (this.isCurrentlyInOptionalState()) {
                return null;
            }
            try {
                String val = ((IToolkit_DateOrTimeEditor)this.toolkitEditor).getText();
                if (this.hasDelegateHook()) {
                    errText = this.delegateHook.isInputValid(val);
                    if (errText == null) {
                        return null;
                    }
                    break block6;
                }
                this.formatter.parseLocalDate(val);
                return null;
            }
            catch (Exception ex) {
                errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.DATE_VALIDATION_ERR), this.format);
            }
        }
        ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setValidationErrorText(errText);
        return errText;
    }

    @Override
    public void setFormat(String frmt) {
        if (frmt != null && !"".equals(frmt.trim())) {
            this.format = frmt;
            this.formatter = this.uiFactory.getTransProvider().getLocalDateFormatter(this.langIndex, this.format);
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setFormatter(this.format, this.formatter.getLocale().toLanguageTag(), this.langIndex);
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setEditorPrompt(DateTimeDelegate.convertFormatToPromptString(this.format));
            this.setEnabled(false);
        }
    }

    public static String adjusDateDotInputText(String txt) {
        if (txt.length() == 6) {
            boolean onlyDigits = true;
            for (int i = 0; i < txt.length(); ++i) {
                if (Character.isDigit(txt.charAt(i))) continue;
                onlyDigits = false;
                break;
            }
            if (onlyDigits) {
                String stNew = txt.substring(0, 2) + "." + txt.substring(2, 4) + "." + txt.substring(4);
                return stNew;
            }
        }
        return txt;
    }
}

