/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.modellwerkstatt.dataux.runtime.delegates.Delegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_ReferenceEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaReferences;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;

public class ReferenceDelegate<T>
extends Delegate<T, IToolkit_ReferenceEditor> {
    public static final String GENERAL_OPTIONAL_ITEM_TEXT = "---";
    protected List<T> referenceItems;
    protected List<String> referenceDescriptions;
    protected List<String> suggestionFieldFormat;
    protected IOFXMetaReferences<T> metaInfo = null;

    public ReferenceDelegate(IToolkit_UiFactory factory, int langIdx, IToolkit_TextEditor.Option ... alterOptions) {
        super(factory, langIdx);
        this.toolkitEditor = factory.createReferenceEditor(IToolkit_TextEditor.has(IToolkit_TextEditor.Option.ALTER_PICKER, alterOptions));
        ((IToolkit_ReferenceEditor)this.toolkitEditor).setDelegate(this);
        ((IToolkit_ReferenceEditor)this.toolkitEditor).setEditorPrompt(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.CRTL_SPACE_PRESS));
    }

    @Override
    public T getValue() {
        if (this.isCurrentlyInOptionalState()) {
            return null;
        }
        int i = ListSequence.fromList(this.referenceDescriptions).indexOf((Object)((IToolkit_ReferenceEditor)this.toolkitEditor).getText());
        if (i < 0) {
            throw new IllegalStateException("No reference found for given text (" + ((IToolkit_ReferenceEditor)this.toolkitEditor).getText() + ") while obtaining value. Available are " + this.referenceDescriptions);
        }
        return (T)ListSequence.fromList(this.referenceItems).getElement(i);
    }

    private int getIndexReplaceInScope(T origRef) {
        int i = ListSequence.fromList(this.referenceItems).indexOf(origRef);
        if (i >= 0) {
            return i;
        }
        if (origRef instanceof IOFXEntity) {
            Object refKey = ((IOFXEntity)origRef).getIM3Key();
            for (int j = 0; j < ListSequence.fromList(this.referenceItems).count(); ++j) {
                boolean replaceAndReturn = false;
                Object ent = ListSequence.fromList(this.referenceItems).getElement(j);
                if (ent instanceof IOFXEntity) {
                    Object candiate = ((IOFXEntity)ent).getIM3Key();
                    if (SaveObjectComperator.equals((Object)refKey, (Object)candiate)) {
                        replaceAndReturn = true;
                    }
                } else if (SaveObjectComperator.equals(origRef, (Object)ent)) {
                    replaceAndReturn = true;
                }
                if (!replaceAndReturn) continue;
                ListSequence.fromList(this.referenceItems).setElement(j, origRef);
                return j;
            }
        }
        return -1;
    }

    @Override
    public void setValue(T origRef) {
        if (origRef != null) {
            if (this.referenceItems == null) {
                String desc = this.getObjAsString(origRef);
                ((IToolkit_ReferenceEditor)this.toolkitEditor).setText(desc);
            } else {
                int i = this.getIndexReplaceInScope(origRef);
                if (i >= 0) {
                    ((IToolkit_ReferenceEditor)this.toolkitEditor).setText((String)ListSequence.fromList(this.referenceDescriptions).getElement(i));
                } else if (((Boolean)this.enabled.getValue()).booleanValue()) {
                    throw new RuntimeException("Value '" + origRef + "' not in Scope " + this.referenceItems + " for ReferenceDelegate '" + this.propertyName + "'");
                }
            }
        } else {
            ((IToolkit_ReferenceEditor)this.toolkitEditor).setText(null);
        }
    }

    public void setHintForScope(String val) {
        if (this.metaInfo != null) {
            MoJSON.put(this.metaInfo, "hintForScope", val);
        }
    }

    @Override
    public void load(Object obj) {
        this.setHintForScope("");
        this.metaInfo = null;
        Object metaObj = null;
        if (this.propertyName != null) {
            metaObj = MoJSON.get(obj, Delegate.getMetaDataAccessorToPath(this.propertyName));
            List refItems = null;
            if (metaObj != null && metaObj instanceof IOFXMetaReferences) {
                IOFXMetaReferences metaInformation = metaObj;
                refItems = metaInformation.getScope();
                this.metaInfo = metaInformation;
            }
            if (refItems != null) {
                this.setReferenceItems(refItems);
            }
        }
        super.load(obj);
        if (this.propertyName != null) {
            ((IToolkit_ReferenceEditor)this.toolkitEditor).setOptionalAfterLoad((Boolean)this.optional.getValue());
        }
        if (metaObj != null && ((Boolean)this.enabled.getValue()).booleanValue() && this.referenceItems == null) {
            throw new RuntimeException("No Scope [" + this.referenceItems + "] for ReferenceDelegate '" + this.propertyName + "' (and delegate not in read only).");
        }
    }

    @Override
    public String isInputValid() {
        if (!((Boolean)this.enabled.getValue()).booleanValue()) {
            return null;
        }
        ((IToolkit_ReferenceEditor)this.toolkitEditor).setValidationErrorText("");
        if (this.isCurrentlyInOptionalState()) {
            return null;
        }
        String errText = null;
        if (((IToolkit_ReferenceEditor)this.toolkitEditor).getText() == null || ((IToolkit_ReferenceEditor)this.toolkitEditor).getText().equals("")) {
            errText = this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.REF_VALIDATION_ERR);
            ((IToolkit_ReferenceEditor)this.toolkitEditor).setValidationErrorText(errText);
        }
        return errText;
    }

    @Override
    public void setFormat(String frmt) {
        this.setSuggestionFieldFormat(frmt.split(","));
    }

    public void setReferenceItems(List<T> elements) {
        if (this.referenceItems != elements && !ReferenceDelegate.sameContent(this.referenceItems, elements)) {
            this.referenceItems = elements;
            this.referenceDescriptions = ListSequence.fromList(new ArrayList());
            for (int i = 0; i < ListSequence.fromList(elements).count(); ++i) {
                ListSequence.fromList(this.referenceDescriptions).addElement((Object)this.getObjAsString(ListSequence.fromList(elements).getElement(i)));
            }
            ((IToolkit_ReferenceEditor)this.toolkitEditor).setItems(this.referenceDescriptions);
        }
    }

    public void setInputFieldFormat(String format) {
        throw new RuntimeException("no longer implemented");
    }

    public void setSuggestionFieldFormat(String[] elements) {
        this.suggestionFieldFormat = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(this.suggestionFieldFormat).addSequence(Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])elements)).select(it -> it.trim()));
    }

    public void setSelected(T obj) {
        this.setValue(obj);
    }

    public Object getSelected() {
        return this.getValue();
    }

    protected static <T> boolean sameContent(List<T> l1, List<T> l2) {
        if (l1 == null || l2 == null || l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (SaveObjectComperator.equals(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private String getObjAsString(Object obj) {
        StringBuilder tmp = new StringBuilder();
        ListSequence.fromList(this.suggestionFieldFormat).visitAll(field -> tmp.append(MoJSON.get(obj, field) + " "));
        return tmp.toString().trim();
    }

    @Override
    public void gcClear() {
        super.gcClear();
        this.metaInfo = null;
    }
}

