/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import org.modellwerkstatt.dataux.runtime.delegates.Delegate;
import org.modellwerkstatt.dataux.runtime.delegates.MetaInfoLocalVar;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaLength;

public class StringDelegate
extends Delegate<String, IToolkit_TextEditor> {
    protected MetaInfoLocalVar<Integer> minimum = new MetaInfoLocalVar<Object>(null);
    protected MetaInfoLocalVar<Integer> maximum = new MetaInfoLocalVar<Object>(null);

    public StringDelegate(IToolkit_UiFactory factory, int langIdx, int numOfLines) {
        super(factory, langIdx);
        this.toolkitEditor = numOfLines == 1 ? factory.createTextEditor() : this.uiFactory.createTextAreaEditor(numOfLines);
        this.toolkitEditor.setDelegate(this);
    }

    public StringDelegate(IToolkit_UiFactory factory, int langIdx) {
        this(factory, langIdx, 1);
    }

    @Override
    public String getValue() {
        if (this.isCurrentlyInOptionalState()) {
            return null;
        }
        return this.toolkitEditor.getText();
    }

    @Override
    public void setValue(String value) {
        if (value != null) {
            this.toolkitEditor.setText(value);
        } else {
            this.toolkitEditor.setText("");
        }
    }

    @Override
    public void load(Object obj) {
        super.load(obj);
        if (this.metaInfo != null) {
            IOFXMetaLength m = (IOFXMetaLength)this.metaInfo;
            this.minimum.setValue(m.getMin());
            this.maximum.setValue(m.getMax());
        }
    }

    @Override
    public String isInputValid() {
        if (!((Boolean)this.enabled.getValue()).booleanValue()) {
            return null;
        }
        this.toolkitEditor.setValidationErrorText("");
        if (this.isCurrentlyInOptionalState()) {
            return null;
        }
        String errText = null;
        if (this.maximum.isValueSet() && ((Boolean)this.enabled.getValue()).booleanValue() && this.getValue().length() > this.maximum.getValue()) {
            errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.STRING_MAX_ERR), "" + this.maximum.getValue());
        }
        if (this.minimum.isValueSet() && ((Boolean)this.enabled.getValue()).booleanValue() && this.getValue().length() < this.minimum.getValue()) {
            errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.STRING_MIN_ERR), "" + this.minimum.getValue());
        }
        if (errText != null) {
            this.toolkitEditor.setValidationErrorText(errText);
        }
        return errText;
    }

    public void setMaxLength(int maxValue) {
        this.maximum.setValue(maxValue);
        this.maximum.setReadOnly();
    }

    public void setMinLength(int minValue) {
        this.minimum.setValue(minValue);
        this.minimum.setReadOnly();
    }

    public void setNumOfLines(int numOfLines) {
    }
}

