/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import org.modellwerkstatt.dataux.runtime.extensions.ITableRowColor;
import org.modellwerkstatt.objectflow.runtime.MoWareFormattersFactory;

public class TableCellBigDecimalConverter
implements ITableCellStringConverter<BigDecimal> {
    private boolean doNotDisplayZeroValue = false;
    private DecimalFormat privatFormatter;
    private ITableRowColor<BigDecimal> colorConv;

    public TableCellBigDecimalConverter(DecimalFormat formatter, boolean noNullOption) {
        this.privatFormatter = formatter;
        this.doNotDisplayZeroValue = noNullOption;
    }

    public TableCellBigDecimalConverter(DecimalFormat formatter, boolean noNullOption, ITableRowColor<BigDecimal> colConv) {
        this.privatFormatter = formatter;
        this.doNotDisplayZeroValue = noNullOption;
        this.colorConv = colConv;
    }

    @Override
    public String convert(BigDecimal obj) {
        if (obj == null) {
            return "";
        }
        if (this.doNotDisplayZeroValue && BigDecimal.ZERO.compareTo(obj) == 0) {
            return "";
        }
        return this.privatFormatter.format(obj);
    }

    @Override
    public boolean isRightAligned() {
        return true;
    }

    @Override
    public String getBgColor(BigDecimal obj) {
        if (this.colorConv != null) {
            return this.colorConv.getColor(obj);
        }
        return null;
    }

    @Override
    public boolean hasDynamicColor() {
        return this.colorConv != null;
    }

    @Override
    public BigDecimal convertBack(String s) {
        try {
            return (BigDecimal)this.privatFormatter.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatterToLocalizedPattern() {
        return this.privatFormatter.toLocalizedPattern();
    }

    public static void main(String[] args) {
        TableCellBigDecimalConverter c = new TableCellBigDecimalConverter(MoWareFormattersFactory.forDecimalFormatPattern((String)"#,##0.00", (String)"de"), false);
        BigDecimal b = new BigDecimal("1111.10");
        System.err.println(">> " + c.convert(b));
        System.err.println(">> " + b.toString());
        System.err.println(">> " + c.formatterToLocalizedPattern());
    }
}

