/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import org.modellwerkstatt.dataux.runtime.delegates.Delegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UploadEditor;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public class UploadDelegate
extends Delegate<String, IToolkit_UploadEditor> {
    public UploadDelegate(IToolkit_UiFactory factory, int langIdx) {
        super(factory, langIdx);
        this.toolkitEditor = factory.createUploadEditor();
        ((IToolkit_UploadEditor)this.toolkitEditor).setDelegate(this);
    }

    @Override
    public void setValue(String value) {
        ((IToolkit_UploadEditor)this.toolkitEditor).setText(value);
    }

    @Override
    public String getValue() {
        String value = ((IToolkit_UploadEditor)this.toolkitEditor).getText();
        if (value != null && value.trim().equals("")) {
            value = null;
        }
        return value;
    }

    @Override
    public String isInputValid() {
        if (!((Boolean)this.enabled.getValue()).booleanValue()) {
            return null;
        }
        ((IToolkit_UploadEditor)this.toolkitEditor).setValidationErrorText("");
        if (this.isCurrentlyInOptionalState()) {
            return null;
        }
        String errText = null;
        String val = this.getValue();
        if (val == null || val.length() < 2) {
            errText = this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.UPLOAD_CONTENT_ERR);
            ((IToolkit_UploadEditor)this.toolkitEditor).setValidationErrorText(errText);
        }
        return errText;
    }
}

