/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.extensions;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.core.BindingImpl;
import org.modellwerkstatt.dataux.runtime.core.IDelegateChange;
import org.modellwerkstatt.dataux.runtime.core.IPagePaneSelCrtl;
import org.modellwerkstatt.dataux.runtime.core.ISelectionController;
import org.modellwerkstatt.dataux.runtime.core.IUpdateConclusionReceiver;
import org.modellwerkstatt.dataux.runtime.extensions.ICustomDataUxElement;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DelegateForm;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.Selection;

public abstract class DynamicListOfDelegates<T>
implements IUpdateConclusionReceiver,
ICustomDataUxElement<T> {
    private IToolkit_DelegateForm uiDelegateForm;
    private IToolkit_UiFactory uiFactory;
    private T boundObject = null;
    protected List<IDataUxDelegate> delegates = ListSequence.fromList(new ArrayList());
    private ISelectionController selController;
    private Class boundClass;
    private boolean delegatesCreated;

    public DynamicListOfDelegates(Class theBoundClass) {
        this.boundClass = theBoundClass;
        this.delegatesCreated = false;
    }

    @Override
    public IToolkit_Form getToolkitImplementation() {
        return this.uiDelegateForm;
    }

    @Override
    public void issueUpdateConclusion(IUpdateConclusionReceiver.IFocusAbleDelegate newFocusHolder) {
        throw new RuntimeException("issueUpdateConclusion() not implemented");
    }

    public void loadDataOnDelegates(T theBoundObject) {
        for (IDataUxDelegate dlgt : this.delegates) {
            dlgt.load(theBoundObject);
        }
    }

    public void storeDataFromDelegates(T theBoundObject) {
        for (IDataUxDelegate dlgt : this.delegates) {
            dlgt.store(theBoundObject);
        }
    }

    public void loadObjectToForm(T objectToLoad) {
        boolean sameObjectLoadedTwice = false;
        if (!this.delegatesCreated) {
            this.delegatesCreated = true;
            this.createDelegatesOnFirstDataLoad(this.uiFactory, objectToLoad);
            for (IDataUxDelegate iDataUxDelegate : this.delegates) {
                this.uiDelegateForm.addDelegate(iDataUxDelegate);
            }
        }
        if (objectToLoad != null && this.boundObject == objectToLoad) {
            sameObjectLoadedTwice = true;
        }
        this.boundObject = objectToLoad;
        IUpdateConclusionReceiver.IFocusAbleDelegate lastFocussed = this.delegateWithFocus();
        for (IDataUxDelegate dlgt : this.delegates) {
            dlgt.setRequestFocus(false);
        }
        this.loadDataOnDelegates(this.boundObject);
        IUpdateConclusionReceiver.IFocusAbleDelegate iFocusAbleDelegate = this.delegateWithFocus();
        if (sameObjectLoadedTwice && iFocusAbleDelegate == null && lastFocussed != null && lastFocussed.isEnabled()) {
            lastFocussed.setRequestFocus(true);
        }
    }

    public IUpdateConclusionReceiver.IFocusAbleDelegate delegateWithFocus() {
        for (IDataUxDelegate dlgt : this.delegates) {
            if (!dlgt.isRequestFocus()) continue;
            return dlgt;
        }
        return null;
    }

    @Override
    public String saveAndValidate() {
        boolean validationError = false;
        String errText = this.uiDelegateForm.checkDelegatesValidAndFocus();
        if (errText == null) {
            this.storeDataFromDelegates(this.boundObject);
        }
        return errText;
    }

    @Override
    public List<IDelegateChange> collectDelegateChanges() {
        return null;
    }

    @Override
    public void forceNotEditable() {
        for (IDataUxDelegate dlgt : this.delegates) {
            dlgt.setDisableFORCE();
        }
    }

    public void clear() {
        this.loadObjectToForm(null);
    }

    @Override
    public void loadList(List<T> objects, IOFXSelection selection) {
        if (selection != null) {
            if (selection.size() == 1) {
                this.loadObjectToForm(selection.getObject());
            } else if (objects.size() == 1) {
                this.selController.pushSelectionAbsolute((IOFXSelection)new Selection(objects.get(0)));
            } else {
                this.clear();
            }
        }
    }

    public void pushSelection(IOFXSelection selection) {
        this.selController.pushSelectionAbsolute(selection);
    }

    @Override
    public boolean selectionChanged(IOFXSelection selection, boolean doNoLoadReloadFollows) {
        if (selection.size() != 1) {
            this.clear();
        } else if (!doNoLoadReloadFollows) {
            this.loadObjectToForm(selection.getObject());
        }
        return true;
    }

    public IOFXSelection getSelection(Class clazz, boolean includingDerived) {
        return this.selController.getSelectionAbsolute(clazz, includingDerived);
    }

    public abstract List<String> getColumnConstraints();

    public abstract BindingImpl getBinding();

    public abstract void createDelegatesOnFirstDataLoad(IToolkit_UiFactory var1, T var2);

    @Override
    public void initializeGen(IToolkit_UiFactory factory, IPagePaneSelCrtl pageCrtl, ISelectionController.Binding externalBinding, Menu externalMenu) {
        this.uiFactory = factory;
        this.uiDelegateForm = factory.createToolkitDelegateForm();
        this.uiDelegateForm.setColLayoutConstraints(this.getColumnConstraints());
        this.selController = externalBinding != null ? pageCrtl.registerSelControlled(this.boundClass, externalBinding, this) : pageCrtl.registerSelControlled(this.boundClass, this.getBinding(), this);
    }

    @Override
    public void addDelegateInfo(String delegateName, String path, String label) {
    }

    @Override
    public void gcClear() {
        for (IDataUxDelegate dlgt : this.delegates) {
            dlgt.gcClear();
        }
        this.uiFactory = null;
        this.selController = null;
        this.boundObject = null;
        this.uiDelegateForm = null;
    }
}

