/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.httpapi;

import java.util.HashMap;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiOperationBase;
import org.modellwerkstatt.dataux.runtime.httpapi.IApiGen;

public abstract class ApiDescription
implements IApiGen {
    private String shortName;
    private int apiVersion;
    private HashMap<String, ApiOperationBase> operations = new HashMap();

    public ApiDescription(String name, int apiVers) {
        this.shortName = name;
        this.apiVersion = apiVers;
    }

    @Override
    public String getApiShortName() {
        return this.shortName;
    }

    @Override
    public int getApiVersion() {
        return this.apiVersion;
    }

    private String keyFor(String loc, String method) {
        return method.toLowerCase() + "-" + loc;
    }

    @Override
    public boolean hasOperation(String loc, String method) {
        String key = this.keyFor(loc, method);
        return this.operations.containsKey(key);
    }

    @Override
    public ApiOperationBase getOperationOrNull(String loc, String method) {
        String key = this.keyFor(loc, method);
        return this.operations.get(key);
    }

    public void addOperation(ApiOperationBase op) {
        String key = this.keyFor(op.getLocation(), op.getMethod());
        this.operations.put(key, op);
    }

    @Override
    public String printDebugInfo() {
        Object st = "Operations \n";
        for (String key : this.operations.keySet()) {
            st = (String)st + "- " + key + " is " + this.operations.get(key) + "\n";
        }
        return st;
    }
}

