/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.httpapi;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modellwerkstatt.dataux.runtime.common.IRemoteIpNginx;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiException;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiOperationBase;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiUserService;
import org.modellwerkstatt.dataux.runtime.httpapi.IApiErrorReporter;
import org.modellwerkstatt.dataux.runtime.httpapi.IApiGen;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.manmap.runtime.IM3DatabaseDescription;
import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;
import org.modellwerkstatt.objectflow.runtime.OFXStringFormatter2;
import org.modellwerkstatt.objectflow.runtime.UserEnvironmentInformation;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ApiLoader
extends HttpServlet
implements IRemoteIpNginx {
    public static final String INTERNAL_VERSION = "moware 11 api (winter 24)";
    private AbstractApplicationContext springAppContext;
    private IOFXApplicationFactory appFactory;
    private String apiDescFqName;
    private String nameVersion = "-";
    private IApiGen iApiGen;
    private AppJmxRegistration jmxRegistration;
    private String deployedAsVersion = "0";
    private String guessedServerName;
    private IOFXUserEnvironment apiWideUserEnv = null;
    private IApiErrorReporter globalErrorReporter;

    public void init() throws ServletException {
        super.init();
        Dux.init("/Users/danielstieger/ApiHardlog.log");
        String xmlConfigFile = this.getInitParameter("xmlConfigFile");
        this.springAppContext = new ClassPathXmlApplicationContext(xmlConfigFile);
        this.appFactory = (IOFXApplicationFactory)this.springAppContext.getBean(IOFXApplicationFactory.class);
        String servletPath = this.getServletContext().getContextPath();
        this.guessedServerName = System.getProperty("server.instancename");
        this.apiDescFqName = this.getInitParameter("applicationFqName");
        String realPath = this.getServletContext().getRealPath("/");
        int startOfVersion = realPath.indexOf("##");
        if (startOfVersion > 0 && realPath.length() > startOfVersion + 2) {
            this.deployedAsVersion = realPath.substring(startOfVersion + 2);
            this.deployedAsVersion = this.deployedAsVersion.substring(0, this.deployedAsVersion.length() - 1);
        }
        this.jmxRegistration = new AppJmxRegistration(this.apiDescFqName, this.deployedAsVersion, servletPath, servletPath);
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> appBehaviorClass = classLoader.loadClass(this.apiDescFqName);
            this.iApiGen = (IApiGen)this.springAppContext.getAutowireCapableBeanFactory().createBean(appBehaviorClass);
            this.nameVersion = this.iApiGen.getApiShortName() + "_" + this.iApiGen.getApiVersion();
            ((IM3DatabaseDescription)this.springAppContext.getBean(IM3DatabaseDescription.class)).setSessionInfo(this.nameVersion + " " + this.iApiGen.getApiImplVersion() + " " + this.guessedServerName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            this.apiWideUserEnv = (IOFXUserEnvironment)this.springAppContext.getBean(IOFXUserEnvironment.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.apiWideUserEnv = null;
        }
        this.globalErrorReporter = this.iApiGen.initApiDescription();
        this.jmxRegistration.registerAppTelemetrics(this.appFactory, this.apiDescFqName, this.nameVersion, this.iApiGen.getApiImplVersion(), MoWareTranslations.Key.MOWARE_VERSION.getLangDefault() + " - moware 11 api (winter 24)", this.guessedServerName);
    }

    public CoreReporterInfo appCoreReporterInfo(int uId, String uName, String devRemoteAdr, IOFXCoreReporter.LogPriority prio, String cmdOrOp, String desc) {
        CoreReporterInfo info = new CoreReporterInfo(IOFXCoreReporter.Type.APP_PROBLEM, this.apiDescFqName, this.iApiGen.getApiImplVersion(), "org.modellwerkstatt.RT", cmdOrOp, "", prio, uId, uName, "", "", devRemoteAdr, "moware11 2025.24 (dck)", IOFXCoreReporter.MoWarePlatform.MOWARE_API, this.guessedServerName, desc);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApiOperationBase op;
        long requestMillis = System.currentTimeMillis();
        String urlToMatch = req.getServletPath();
        if (urlToMatch.endsWith("/")) {
            urlToMatch = urlToMatch.substring(0, urlToMatch.length() - 1);
        }
        if ((op = this.iApiGen.getOperationOrNull(urlToMatch, req.getMethod())) != null) {
            IOFXUserEnvironment userEnv;
            String remoteAddr;
            block19: {
                IOFXSession session = null;
                remoteAddr = this.getRemoteAddr(req);
                if (this.apiWideUserEnv != null) {
                    userEnv = this.apiWideUserEnv;
                } else {
                    userEnv = new UserEnvironmentInformation();
                    userEnv.adjustDeviceId(remoteAddr);
                }
                try {
                    ApiUserService userServivce = new ApiUserService(this.appFactory, this.apiDescFqName, this.iApiGen.getApiImplVersion(), userEnv, remoteAddr, this.guessedServerName);
                    session = this.appFactory.createNewSession(userEnv, (IOFXUserServices)userServivce);
                    try {
                        Dux.hl("executing operation " + op);
                        op.executeOp(req, resp, session);
                        long diff = System.currentTimeMillis() - requestMillis;
                        CoreReporterInfo info = this.appCoreReporterInfo(userEnv.getUserId(), userEnv.getUserName(), remoteAddr, IOFXCoreReporter.LogPriority.INFO, op.getLocation(), "served request successfully");
                        info.addParameter("diff", (Object)diff);
                        this.appFactory.report(info);
                    }
                    catch (OFXShutDownSessionException ex) {
                        CoreReporterInfo info = this.appCoreReporterInfo(userEnv.getUserId(), userEnv.getUserName(), remoteAddr, IOFXCoreReporter.LogPriority.ERROR, op.getLocation(), "Guard");
                        info.setSource("org.modellwerkstatt.Exception");
                        info.setException((Throwable)ex);
                        info.addParameter("param", (Object)ex.getProblem().getSimpleUserText());
                        this.appFactory.report(info);
                        this.globalErrorReporter.reportInternalProblem(resp, null);
                    }
                    catch (OFXAbortedException aported) {
                        List problems = session.getAndclearProblemState();
                        IOFXProblem guard = OFXConsoleHelper.containsGuard((List)problems);
                        String desc = OFXConsoleHelper.asSimpleString((List)problems);
                        CoreReporterInfo info = this.appCoreReporterInfo(userEnv.getUserId(), userEnv.getUserName(), remoteAddr, IOFXCoreReporter.LogPriority.INFO, op.getLocation(), "Operation aborted due to preconditions.\n" + desc);
                        this.appFactory.report(info);
                        if (guard == null) {
                            this.globalErrorReporter.reportOfxProblems(resp, problems);
                            break block19;
                        }
                        throw new RuntimeException("This should not happen. We have a guard in an OFXAportedException (" + guard.getSimpleUserText(), guard.getForwardedEx());
                    }
                }
                catch (ApiException apiEx) {
                    this.appFactory.report(this.appCoreReporterInfo(userEnv.getUserId(), userEnv.getUserName(), remoteAddr, IOFXCoreReporter.LogPriority.INFO, op.getLocation(), "Client request resulted in api problem " + apiEx.getErrorName() + " " + apiEx.getMessage()));
                    this.globalErrorReporter.reportApiExFieldNamesProblem(resp, apiEx);
                }
                catch (SerdesException ex) {
                    this.appFactory.report(this.appCoreReporterInfo(userEnv.getUserId(), userEnv.getUserName(), remoteAddr, IOFXCoreReporter.LogPriority.INFO, op.getLocation(), "Client request resulted in api/serdes problem " + ex.getMessage()));
                    this.globalErrorReporter.reportSerdesProblem(resp, ex);
                }
                catch (Exception ex) {
                    this.jmxRegistration.getAppTelemetrics().incException();
                    CoreReporterInfo info = this.appCoreReporterInfo(userEnv.getUserId(), userEnv.getUserName(), remoteAddr, IOFXCoreReporter.LogPriority.ERROR, op.getLocation(), "Tec. exception while processing request.");
                    info.setException((Throwable)ex);
                    this.appFactory.report(info);
                    this.globalErrorReporter.reportInternalProblem(resp, ex);
                }
                finally {
                    if (session != null) {
                        session.closeSessionAndfreeGC();
                    }
                }
            }
            this.jmxRegistration.getAppTelemetrics().applicationLog(userEnv.getUserName() + " " + remoteAddr, "processed " + op.getLocation() + " in " + (System.currentTimeMillis() - requestMillis));
            this.jmxRegistration.getAppTelemetrics().servedRequest("api request " + this.nameVersion, userEnv.getUserName(), "operation " + op.getLocation(), requestMillis);
        } else {
            CoreReporterInfo info = this.appCoreReporterInfo(-1, "", this.getRemoteAddr(req), IOFXCoreReporter.LogPriority.INFO, "", "No operation for '" + urlToMatch + "' in this api description.");
            this.appFactory.report(info);
            this.globalErrorReporter.notFound(resp);
        }
    }

    public void destroy() {
        this.jmxRegistration.gcClean();
        String msg = OFXConsoleHelper.closeConnectionPoolExplicitly((AbstractApplicationContext)this.springAppContext);
        if (msg != null) {
            super.log(msg);
        }
        this.springAppContext.close();
        this.springAppContext = null;
        DeprecatedServerDateProvider.shutdownAndGcClean();
        MMStaticAccessHelper.shutdownAndGcClean();
        OFXStringFormatter2.GLOBAL_INSTANCE_DEFAULT_LANG = null;
        super.destroy();
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

