/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.httpapi;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import mjson.Json;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiException;
import org.modellwerkstatt.dataux.runtime.httpapi.IApiErrorReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.sdservices.JackyInfra;
import org.modellwerkstatt.objectflow.serdes.SerdesException;

public class JSonApiErrorReporter
implements IApiErrorReporter {
    private static final boolean PRETTY_PRINT = false;
    private static final int API_UNPROCESSABLE_CONTENT = 422;
    private JackyInfra infra;

    public JSonApiErrorReporter(JackyInfra jackyInfra) {
        this.infra = jackyInfra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportApiExFieldNamesProblem(HttpServletResponse resp, ApiException ex) throws IOException {
        JsonGenerator gen = null;
        String result = "";
        try {
            try (StringWriter sw = new StringWriter();){
                gen = this.infra.createGenerator(sw, false);
                gen.writeStartObject();
                gen.writeNumberField("status", 422);
                gen.writeStringField("error", "UNPROCESSABLE_CONTENT");
                gen.writeStringField("desc", ex.getMessage());
                gen.writeNullField("data");
                gen.writeNullField("problems");
                gen.writeEndObject();
                gen.close();
                gen = null;
                result = sw.toString();
            }
            this.ensureClosed(gen);
        }
        catch (Throwable throwable) {
            this.ensureClosed(gen);
            throw throwable;
        }
        resp.setStatus(422);
        resp.setContentType("application/json");
        resp.getWriter().write(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportSerdesProblem(HttpServletResponse resp, SerdesException ex) throws IOException {
        JsonGenerator gen = null;
        String result = "";
        try {
            try (StringWriter sw = new StringWriter();){
                gen = this.infra.createGenerator(sw, false);
                gen.writeStartObject();
                gen.writeNumberField("status", 422);
                gen.writeStringField("error", "UNPROCESSABLE_CONTENT");
                gen.writeStringField("desc", ex.getMessage());
                gen.writeNullField("data");
                gen.writeNullField("problems");
                gen.writeEndObject();
                gen.close();
                gen = null;
                result = sw.toString();
            }
            this.ensureClosed(gen);
        }
        catch (Throwable throwable) {
            this.ensureClosed(gen);
            throw throwable;
        }
        resp.setStatus(422);
        resp.setContentType("application/json");
        resp.getWriter().write(result);
    }

    public static void writeProblems(JsonGenerator gen, List<IOFXProblem> problms) throws IOException {
        gen.writeArrayFieldStart("problems");
        for (IOFXProblem prbml : problms) {
            gen.writeStartObject();
            gen.writeStringField("desc", prbml.getProblemDescOrNull());
            gen.writeStringField("instance", prbml.getInstanceDescOrNull());
            gen.writeStringField("priority", "" + prbml.translatedLogPrio());
            gen.writeBooleanField("warningOnly", prbml.isWarningOnly());
            HashMap customMap = prbml.getPropMapOrNull();
            if (customMap != null) {
                for (String key : customMap.keySet()) {
                    gen.writeStringField("_" + key, "" + customMap.get(key));
                }
            }
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportOfxProblems(HttpServletResponse resp, List<IOFXProblem> problms) throws IOException {
        JsonGenerator gen = null;
        String result = "";
        try {
            try (StringWriter sw = new StringWriter();){
                gen = this.infra.createGenerator(sw, false);
                gen.writeStartObject();
                gen.writeNumberField("status", 202);
                gen.writeStringField("error", "ACCEPTED");
                gen.writeStringField("desc", "request accepted, processing not completed");
                gen.writeNullField("data");
                JSonApiErrorReporter.writeProblems(gen, problms);
                gen.writeEndObject();
                gen.close();
                gen = null;
                result = sw.toString();
            }
            this.ensureClosed(gen);
        }
        catch (Throwable throwable) {
            this.ensureClosed(gen);
            throw throwable;
        }
        resp.setStatus(202);
        resp.setContentType("application/json");
        resp.getWriter().write(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportInternalProblem(HttpServletResponse resp, Exception ex) throws IOException {
        JsonGenerator gen = null;
        String result = "";
        try {
            try (StringWriter sw = new StringWriter();){
                gen = this.infra.createGenerator(sw, false);
                gen.writeStartObject();
                gen.writeNumberField("status", 500);
                gen.writeStringField("error", "INTERNAL_SERVER_ERROR");
                gen.writeStringField("desc", "internal server error");
                gen.writeNullField("data");
                gen.writeNullField("problems");
                gen.writeEndObject();
                gen.close();
                gen = null;
                result = sw.toString();
            }
            this.ensureClosed(gen);
        }
        catch (Throwable throwable) {
            this.ensureClosed(gen);
            throw throwable;
        }
        resp.setStatus(500);
        resp.setContentType("application/json");
        resp.getWriter().write(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notFound(HttpServletResponse resp) throws IOException {
        JsonGenerator gen = null;
        String result = "";
        try {
            try (StringWriter sw = new StringWriter();){
                gen = this.infra.createGenerator(sw, false);
                gen.writeStartObject();
                gen.writeNumberField("status", 404);
                gen.writeStringField("error", "NOT_FOUND");
                gen.writeStringField("desc", "operation not found");
                gen.writeNullField("data");
                gen.writeNullField("problems");
                gen.writeEndObject();
                gen.close();
                gen = null;
                result = sw.toString();
            }
            this.ensureClosed(gen);
        }
        catch (Throwable throwable) {
            this.ensureClosed(gen);
            throw throwable;
        }
        resp.setStatus(404);
        resp.setContentType("application/json");
        resp.getWriter().write(result);
    }

    private void ensureClosed(JsonGenerator gen) {
        if (gen != null) {
            try {
                gen.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Json convertResult(String st) {
        return Json.read((String)st);
    }

    public static void main(String[] args) {
        String precond = "{\"status\":202,\"error\":\"ACCEPTED\",\"desc\":\"request accepted, processing not completed\",\"problems\":[{\"desc\":\"precondition 1 - with props and instance\",\"instance\":\"instance4711\",\"priority\":\"ERROR\",\"_myprop2\":\"4712\",\"_myporp1\":\"4711\"},{\"desc\":\"precondition 2 - no props\",\"instance\":null,\"priority\":\"INFO\"},{\"desc\":\"precondition 3 - Warning hint\",\"instance\":null,\"priority\":\"INFO\",\"warningOnly\":true}]}\n    ";
        String notfound = "{\"status\":404,\"error\":\"NOT_FOUND\",\"desc\":\"operation not found\"}";
        Json res = JSonApiErrorReporter.convertResult(notfound);
        System.err.println(res.at("status").asInteger());
        System.err.println(res.at("error").asString());
        System.err.println(res.at("desc").asString());
        res = JSonApiErrorReporter.convertResult(precond);
        System.err.println(((Json)res.at("problems").asJsonList().get(0)).at("desc"));
        System.err.println(((Json)res.at("problems").asJsonList().get(1)).at("desc"));
    }
}

