/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.telemetrics;

import java.util.HashMap;
import org.modellwerkstatt.dataux.runtime.core.ApplicationReporter;
import org.modellwerkstatt.dataux.runtime.core.BaseUiFactory;
import org.modellwerkstatt.dataux.runtime.telemetrics.ApplicationTelemetrics;
import org.modellwerkstatt.dataux.runtime.telemetrics.ParDeployAutoForwarder;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.objectflow.runtime.StaticJmxAccess;

public class AppJmxRegistration {
    private static final String telemetricsServiceName = ":type=ApplicationTelemetrics";
    private static final String clientServiceName = ":type=ClientTelemetrics, name=";
    private String namePrefix;
    private ApplicationTelemetrics appTelemetrics;
    private String servletBasePath;
    private String homeScreenPath;
    private HashMap<String, Boolean> currentInstanceNames = new HashMap();
    private ParDeployAutoForwarder autoForwarder;

    public AppJmxRegistration(String appBehaviourFqName, String namePostFix, String servletPath, String homePath) {
        if (appBehaviourFqName == null) {
            appBehaviourFqName = "unknown.unknown";
        }
        this.namePrefix = appBehaviourFqName + "_" + namePostFix;
        this.servletBasePath = servletPath;
        this.homeScreenPath = homePath;
    }

    public void registerAppTelemetrics(final IOFXApplicationFactory factory, String appFqName, String appName, String appVersion, String frameworkVersion, String guessedServerName) {
        this.autoForwarder = new ParDeployAutoForwarder(appName, appVersion);
        this.appTelemetrics = new ApplicationTelemetrics(appFqName, appName + " " + appVersion, this.servletBasePath, this.homeScreenPath, factory.getConnectionUrl(), frameworkVersion, guessedServerName, factory.getSettingsDescription(), "");
        this.appTelemetrics.setUiFactDynInfo(new ApplicationTelemetrics.DynamicInfo(){

            @Override
            public String getDescription() {
                return factory.getStatusDescription();
            }
        });
        this.appTelemetrics.setAutoParDeplyDynInfo(new ApplicationTelemetrics.DynamicInfo(){

            @Override
            public String getDescription() {
                return AppJmxRegistration.this.autoForwarder.getAutoParDeploySettings();
            }
        });
        this.appTelemetrics.setAutoParDeplyToCurrentVersion(new ApplicationTelemetrics.DynamicAction(){

            @Override
            public String execAction() {
                return AppJmxRegistration.this.autoForwarder.setToCurrentVersion();
            }
        });
        if (factory instanceof BaseUiFactory) {
            this.appTelemetrics.setResetEventBusAction(new ApplicationTelemetrics.DynamicAction(){

                @Override
                public String execAction() {
                    return ((BaseUiFactory)factory).getEventBus().testReset();
                }
            });
        }
        String nameToRegister = this.namePrefix + telemetricsServiceName;
        StaticJmxAccess.register((Object)this.appTelemetrics, (String)nameToRegister);
    }

    public void enableAutoForwardGracefully() {
        this.autoForwarder.updateParDeployInfo();
    }

    public boolean checkMarkAsForwardGracyFully() {
        boolean oldVersion = this.autoForwarder.checkIsOldVersion();
        if (oldVersion && !this.appTelemetrics.isParDeploymentForwardGracefully()) {
            this.appTelemetrics.parDeployForwardGracefully(true);
        }
        return oldVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClient(ApplicationReporter clientTelemetrics) {
        AppJmxRegistration appJmxRegistration = this;
        synchronized (appJmxRegistration) {
            String instName = clientTelemetrics.getuser_jmxInstanceName();
            Object suggested = instName;
            Object suffix = "";
            for (int i = 1; i < 1000; ++i) {
                if (!this.currentInstanceNames.containsKey(suggested)) {
                    this.currentInstanceNames.put((String)suggested, true);
                    clientTelemetrics.setJmxUniqueNameSuffix((String)suffix);
                    break;
                }
                suffix = " " + i;
                suggested = instName + (String)suffix;
            }
        }
        String nameToReg = this.namePrefix + clientServiceName + clientTelemetrics.getuser_jmxInstanceName();
        StaticJmxAccess.register((Object)clientTelemetrics, (String)nameToReg);
        this.appTelemetrics.incClient();
    }

    public void unregisterClient(ApplicationReporter clientTelemetrics) {
        String instanceName = clientTelemetrics.getuser_jmxInstanceName();
        String nameToUnreg = this.namePrefix + clientServiceName + instanceName;
        StaticJmxAccess.unregister((String)nameToUnreg);
        this.currentInstanceNames.remove(instanceName);
        this.appTelemetrics.decClient();
    }

    public boolean markedAsOld() {
        return this.appTelemetrics.isParDeploymentForwardGracefully() || this.appTelemetrics.isParDeploymentForwardImmediate();
    }

    public ApplicationTelemetrics getAppTelemetrics() {
        return this.appTelemetrics;
    }

    public void gcClean() {
        String nameToUnRegister = this.namePrefix + telemetricsServiceName;
        StaticJmxAccess.unregister((String)nameToUnRegister);
        this.appTelemetrics.gcClean();
        this.currentInstanceNames.clear();
        this.autoForwarder = null;
    }

    public static void main(String[] args) {
    }
}

