/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.telemetrics;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.joda.time.DateTime;

public class Dux {
    public static boolean DEBUG_HARDLOG = true;
    private static String hardLogFileName;
    private static boolean HARDLOG_AVAILABLE;

    public static void init(String fileName) {
        hardLogFileName = fileName;
        try {
            File fhl = new File(hardLogFileName);
            HARDLOG_AVAILABLE = DEBUG_HARDLOG && (fhl.exists() || fhl.createNewFile());
        }
        catch (IOException e) {
            HARDLOG_AVAILABLE = false;
        }
        Dux.clearHardLog();
        Dux.hl("_ _ _ _ hard log startup " + hardLogFileName + " _ _ _ _");
    }

    public static void hl(String text) {
        if (!HARDLOG_AVAILABLE) {
            return;
        }
        try {
            File logFile = new File(hardLogFileName);
            FileOutputStream out = new FileOutputStream(hardLogFileName, logFile.exists());
            PrintWriter writer = new PrintWriter(out);
            DateTime dt = new DateTime();
            String time = dt.getHourOfDay() + ":" + dt.getMinuteOfHour() + ":" + dt.getSecondOfMinute() + "." + dt.getMillisOfSecond();
            String methodName = Thread.currentThread().getStackTrace()[2].getMethodName() + "()";
            writer.println(String.format("%9s %35s %s", time, methodName, text));
            writer.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            HARDLOG_AVAILABLE = false;
        }
        catch (IOException e) {
            e.printStackTrace();
            HARDLOG_AVAILABLE = false;
        }
    }

    private static void clearHardLog() {
        File logFile;
        if (HARDLOG_AVAILABLE && (logFile = new File(hardLogFileName)).exists()) {
            logFile.delete();
        }
    }

    public static String sessionToString(HttpSession session) {
        StringBuilder sb = new StringBuilder();
        sb.append("AttributeNames:\n");
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String key = (String)attributeNames.nextElement();
            String value = session.getAttribute(key).toString();
            sb.append("     " + key + ": " + value);
        }
        return sb.toString();
    }

    public static String requestToString(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append("Method: " + request.getMethod() + "\n");
        sb.append("HeaderNames: \n");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            sb.append("     " + key + ": " + value + "\n");
        }
        sb.append("\nAttributeNames:\n");
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String key = (String)attributeNames.nextElement();
            Iterator value = request.getAttribute(key).toString();
            sb.append("     " + key + ": " + (String)((Object)value));
        }
        sb.append("\nParameters\n");
        Map paramMap = request.getParameterMap();
        for (String key : paramMap.keySet()) {
            sb.append("     " + key + ": ");
            for (String value : (String[])paramMap.get(key)) {
                sb.append("'" + value + "' ");
            }
            sb.append("\n");
        }
        sb.append("\nParts:\n");
        try {
            for (Part part : request.getParts()) {
                sb.append("\nPart\n");
                sb.append("part.name '" + part.getName() + "', ");
                sb.append("part.submittedFileName '" + part.getSubmittedFileName() + "', ");
                sb.append("part.contentType '" + part.getContentType() + "', ");
                sb.append("part.size '" + part.getSize() + "'\n");
                for (String st : part.getHeaderNames()) {
                    sb.append("part.headerName." + st + ": '" + part.getHeader(st) + "',");
                }
                sb.append("\n");
            }
        }
        catch (IOException e) {
            sb.append("request.getParts() IOExcetion: " + e.getMessage());
        }
        catch (ServletException e) {
            sb.append("request.getParts() ServletException: " + e.getMessage());
        }
        return sb.toString();
    }
}

