/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.utils;

import java.util.List;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ListSequence;

public class LayoutConstraint {
    private int pxl;
    private boolean isPxl = false;
    private boolean minimal = false;
    private int percent = 0;

    public LayoutConstraint(String cfg) {
        try {
            this.pxl = Integer.parseInt(cfg);
            if (this.pxl < 0) {
                this.minimal = true;
            } else {
                this.isPxl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!this.isPxl && cfg.contains("*")) {
            this.percent = Integer.parseInt(cfg.replace("*", ""));
        }
    }

    public int getInPercent() {
        return this.percent;
    }

    public int getPixl() {
        return this.pxl;
    }

    public boolean isPxl() {
        return this.isPxl;
    }

    public boolean isMinimal() {
        return this.minimal;
    }

    public void setTotalWeight(int totalweight) {
        if (!this.isPxl && totalweight > 0) {
            this.percent = 100 * this.percent / totalweight;
        }
    }

    public static int calcTotalWeight(List<LayoutConstraint> lc) {
        Wrappers._int totalWeight = new Wrappers._int(0);
        ListSequence.fromList(lc).where(it -> !it.isPxl() && !it.isMinimal()).visitAll(it -> totalWeight.value += it.getInPercent());
        return totalWeight.value;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(pxl?" + this.isPxl + "  minimal?" + this.minimal + "  percent?" + this.percent + ")");
        return b.toString();
    }
}

