/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.utils;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.utils.MoBeanAdapter;

public class MoJSON {
    public static <T> T get(Object root, String path) {
        return MoJSON.get(root, MoJSON.parse(path));
    }

    public static <T> T get(Object root, List<String> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("keys is null.");
        }
        Object value = root;
        int n = ListSequence.fromList(keys).count();
        for (int i = 0; i < n && value != null; ++i) {
            MoBeanAdapter adapter = new MoBeanAdapter(value);
            String key = (String)ListSequence.fromList(keys).getElement(i);
            if (!adapter.containsKey(key)) {
                throw new IllegalArgumentException("Property \"" + key + "\" not found.");
            }
            value = adapter.get(key);
        }
        return (T)value;
    }

    public static <T> T put(Object root, String path, T value) {
        if (root == null) {
            throw new IllegalArgumentException("root is null.");
        }
        List<String> keys = MoJSON.parse(path);
        if (ListSequence.fromList(keys).count() == 0) {
            throw new IllegalArgumentException("Path is empty.");
        }
        String key = (String)ListSequence.fromList(keys).last();
        ListSequence.fromList(keys).removeLastElement();
        T parent = MoJSON.get(root, keys);
        if (parent == null) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        MoBeanAdapter adapter = new MoBeanAdapter(parent);
        if (!adapter.containsKey(key)) {
            throw new IllegalArgumentException("Property \"" + key + "\" not found.");
        }
        Object previousValue = adapter.put(key, value);
        return (T)previousValue;
    }

    public static List<String> parse(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        IListSequence keys = ListSequence.fromList(new ArrayList());
        int i = 0;
        int n = path.length();
        while (i < n) {
            boolean bracketed;
            char c = path.charAt(i++);
            StringBuilder identifierBuilder = new StringBuilder();
            boolean bl = bracketed = c == '[';
            if (bracketed && i < n) {
                boolean quoted;
                c = path.charAt(i++);
                char quote = '\u0000';
                boolean bl2 = quoted = c == '\"' || c == '\'';
                if (quoted && i < n) {
                    quote = c;
                    c = path.charAt(i++);
                }
                while (i <= n && bracketed) {
                    bracketed = quoted || c != ']';
                    if (!bracketed) continue;
                    if (c == quote && i < n) {
                        boolean bl3 = quoted = (c = path.charAt(i++)) == quote;
                    }
                    if (!quoted && c == ']') continue;
                    if (Character.isISOControl(c)) {
                        throw new IllegalArgumentException("Illegal identifier character.");
                    }
                    identifierBuilder.append(c);
                    if (i >= n) continue;
                    c = path.charAt(i++);
                }
                if (quoted) {
                    throw new IllegalArgumentException("Unterminated quoted identifier.");
                }
                if (bracketed) {
                    throw new IllegalArgumentException("Unterminated bracketed identifier.");
                }
                if (i < n && (c = path.charAt(i)) == '.') {
                    ++i;
                }
            } else {
                while (i <= n && c != '.' && c != '[') {
                    if (!Character.isJavaIdentifierPart(c)) {
                        throw new IllegalArgumentException("Illegal identifier character.");
                    }
                    identifierBuilder.append(c);
                    if (i < n) {
                        c = path.charAt(i);
                    }
                    ++i;
                }
                if (c == '[') {
                    --i;
                }
            }
            if (c == '.' && i == n) {
                throw new IllegalArgumentException("Path cannot end with a '.' character.");
            }
            if (identifierBuilder.length() == 0) {
                throw new IllegalArgumentException("Missing identifier.");
            }
            ListSequence.fromList((List)keys).addElement((Object)identifierBuilder.toString());
        }
        return keys;
    }
}

