/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;
import org.modellwerkstatt.objectflow.runtime.IOFXValueObject;

public class ValueObjectReplacementFacility {
    public static IOFXValueObject getValueObjectOrNull(Object obj, String propertyName) {
        Object valueObject = MoJSON.get(obj, propertyName);
        if (valueObject instanceof IOFXValueObject) {
            return (IOFXValueObject)valueObject;
        }
        return null;
    }

    public static Object execWithMethod(Object obj, String propertyName, Object param1) {
        Method method = null;
        String withMethod = "with" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            if (param1 instanceof Integer) {
                method = obj.getClass().getMethod(withMethod, Integer.TYPE);
                return method.invoke(obj, param1);
            }
            if (param1 == null) {
                Method[] allMethods;
                for (Method m : allMethods = obj.getClass().getMethods()) {
                    if (!m.getName().equals(withMethod)) continue;
                    if (method != null) {
                        throw new RuntimeException("ValueObjectReplacementFacility - Looking for '" + withMethod + "' with <unknown> parameter (for setting null), but multiple methods with same name found.");
                    }
                    method = m;
                }
                if (method == null) {
                    throw new RuntimeException("ValueObjectReplacementFacility - Looking for '" + withMethod + "' with <unknown> parameter (for setting null), but none found.");
                }
                return method.invoke(obj, new Object[]{null});
            }
            method = obj.getClass().getMethod(withMethod, param1.getClass());
            return method.invoke(obj, param1);
        }
        catch (SecurityException e) {
            throw new RuntimeException("ValueObjectReplacementFacility - SecurityException - " + e.getMessage() + " / " + propertyName + " to '" + param1 + "'");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("ValueObjectReplacementFacility - NoSuchMethodException - " + e.getMessage() + " / " + propertyName + " to '" + param1 + "'");
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("ValueObjectReplacementFacility - IllegalArgumentException - " + e.getMessage() + " / " + propertyName + " to '" + param1 + "'");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("ValueObjectReplacementFacility - IllegalAccessException - " + e.getMessage() + " / " + propertyName + " to '" + param1 + "'");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("ValueObjectReplacementFacility - InvocationTargetException - " + e.getMessage() + " / " + propertyName + " to '" + param1 + "'");
        }
    }

    public static void put(Object rootObj, String propPath, Object value) {
        Object currentValue = MoJSON.get(rootObj, propPath);
        if (currentValue == null ? currentValue == value : currentValue.equals(value)) {
            return;
        }
        if (rootObj instanceof IOFXValueObject) {
            throw new RuntimeException("ValueObjectReplacementFacility - ValueObject directly bound to Delegates - thus no exchange of ValueObjects possible. Programming Error!");
        }
        if (propPath.contains(".")) {
            String remainingPath = propPath.substring(0, propPath.lastIndexOf("."));
            String fieldName = propPath.substring(propPath.lastIndexOf(".") + 1);
            IOFXValueObject valueObj = ValueObjectReplacementFacility.getValueObjectOrNull(rootObj, remainingPath);
            if (valueObj != null) {
                Object newValueObject = ValueObjectReplacementFacility.execWithMethod(valueObj, fieldName, value);
                ValueObjectReplacementFacility.put(rootObj, remainingPath, newValueObject);
                return;
            }
        }
        MoJSON.put(rootObj, propPath, value);
    }
}

